/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.source.FileRegistry;
import org.graalvm.visualizer.source.GraphSource;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

class GraphSourceRegistry {
    private final FileRegistry fileRegistry;
    private final Map<InputGraph, Reference<GraphSource>> graphSources = new WeakHashMap<InputGraph, Reference<GraphSource>>();
    private final Map<String, Lookup> serviceLookups = new HashMap<String, Lookup>();
    private static GraphSourceRegistry INSTANCE;

    GraphSourceRegistry(FileRegistry fileRegistry) {
        this.fileRegistry = fileRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphSourceRegistry getDefault() {
        Class<GraphSourceRegistry> clazz = GraphSourceRegistry.class;
        synchronized (GraphSourceRegistry.class) {
            if (INSTANCE == null) {
                INSTANCE = new GraphSourceRegistry((FileRegistry)Lookup.getDefault().lookup(FileRegistry.class));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphSource getSource(InputGraph g) {
        GraphSourceRegistry graphSourceRegistry = this;
        synchronized (graphSourceRegistry) {
            GraphSource s;
            Reference<GraphSource> rsrc = this.graphSources.get(g);
            if (rsrc != null && (s = rsrc.get()) != null) {
                return s;
            }
            s = new GraphSource(g, this.fileRegistry);
            this.graphSources.put(g, new WeakReference<GraphSource>(s));
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Lookup providerLookup(String mime) {
        Lookup lkp;
        GraphSourceRegistry graphSourceRegistry = this;
        synchronized (graphSourceRegistry) {
            lkp = this.serviceLookups.get(mime);
            if (lkp != null) {
                return lkp;
            }
        }
        Lookup mimeLkp = MimeLookup.getLookup((String)mime);
        lkp = new ProxyLookup(new Lookup[]{mimeLkp, Lookup.getDefault()});
        GraphSourceRegistry graphSourceRegistry2 = this;
        synchronized (graphSourceRegistry2) {
            this.serviceLookups.put(mime, lkp);
        }
        return lkp;
    }

    static synchronized void _testReset() {
        FileRegistry._testReset();
        INSTANCE = new GraphSourceRegistry(FileRegistry.getInstance());
    }
}

