/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.SpecificLocationInfo;
import org.graalvm.visualizer.source.StackData;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public final class NodeStack
implements Iterable<Frame> {
    private final GraphSource source;
    private final StackData internalStack;
    private final InputGraph graph;
    private final Frame[] frames;
    private final int h;

    NodeStack(GraphSource source, StackData internalStack) {
        this.source = source;
        this.internalStack = internalStack;
        this.graph = source.getGraph();
        this.frames = new Frame[internalStack.size()];
        this.h = source.hashCode() << 5 ^ internalStack.getNodeId();
    }

    NodeStack(GraphSource source, String mime) {
        this.source = source;
        this.internalStack = new StackData(-1, mime, Collections.emptyList());
        this.graph = source.getGraph();
        this.frames = new Frame[0];
        this.h = source.hashCode() << 5 ^ this.internalStack.getNodeId();
    }

    public NodeStack getOtherStack(String langMime) {
        return this.source.getNodeStack(this.graph.getNode(this.internalStack.getNodeId()), langMime);
    }

    public String getMime() {
        return this.internalStack.getLanguageMimeType();
    }

    public boolean isEmpty() {
        return this.internalStack == null || this.internalStack.size() == 0;
    }

    public String toString() {
        return "Stack[" + this.internalStack.getNodeId() + "]";
    }

    public Frame get(int index) {
        return this.frame(index);
    }

    public boolean contains(Frame f) {
        return f != null && f.getInternalStack() == this.internalStack;
    }

    public int hashCode() {
        return this.h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeStack other = (NodeStack)obj;
        return this.source == other.source && this.internalStack.getNodeId() == other.internalStack.getNodeId();
    }

    @Override
    public Iterator<Frame> iterator() {
        return new Iterator<Frame>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < NodeStack.this.size();
            }

            @Override
            public Frame next() {
                return NodeStack.this.frame(this.index++);
            }
        };
    }

    public InputGraph getGraph() {
        return this.source.getGraph();
    }

    public GraphSource getGraphSource() {
        return this.source;
    }

    public int size() {
        return this.frames.length;
    }

    public Frame bottom() {
        return this.frame(this.size() - 1);
    }

    public Frame top() {
        return this.frame(0);
    }

    Lookup[] createLookups(Frame f) {
        return this.source.findLookup(this.getNode(), f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame frame(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        NodeStack nodeStack = this;
        synchronized (nodeStack) {
            Frame f = this.frames[index];
            if (f == null) {
                Location l = this.internalStack.getLocations().get(index);
                this.frames[index] = f = new Frame(l, index);
            }
            return f;
        }
    }

    public InputNode getNode() {
        return this.getGraph().getNode(this.internalStack.getNodeId());
    }

    public final class Frame
    implements Lookup.Provider {
        private final Location loc;
        private final int index;
        Lookup lookup;

        void assignLookup(Lookup l) {
            this.lookup = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup getLookup() {
            P l;
            Frame frame = this;
            synchronized (frame) {
                if (this.lookup != null) {
                    return this.lookup;
                }
                l = new P();
            }
            Lookup[] delegates = NodeStack.this.createLookups(this);
            l.assign(delegates);
            Frame frame2 = this;
            synchronized (frame2) {
                if (this.lookup != null) {
                    return this.lookup;
                }
                this.lookup = l;
            }
            return l;
        }

        public Frame(Location loc, int index) {
            this.loc = loc;
            this.index = index;
        }

        public Location getLocation() {
            return this.loc;
        }

        public int getDepth() {
            return this.index;
        }

        StackData getInternalStack() {
            return NodeStack.this.internalStack;
        }

        public InputNode getNode() {
            return NodeStack.this.getNode();
        }

        public InputGraph getGraph() {
            return NodeStack.this.getGraph();
        }

        public GraphSource getGraphSource() {
            return NodeStack.this.getGraphSource();
        }

        public String getOriginSpec() {
            return this.loc.getOriginSpec();
        }

        public String getFileName() {
            return this.loc.getFileName();
        }

        public boolean isResolved() {
            return this.loc.isResolved();
        }

        public FileObject getOriginFile() {
            return this.loc.getOriginFile();
        }

        public int getLine() {
            return this.loc.getLine();
        }

        public <T extends SpecificLocationInfo> boolean isOfKind(Class<T> clazz) {
            return this.loc.isOfKind(clazz);
        }

        public <T extends SpecificLocationInfo> T getSpecificInfo(Class<T> clazz) {
            return this.loc.getSpecificInfo(clazz);
        }

        public Frame getParent() {
            return NodeStack.this.frame(this.index + 1);
        }

        public Frame getNested() {
            return this.index == 0 ? null : NodeStack.this.frame(this.index - 1);
        }

        public int hashCode() {
            int hash = 3;
            hash = 43 * hash + Objects.hashCode(this.loc);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Frame other = (Frame)obj;
            return Objects.equals(this.loc, other.loc);
        }

        public boolean isNestedIn(Frame other) {
            if (!NodeStack.this.internalStack.equals(other.getInternalStack())) {
                return false;
            }
            return this.index < other.getDepth();
        }

        public boolean isParentOf(Frame other) {
            if (!NodeStack.this.internalStack.equals(other.getInternalStack())) {
                return false;
            }
            return this.index > other.getDepth();
        }

        public String toString() {
            return "Frame[nodeId = " + this.getNode().getId() + ", loc = " + this.getLocation() + "]";
        }

        public NodeStack getStack() {
            return NodeStack.this;
        }

        public Frame findPeerFrame(String langMime) {
            return this.findPeerFrame(NodeStack.this.getOtherStack(langMime));
        }

        public Frame findPeerFrame(NodeStack o) {
            if (o == null) {
                return null;
            }
            for (Frame of : o) {
                if (of.getLocation().compareNesting(this.loc) != 0) continue;
                return of;
            }
            return null;
        }
    }

    static class P
    extends ProxyLookup {
        P() {
        }

        void assign(Lookup[] lkps) {
            this.setLookups(lkps);
        }
    }
}

