/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.Document;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.SourceLocationUtils;
import org.graalvm.visualizer.source.SourceUtils;
import org.graalvm.visualizer.source.impl.editor.Bundle;
import org.graalvm.visualizer.source.impl.editor.SelectOrExtractNodesAction;
import org.graalvm.visualizer.util.LookupHistory;
import org.graalvm.visualizer.util.swing.DropdownButton;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.ProxyLookup;

public class SelectGraphNodesAction
extends SelectOrExtractNodesAction
implements Presenter.Toolbar,
ContextAwareAction {
    public static final String NAME_SELECT = "graph-select-nodes";
    private static final String ICON = "org/graalvm/visualizer/source/resources/selectNodes.gif";
    private final Lookup lkp;
    private final JEditorPane pane;
    private final NodeLocationContext ctx;
    private DropdownButton popButton;
    private List<InputNode> lineNodes = Collections.emptyList();
    private List<Location> lineLocs = Collections.emptyList();

    public SelectGraphNodesAction() {
        this(Lookup.EMPTY);
    }

    private SelectGraphNodesAction(Lookup lkp) {
        super(true, NAME_SELECT, lkp);
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)ICON, (boolean)false));
        this.lkp = lkp;
        this.pane = (JEditorPane)lkp.lookup(JEditorPane.class);
        this.ctx = (NodeLocationContext)lkp.lookup(NodeLocationContext.class);
    }

    public static Action selectNodesAction(Map<String, Object> params) {
        SelectGraphNodesAction a = new SelectGraphNodesAction();
        return a;
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new SelectGraphNodesAction((Lookup)new ProxyLookup(new Lookup[]{lkp, Lookup.getDefault()}));
    }

    public Component getToolbarPresenter() {
        if (this.popButton != null) {
            return this.popButton;
        }
        DropdownButton button = new DropdownButton("", ImageUtilities.loadImageIcon((String)ICON, (boolean)false), true){

            protected void populatePopup(JPopupMenu menu) {
                SelectGraphNodesAction.this.populatePopup(menu);
            }

            protected void performAction(ActionEvent e) {
                boolean shiftPressed;
                boolean bl = shiftPressed = (e.getModifiers() & 1) > 0;
                if (shiftPressed) {
                    SelectGraphNodesAction.super.actionPerformed(e, SelectGraphNodesAction.this.pane);
                    return;
                }
                SelectGraphNodesAction.this.cycleNextNode();
            }
        };
        button.setPopupEnabled(false);
        button.setEnabled(this.isEnabled());
        button.setToolTipText(Bundle.graph_select_nodes2());
        this.popButton = button;
        return button;
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        if (this.popButton != null) {
            this.popButton.setEnabled(newValue);
        }
    }

    @Override
    protected void refreshUI() {
        FileObject fo = EditorDocumentUtils.getFileObject((Document)this.pane.getDocument());
        NodeLocationContext context = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
        Collection<InputNode> nodes = null;
        ArrayList<Location> llocs = new ArrayList<Location>();
        if (context != null && fo != null) {
            nodes = SelectGraphNodesAction.findLineNodes(this.pane, llocs);
        }
        this.lineLocs = llocs;
        if (nodes == null || nodes.isEmpty()) {
            this.lineNodes = Collections.emptyList();
            this.setEnabled(false);
            return;
        }
        DiagramViewer sel = (DiagramViewer)LookupHistory.getLast(DiagramViewer.class);
        SourceUtils.resolveSelectableNodes(nodes, sel, nn -> {
            this.lineNodes = new ArrayList<InputNode>((Collection<InputNode>)nn);
            Collections.sort(this.lineNodes, InputNode.COMPARATOR);
            this.setEnabled(!this.lineNodes.isEmpty());
            if (this.popButton != null) {
                this.popButton.setPopupEnabled(nn.size() > 1);
            }
        }, true);
    }

    private void doPopulateMenu(JPopupMenu menu, Location loc) {
        int count = 0;
        InputNode curNode = this.ctx.getCurrentNode();
        for (InputNode nn : this.lineNodes) {
            String name = nn.getProperties().getString("name", "").replace("<", "&lt;");
            String n = nn == curNode ? Bundle.FMT_SelectNodePopupCurrentFormat(nn.getId(), name) : Bundle.FMT_SelectNodePopupFormat(nn.getId(), name);
            menu.add(new SelectNodesAction(n, loc, nn));
            if (++count < 15) continue;
            JMenuItem lastItem = new JMenuItem(Bundle.LBL_TooManyNodes());
            menu.add(lastItem);
            return;
        }
    }

    public void populatePopup(JPopupMenu menu) {
        if (this.pane == null || this.lineLocs.isEmpty()) {
            return;
        }
        Location loc = this.lineLocs.iterator().next();
        DiagramViewer v = (DiagramViewer)LookupHistory.getLast(DiagramViewer.class);
        if (this.cancelRefresh()) {
            Collection<InputNode> nodes = SelectGraphNodesAction.findLineNodes(this.pane, null);
            SourceUtils.resolveSelectableNodes(nodes, v, nn -> {
                this.lineNodes = new ArrayList<InputNode>((Collection<InputNode>)nn);
                Collections.sort(this.lineNodes, InputNode.COMPARATOR);
                this.doPopulateMenu(menu, loc);
            }, true);
        } else {
            this.doPopulateMenu(menu, loc);
        }
    }

    void cycleNextNode() {
        int index;
        InputNode in = this.ctx.getCurrentNode();
        int n = index = in != null ? this.lineNodes.indexOf(in) : -1;
        if (index == -1) {
            this.ctx.setSelectedNodes(this.lineNodes);
            index = 0;
        } else {
            index = (index + 1) % this.lineNodes.size();
        }
        in = this.lineNodes.get(index);
        Location loc = this.lineLocs.iterator().next();
        this.gotoNode(loc, in);
    }

    private void gotoNode(Location loc, InputNode nodeToSelect) {
        FileObject fo = EditorDocumentUtils.getFileObject((Document)this.pane.getDocument());
        if (fo == null || loc == null) {
            return;
        }
        NodeStack.Frame curFrame = this.ctx.getSelectedFrame();
        GraphSource src = this.ctx.getGraphSource();
        if (src == null) {
            return;
        }
        this.ctx.setGraphContext(src.getGraph(), this.lineNodes);
        NodeStack ns = this.ctx.getStack(nodeToSelect);
        List<Location> locs = src.getFileLocations(fo, false);
        Collection<Location> lineLocs = SourceLocationUtils.atLine(locs, loc.getLine());
        NodeStack.Frame locFrame = null;
        NodeStack.Frame selFrame = null;
        if (ns != null) {
            for (NodeStack.Frame fr : ns) {
                if (fr == curFrame) {
                    selFrame = fr;
                    break;
                }
                if (!lineLocs.contains(fr.getLocation())) continue;
                locFrame = fr;
            }
            if (selFrame == null) {
                selFrame = locFrame;
            }
        }
        this.ctx.setCurrentNode(nodeToSelect, selFrame);
        DiagramViewer sel = (DiagramViewer)LookupHistory.getLast(DiagramViewer.class);
        SourceUtils.resolveSelectableNodes(Collections.singletonList(nodeToSelect), sel, nn -> {
            sel.getSelections().setSelectedNodes(nn);
            sel.getSelections().scrollToVisible(nn);
        }, true);
    }

    private class SelectNodesAction
    extends AbstractAction {
        private final InputNode nodeToSelect;
        private final Location loc;

        public SelectNodesAction(String name, Location loc, InputNode node) {
            super(name);
            this.nodeToSelect = node;
            this.loc = loc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectGraphNodesAction.this.gotoNode(this.loc, this.nodeToSelect);
        }
    }
}

