/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualizer.data.SuppressFBWarnings;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.graalvm.visualizer.source.impl.ui.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;

public class NewGroupAction
extends AbstractAction {
    private final SourceRepositoryImpl repository;

    public NewGroupAction(SourceRepositoryImpl repository) {
        super(Bundle.ACTION_NewSourceGroup());
        this.repository = repository;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final NotificationLineSupport[] supp = new NotificationLineSupport[1];
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(Bundle.LBL_Name(), Bundle.TITLE_AddSourceGroup(), 2, 3){

            @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="The field is written by parent JComponent initialization")
            protected Component createDesign(String text) {
                Component c = super.createDesign(text);
                this.textField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.changed();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.changed();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                    }

                    private void changed() {
                        for (FileGroup g : NewGroupAction.this.repository.getGroups()) {
                            if (!g.getDisplayName().equalsIgnoreCase(textField.getText())) continue;
                            supp[0].setErrorMessage(Bundle.ERR_GroupWithSameName());
                            return;
                        }
                        supp[0].setErrorMessage(null);
                    }
                });
                return c;
            }
        };
        supp[0] = input.createNotificationLineSupport();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == NotifyDescriptor.OK_OPTION) {
            try {
                this.repository.createGroup(input.getInputText());
            }
            catch (IOException ex) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.ERR_CreateGroup(ex.toString()), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
            }
        }
    }
}

