/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.graalvm.visualizer.source.impl.SourceRepositoryNode;
import org.graalvm.visualizer.source.impl.actions.RemoveSourceRootAction;
import org.graalvm.visualizer.source.impl.ui.Bundle;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="SourceCollectionTopComponent", persistenceType=0)
public final class SourceCollectionTopComponent
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener {
    private BeanTreeView tree;
    private ExplorerManager mgr = new ExplorerManager();

    public SourceCollectionTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_SourceCollectionTopComponent());
        this.setToolTipText(Bundle.HINT_SourceCollectionTopComponent());
        this.putClientProperty("netbeans.winsys.tc.keep_preferred_size_when_slided_in", Boolean.TRUE);
        this.tree = new BeanTreeView();
        this.tree.setRootVisible(false);
        this.tree.setSelectionMode(1);
        this.add((Component)this.tree);
        SourceRepositoryImpl repo = SourceRepositoryImpl.getInstance();
        this.mgr.setRootContext((Node)new SourceRepositoryNode(repo));
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this);
        this.getActionMap().put("delete", new RemoveSourceRootAction.Perfomer(this.mgr, true));
    }

    private void refreshActivatedNodes() {
        Node[] nodes = this.mgr.getSelectedNodes();
        this.setActivatedNodes(nodes);
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.refreshActivatedNodes();
        }
    }
}

