/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import java.util.HashSet;
import java.util.Set;
import nbjavac.StringWrapper;

class TextBlockSupport {
    TextBlockSupport() {
    }

    static Set<WhitespaceChecks> checkWhitespace(String string) {
        String lastLine;
        HashSet<WhitespaceChecks> checks = new HashSet<WhitespaceChecks>();
        if (string.length() == 0) {
            return checks;
        }
        int outdent = 0;
        char lastChar = string.charAt(string.length() - 1);
        boolean optOut = lastChar == '\n' || lastChar == '\r';
        String[] lines = string.split("\\R");
        int length = lines.length;
        String string2 = lastLine = length == 0 ? "" : lines[length - 1];
        if (!optOut) {
            outdent = TextBlockSupport.indexOfNonWhitespace(lastLine);
            for (String line : lines) {
                if (!StringWrapper.isBlank(line) && (outdent = Integer.min(outdent, TextBlockSupport.indexOfNonWhitespace(line))) == 0) break;
            }
        }
        String start = lastLine.substring(0, outdent);
        for (String line : lines) {
            if (!StringWrapper.isBlank(line) && !line.startsWith(start)) {
                checks.add(WhitespaceChecks.INCONSISTENT);
            }
            if (outdent >= line.length() || !Character.isWhitespace(lastChar = line.charAt(line.length() - 1))) continue;
            checks.add(WhitespaceChecks.TRAILING);
        }
        return checks;
    }

    private static int indexOfNonWhitespace(String string) {
        return string.length() - string.replaceAll("^\\p{javaWhitespace}+", "").length();
    }

    static enum WhitespaceChecks {
        INCONSISTENT,
        TRAILING;

    }
}

