/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.hierarchicallayout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.graalvm.visualizer.hierarchicallayout.ClusterConnection;
import org.graalvm.visualizer.hierarchicallayout.ClusterEdge;
import org.graalvm.visualizer.hierarchicallayout.ClusterNode;
import org.graalvm.visualizer.hierarchicallayout.ClusterSlotNode;
import org.graalvm.visualizer.hierarchicallayout.HierarchicalLayoutManager;
import org.graalvm.visualizer.layout.Cluster;
import org.graalvm.visualizer.layout.LayoutGraph;
import org.graalvm.visualizer.layout.LayoutManager;
import org.graalvm.visualizer.layout.Link;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;
import org.graalvm.visualizer.settings.layout.LayoutSettings;

public class HierarchicalClusterLayoutManager
implements LayoutManager {
    private static final Logger LOG = Logger.getLogger(HierarchicalClusterLayoutManager.class.getName());
    private final AtomicBoolean cancelled;
    private final HierarchicalLayoutManager.Combine combine;
    private final LayoutSettings.LayoutSettingBean layoutSetting;
    private HierarchicalLayoutManager subManager;
    private HierarchicalLayoutManager manager;
    private static final boolean TRACE = false;

    public boolean cancel() {
        this.cancelled.set(true);
        this.manager.cancel();
        this.subManager.cancel();
        return true;
    }

    public HierarchicalClusterLayoutManager(HierarchicalLayoutManager.Combine combine, LayoutSettings.LayoutSettingBean layoutSetting) {
        this(combine, new HierarchicalLayoutManager(combine, layoutSetting), new HierarchicalLayoutManager(combine, layoutSetting), layoutSetting);
    }

    private HierarchicalClusterLayoutManager(HierarchicalLayoutManager.Combine combine, HierarchicalLayoutManager manager, HierarchicalLayoutManager subManager, LayoutSettings.LayoutSettingBean layoutSetting) {
        this.combine = combine;
        this.subManager = subManager;
        this.manager = manager;
        this.layoutSetting = layoutSetting;
        this.cancelled = new AtomicBoolean(false);
    }

    public void doLayout(LayoutGraph graph) {
        this.doLayout(graph, new HashSet(), new HashSet());
    }

    public void setSubManager(HierarchicalLayoutManager manager) {
        this.subManager = manager;
    }

    public void setManager(HierarchicalLayoutManager manager) {
        this.manager = manager;
    }

    public HierarchicalLayoutManager getSubManager() {
        return this.subManager;
    }

    public HierarchicalLayoutManager getManager() {
        return this.manager;
    }

    private Set<Cluster> discoverClusters(LayoutGraph graph) {
        Set<Object> clusters = graph.getClusters();
        HashSet<Cluster> others = new HashSet<Cluster>();
        for (Cluster c2 : clusters) {
            this.getOtherClusters(clusters, others, c2);
        }
        clusters.addAll(others);
        clusters = clusters.stream().filter(c -> c.isVisible()).collect(Collectors.toSet());
        return clusters;
    }

    private void getOtherClusters(Set<Cluster> clusters, Set<Cluster> others, Cluster current) {
        for (Cluster c : current.getSuccessors()) {
            if (clusters.contains(c) || !others.add(c)) continue;
            this.getOtherClusters(clusters, others, c);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doLayout(LayoutGraph graph, Set<? extends Vertex> firstLayerHint, Set<? extends Vertex> lastLayerHint) {
        void var17_30;
        assert (graph.verify());
        HashMap clusterInputSlotHash = new HashMap();
        HashMap clusterOutputSlotHash = new HashMap();
        HashMap<Cluster, ClusterNode> clusterNodes = new HashMap<Cluster, ClusterNode>();
        HashSet<ClusterConnection> clusterEdges = new HashSet<ClusterConnection>();
        HashSet<ClusterEdge> interClusterEdges = new HashSet<ClusterEdge>();
        HashMap<Object, ClusterConnection> linkClusterOutgoingConnection = new HashMap<Object, ClusterConnection>();
        HashMap<Object, ClusterConnection> linkInterClusterConnection = new HashMap<Object, ClusterConnection>();
        HashMap<Object, ClusterConnection> linkClusterIngoingConnection = new HashMap<Object, ClusterConnection>();
        HashSet<ClusterNode> clusterNodeSet = new HashSet<ClusterNode>();
        Set<Cluster> clusters = this.discoverClusters(graph);
        int z = 0;
        for (Cluster c : clusters) {
            clusterInputSlotHash.put(c, new HashMap());
            clusterOutputSlotHash.put(c, new HashMap());
            ClusterNode clusterNode = new ClusterNode(c, "" + z);
            clusterNodes.put(c, clusterNode);
            clusterNodeSet.add(clusterNode);
            ++z;
        }
        for (Cluster c : clusters) {
            ClusterNode clusterNode = (ClusterNode)clusterNodes.get(c);
            for (Cluster succ : c.getSuccessors()) {
                ClusterNode end = (ClusterNode)clusterNodes.get(succ);
                if (end == null || clusterNode == end) continue;
                ClusterEdge e = new ClusterEdge(clusterNode, end);
                interClusterEdges.add(e);
            }
        }
        for (Vertex v : graph.getVertices()) {
            if (!v.isVisible()) continue;
            Cluster cluster = v.getCluster();
            assert (cluster != null) : "Cluster of vertex " + v + " is null!";
            ((ClusterNode)clusterNodes.get(cluster)).addSubNode(v);
        }
        for (Object l : graph.getLinks()) {
            ClusterConnection conn;
            Port port = l.getFrom();
            Port toPort = l.getTo();
            Vertex fromVertex = port.getVertex();
            Vertex toVertex = toPort.getVertex();
            if (!fromVertex.isVisible() || !toVertex.isVisible()) continue;
            Cluster fromCluster = fromVertex.getCluster();
            Cluster toCluster = toVertex.getCluster();
            Port samePort = null;
            if (this.combine == HierarchicalLayoutManager.Combine.SAME_INPUTS) {
                samePort = toPort;
            } else if (this.combine == HierarchicalLayoutManager.Combine.SAME_OUTPUTS) {
                samePort = port;
            }
            if (fromCluster == toCluster) {
                ((ClusterNode)clusterNodes.get(fromCluster)).addSubEdge((Link)l);
                continue;
            }
            ClusterSlotNode inputSlotNode = null;
            ClusterSlotNode outputSlotNode = null;
            if (samePort != null) {
                outputSlotNode = (ClusterSlotNode)((HashMap)clusterOutputSlotHash.get(fromCluster)).get(samePort);
                inputSlotNode = (ClusterSlotNode)((HashMap)clusterInputSlotHash.get(toCluster)).get(samePort);
            }
            if (outputSlotNode == null) {
                outputSlotNode = ClusterSlotNode.makeOutputSlotNode((ClusterNode)clusterNodes.get(fromCluster), "Out " + (Cluster)fromCluster + " " + samePort);
                conn = ClusterConnection.makeOutputConnection(outputSlotNode, (Link)l);
                outputSlotNode.setConnection(conn);
                ((ClusterNode)clusterNodes.get(fromCluster)).addSubEdge(conn);
                if (samePort != null) {
                    ((HashMap)clusterOutputSlotHash.get(fromCluster)).put(samePort, outputSlotNode);
                }
                linkClusterOutgoingConnection.put(l, conn);
            } else {
                linkClusterOutgoingConnection.put(l, outputSlotNode.getConnection());
            }
            if (inputSlotNode == null) {
                inputSlotNode = ClusterSlotNode.makeInputSlotNode((ClusterNode)clusterNodes.get(toCluster), "In " + toCluster + " " + samePort);
            }
            conn = ClusterConnection.makeInputConnection(inputSlotNode, (Link)l);
            inputSlotNode.setConnection(conn);
            ((ClusterNode)clusterNodes.get(toCluster)).addSubEdge(conn);
            if (samePort != null) {
                ((HashMap)clusterInputSlotHash.get(toCluster)).put(samePort, inputSlotNode);
            }
            linkClusterIngoingConnection.put(l, conn);
            ClusterConnection interConn = ClusterConnection.makeInnerConnection(inputSlotNode, outputSlotNode, (Link)l);
            linkInterClusterConnection.put(l, interConn);
            clusterEdges.add(interConn);
        }
        if (this.cancelled.get()) {
            return;
        }
        Object t = null;
        for (Cluster cluster : clusters) {
            if (this.cancelled.get()) {
                return;
            }
            ClusterNode n = (ClusterNode)clusterNodes.get(cluster);
            LayoutGraph clusterGraph = new LayoutGraph(n.getSubEdges(), n.getSubNodes());
            this.subManager.doLayout(clusterGraph);
            n.updateSize(clusterGraph.getSize());
        }
        Set roots = new LayoutGraph(interClusterEdges).findRootVertices();
        for (Vertex v : roots) {
            assert (v instanceof ClusterNode);
            ((ClusterNode)v).setRoot(true);
        }
        if (!((Boolean)this.layoutSetting.get(Boolean.class, "DEFAULT_LAYOUT")).booleanValue() && ((Boolean)this.layoutSetting.get(Boolean.class, "BLOCKVIEW_AS_CONTROLFLOW")).booleanValue()) {
            boolean longEdges = (Boolean)this.layoutSetting.get(Boolean.class, "DRAW_LONG_EDGES");
            boolean decreaseDeviation = (Boolean)this.layoutSetting.get(Boolean.class, "DECREASE_LAYER_WIDTH_DEVIATION");
            boolean standAlones = (Boolean)this.layoutSetting.get(Boolean.class, "STANDALONES");
            this.layoutSetting.set("DRAW_LONG_EDGES", (Object)true);
            this.layoutSetting.set("DECREASE_LAYER_WIDTH_DEVIATION", (Object)false);
            this.layoutSetting.set("STANDALONES", (Object)false);
            LayoutGraph layoutGraph = new LayoutGraph(interClusterEdges, clusterNodeSet);
            this.manager.doLayout(layoutGraph);
            for (Cluster c : clusters) {
                ClusterNode n = (ClusterNode)clusterNodes.get(c);
                c.setBounds(new Rectangle(n.getPosition(), n.getSize()));
                c.setVisible(n.isVisible());
            }
            this.layoutSetting.set("DRAW_LONG_EDGES", (Object)longEdges);
            this.layoutSetting.set("DECREASE_LAYER_WIDTH_DEVIATION", (Object)decreaseDeviation);
            this.layoutSetting.set("STANDALONES", (Object)standAlones);
            LayoutGraph layoutGraph2 = new LayoutGraph(clusterEdges, clusterNodeSet);
            this.manager.doRouting(layoutGraph2);
        } else {
            boolean standAlones = (Boolean)this.layoutSetting.get(Boolean.class, "STANDALONES");
            this.layoutSetting.set("STANDALONES", (Object)false);
            LayoutGraph layoutGraph = new LayoutGraph(clusterEdges, clusterNodeSet);
            this.manager.doLayout(layoutGraph);
            this.layoutSetting.set("STANDALONES", (Object)standAlones);
        }
        graph.setSize(var17_30.getSize());
        if (this.cancelled.get()) {
            return;
        }
        for (Cluster c : clusters) {
            ClusterNode n = (ClusterNode)clusterNodes.get(c);
            c.setBounds(new Rectangle(n.getPosition(), n.getSize()));
            c.setVisible(n.isVisible());
        }
        for (Link l : graph.getLinks()) {
            if (!linkInterClusterConnection.containsKey(l)) continue;
            ClusterConnection conn1 = (ClusterConnection)linkClusterOutgoingConnection.get(l);
            ClusterConnection conn2 = (ClusterConnection)linkInterClusterConnection.get(l);
            ClusterConnection conn3 = (ClusterConnection)linkClusterIngoingConnection.get(l);
            assert (conn1 != null);
            assert (conn2 != null);
            assert (conn3 != null);
            ArrayList<Point> points = new ArrayList<Point>();
            points.addAll(conn1.getControlPoints());
            points.addAll(conn2.getControlPoints());
            points.addAll(conn3.getControlPoints());
            l.setControlPoints(points);
        }
    }

    public void doRouting(LayoutGraph graph) {
        assert (graph.verify());
        HashMap clusterInputSlotHash = new HashMap();
        HashMap clusterOutputSlotHash = new HashMap();
        HashMap<Cluster, ClusterNode> clusterNodes = new HashMap<Cluster, ClusterNode>();
        HashSet<ClusterConnection> clusterEdges = new HashSet<ClusterConnection>();
        HashSet<ClusterEdge> interClusterEdges = new HashSet<ClusterEdge>();
        HashMap<Object, ClusterConnection> linkClusterOutgoingConnection = new HashMap<Object, ClusterConnection>();
        HashMap<Link, ClusterConnection> linkInterClusterConnection = new HashMap<Link, ClusterConnection>();
        HashMap<Object, ClusterConnection> linkClusterIngoingConnection = new HashMap<Object, ClusterConnection>();
        HashSet<ClusterNode> clusterNodeSet = new HashSet<ClusterNode>();
        HashSet<Link> reverseEdges = new HashSet<Link>();
        Set<Cluster> clusters = this.discoverClusters(graph);
        int z = 0;
        for (Cluster c : clusters) {
            clusterInputSlotHash.put(c, new HashMap());
            clusterOutputSlotHash.put(c, new HashMap());
            ClusterNode clusterNode = new ClusterNode(c, "" + z);
            clusterNodes.put(c, clusterNode);
            clusterNodeSet.add(clusterNode);
            ++z;
        }
        for (Cluster c : clusters) {
            ClusterNode clusterNode = (ClusterNode)clusterNodes.get(c);
            for (Cluster succ : c.getSuccessors()) {
                ClusterNode end = (ClusterNode)clusterNodes.get(succ);
                if (end == null || clusterNode == end) continue;
                ClusterEdge e = new ClusterEdge(clusterNode, end);
                interClusterEdges.add(e);
            }
        }
        for (Vertex v : graph.getVertices()) {
            if (!v.isVisible()) continue;
            Cluster cluster = v.getCluster();
            assert (cluster != null) : "Cluster of vertex " + v + " is null!";
            ((ClusterNode)clusterNodes.get(cluster)).addSubNode(v);
        }
        for (Object l : graph.getLinks()) {
            ClusterConnection conn;
            Port port = l.getFrom();
            Port toPort = l.getTo();
            Vertex fromVertex = port.getVertex();
            Vertex toVertex = toPort.getVertex();
            if (!fromVertex.isVisible() || !toVertex.isVisible()) continue;
            Cluster fromCluster = fromVertex.getCluster();
            Cluster toCluster = toVertex.getCluster();
            Port samePort = null;
            if (this.combine == HierarchicalLayoutManager.Combine.SAME_INPUTS) {
                samePort = toPort;
            } else if (this.combine == HierarchicalLayoutManager.Combine.SAME_OUTPUTS) {
                samePort = port;
            }
            if (fromCluster == toCluster) {
                ((ClusterNode)clusterNodes.get(fromCluster)).addSubEdge((Link)l);
                continue;
            }
            ClusterSlotNode inputSlotNode = null;
            ClusterSlotNode outputSlotNode = null;
            if (samePort != null) {
                outputSlotNode = (ClusterSlotNode)((HashMap)clusterOutputSlotHash.get(fromCluster)).get(samePort);
                inputSlotNode = (ClusterSlotNode)((HashMap)clusterInputSlotHash.get(toCluster)).get(samePort);
            }
            if (outputSlotNode == null) {
                outputSlotNode = ClusterSlotNode.makeOutputSlotNode((ClusterNode)clusterNodes.get(fromCluster), "Out " + fromCluster + " " + samePort);
                conn = ClusterConnection.makeOutputConnection(outputSlotNode, (Link)l);
                outputSlotNode.setConnection(conn);
                this.resolveSlotAndConnection(outputSlotNode, conn, (Link)l);
                ((ClusterNode)clusterNodes.get(fromCluster)).addSubEdge(conn);
                if (samePort != null) {
                    ((HashMap)clusterOutputSlotHash.get(fromCluster)).put(samePort, outputSlotNode);
                }
                linkClusterOutgoingConnection.put(l, conn);
            } else {
                linkClusterOutgoingConnection.put(l, outputSlotNode.getConnection());
            }
            if (inputSlotNode == null) {
                inputSlotNode = ClusterSlotNode.makeInputSlotNode((ClusterNode)clusterNodes.get(toCluster), "In " + toCluster + " " + samePort);
            }
            conn = ClusterConnection.makeInputConnection(inputSlotNode, (Link)l);
            inputSlotNode.setConnection(conn);
            this.resolveSlotAndConnection(inputSlotNode, conn, (Link)l);
            ((ClusterNode)clusterNodes.get(toCluster)).addSubEdge(conn);
            if (samePort != null) {
                ((HashMap)clusterInputSlotHash.get(toCluster)).put(samePort, inputSlotNode);
            }
            linkClusterIngoingConnection.put(l, conn);
            ClusterConnection interConn = ClusterConnection.makeInnerConnection(inputSlotNode, outputSlotNode, (Link)l);
            this.resolveInnerSlotAndConnection(reverseEdges, outputSlotNode, inputSlotNode, interConn, (Link)l);
            linkInterClusterConnection.put((Link)l, interConn);
            clusterEdges.add(interConn);
        }
        Object t = null;
        for (Cluster cluster : clusters) {
            ClusterNode n = (ClusterNode)clusterNodes.get(cluster);
            LayoutGraph clusterGraph = new LayoutGraph(n.getSubEdges(), n.getSubNodes());
            this.subManager.doRouting(clusterGraph);
            n.updateSize(clusterGraph.getSize());
            n.setPosition(cluster.getBounds().getLocation());
        }
        Set roots = new LayoutGraph(interClusterEdges).findRootVertices();
        for (Vertex v : roots) {
            assert (v instanceof ClusterNode);
            ((ClusterNode)v).setRoot(true);
        }
        this.resolveReversedEdges(reverseEdges, linkInterClusterConnection);
        LayoutGraph layoutGraph = new LayoutGraph(clusterEdges, clusterNodeSet);
        this.manager.doRouting(layoutGraph);
        graph.setSize(layoutGraph.getSize());
        for (Cluster c : clusters) {
            ClusterNode n = (ClusterNode)clusterNodes.get(c);
            c.setBounds(new Rectangle(n.getPosition(), n.getSize()));
            c.setVisible(n.isVisible());
        }
        for (Link l : graph.getLinks()) {
            if (!linkInterClusterConnection.containsKey(l)) continue;
            ClusterConnection conn1 = (ClusterConnection)linkClusterOutgoingConnection.get(l);
            ClusterConnection conn2 = linkInterClusterConnection.get(l);
            ClusterConnection conn3 = (ClusterConnection)linkClusterIngoingConnection.get(l);
            assert (conn1 != null);
            assert (conn2 != null);
            assert (conn3 != null);
            ArrayList<Point> points = new ArrayList<Point>();
            points.addAll(conn1.getControlPoints());
            points.addAll(conn2.getControlPoints());
            points.addAll(conn3.getControlPoints());
            l.setControlPoints(points);
        }
    }

    private void resolveSlotAndConnection(ClusterSlotNode slotNode, ClusterConnection connection, Link link) {
        boolean input = slotNode.isInputSlot();
        Rectangle bounds = slotNode.getCluster().getBounds();
        int y = bounds.y + (input ? 0 : bounds.height);
        List linkPoints = link.getControlPoints();
        assert (linkPoints.size() > 2);
        ArrayList<Point> points = new ArrayList<Point>();
        Point a = null;
        if (input) {
            for (int i = linkPoints.size() - 1; i > 0 && ((a = (Point)linkPoints.get(i)) == null || a.y >= y); --i) {
                points.add(a);
            }
        } else {
            for (int i = 0; i < linkPoints.size() && ((a = (Point)linkPoints.get(i)) == null || a.y <= y); ++i) {
                points.add(a);
            }
        }
        assert (a.x == ((Point)points.get((int)(points.size() - 1))).x);
        a = new Point(a.x, y);
        points.add(a);
        assert (points.size() > 2);
        if (input) {
            Collections.reverse(points);
        }
        connection.setControlPoints(points);
        slotNode.setPosition(new Point(a.x, a.y + (input ? 20 : -20)));
    }

    private void resolveInnerSlotAndConnection(Set<Link> reversedEdges, ClusterSlotNode outputSlotNode, ClusterSlotNode inputSlotNode, ClusterConnection connection, Link link) {
        List<Point> outPoints = outputSlotNode.getConnection().getControlPoints();
        List<Point> inPoints = inputSlotNode.getConnection().getControlPoints();
        assert (outPoints.size() > 2);
        assert (inPoints.size() > 2);
        List points = link.getControlPoints();
        assert (points.contains(outPoints.get(outPoints.size() - 2)));
        assert (points.contains(inPoints.get(1)));
        ArrayList<Point> innPoints = new ArrayList<Point>();
        innPoints.add(outPoints.get(outPoints.size() - 1));
        for (int i = points.indexOf(outPoints.get(outPoints.size() - 2)) + 1; i < points.indexOf(inPoints.get(1)); ++i) {
            innPoints.add((Point)points.get(i));
        }
        innPoints.add(inPoints.get(0));
        connection.setControlPoints(innPoints);
        if (((Point)innPoints.get((int)0)).y > ((Point)innPoints.get((int)(innPoints.size() - 1))).y) {
            reversedEdges.add(link);
        }
    }

    private void resolveReversedEdges(Set<Link> links, HashMap<Link, ClusterConnection> inner) {
        List points;
        List lastPoints;
        Point last;
        Point portPoint;
        List points2;
        Link lastLink;
        Dimension size;
        Point position;
        HashMap<Vertex, List> inMap = new HashMap<Vertex, List>();
        HashMap<Vertex, List> outMap = new HashMap<Vertex, List>();
        HashMap<Port, Link> usedPorts = new HashMap<Port, Link>();
        for (Link li : links) {
            Link l = inner.get(li);
            inMap.computeIfAbsent(l.getTo().getVertex(), v -> new ArrayList()).add(l);
            outMap.computeIfAbsent(l.getFrom().getVertex(), v -> new ArrayList()).add(l);
        }
        int offset = 8 + (Integer)this.layoutSetting.get(Integer.class, "DUMMY_WIDTH");
        for (Map.Entry entry : outMap.entrySet()) {
            position = ((Vertex)entry.getKey()).getPosition();
            size = ((Vertex)entry.getKey()).getSize();
            List outputs = (List)entry.getValue();
            Collections.sort(outputs, (l1, l2) -> ((Point)l1.getControlPoints().get((int)1)).y - ((Point)l2.getControlPoints().get((int)1)).y);
            int outCount = 1;
            for (Link l : outputs) {
                lastLink = (Link)usedPorts.get(l.getFrom());
                if (lastLink == null) {
                    points2 = l.getControlPoints();
                    portPoint = position.getLocation();
                    portPoint.translate(l.getFrom().getRelativePosition().x, size.height);
                    ((Point)points2.get(0)).move(portPoint.x, portPoint.y);
                    ((Point)points2.get(1)).move(portPoint.x, portPoint.y + offset * outCount);
                    if (!((Boolean)this.layoutSetting.get(Boolean.class, "EDGE_BENDING")).booleanValue()) {
                        ((Point)points2.get(2)).move(portPoint.x, portPoint.y + offset * outCount);
                        last = (Point)points2.get(3);
                    } else {
                        last = (Point)points2.get(2);
                    }
                    last.move(position.x + (last.x > position.x ? size.width + offset * outCount : -offset * outCount), portPoint.y + offset * outCount);
                    usedPorts.put(l.getFrom(), l);
                    ++outCount;
                    continue;
                }
                lastPoints = lastLink.getControlPoints();
                points = l.getControlPoints();
                ((Point)points.get(0)).setLocation((Point)lastPoints.get(0));
                ((Point)points.get(1)).setLocation((Point)lastPoints.get(1));
                ((Point)points.get(2)).setLocation((Point)lastPoints.get(2));
                if (((Boolean)this.layoutSetting.get(Boolean.class, "EDGE_BENDING")).booleanValue()) continue;
                ((Point)points.get(3)).setLocation((Point)lastPoints.get(3));
            }
        }
        for (Map.Entry entry : inMap.entrySet()) {
            position = ((Vertex)entry.getKey()).getPosition();
            size = ((Vertex)entry.getKey()).getSize();
            List inputs = (List)entry.getValue();
            int inCount = 1;
            Collections.sort(inputs, (l1, l2) -> {
                List p1 = l1.getControlPoints();
                List p2 = l2.getControlPoints();
                return ((Point)p2.get((int)(p2.size() - 2))).y - ((Point)p1.get((int)(p1.size() - 2))).y;
            });
            for (Link l : inputs) {
                lastLink = (Link)usedPorts.get(l.getTo());
                if (lastLink == null) {
                    points2 = l.getControlPoints();
                    portPoint = position.getLocation();
                    portPoint.x += l.getTo().getRelativePosition().x;
                    ((Point)points2.get(points2.size() - 1)).move(portPoint.x, portPoint.y);
                    ((Point)points2.get(points2.size() - 2)).move(portPoint.x, portPoint.y - offset * inCount);
                    if (!((Boolean)this.layoutSetting.get(Boolean.class, "EDGE_BENDING")).booleanValue()) {
                        ((Point)points2.get(points2.size() - 3)).move(portPoint.x, portPoint.y - offset * inCount);
                        last = (Point)points2.get(points2.size() - 4);
                    } else {
                        last = (Point)points2.get(points2.size() - 3);
                    }
                    last.move(position.x + size.width + offset * inCount, portPoint.y - offset * inCount);
                    usedPorts.put(l.getTo(), l);
                    ++inCount;
                    continue;
                }
                lastPoints = lastLink.getControlPoints();
                points = l.getControlPoints();
                ((Point)points.get(points.size() - 1)).setLocation((Point)lastPoints.get(lastPoints.size() - 1));
                ((Point)points.get(points.size() - 2)).setLocation((Point)lastPoints.get(lastPoints.size() - 2));
                ((Point)points.get(points.size() - 3)).setLocation((Point)lastPoints.get(lastPoints.size() - 3));
                if (((Boolean)this.layoutSetting.get(Boolean.class, "EDGE_BENDING")).booleanValue()) continue;
                ((Point)points.get(points.size() - 4)).setLocation((Point)lastPoints.get(lastPoints.size() - 4));
            }
        }
    }
}

