/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.graalvm.visualizer.view.EditorTopComponent;
import org.graalvm.visualizer.view.actions.Bundle;
import org.openide.util.HelpCtx;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.CallableSystemAction;

public final class ZoomInAction
extends CallableSystemAction {
    public static final String ID = "org.graalvm.visualizer.view.actions.ZoomInAction";

    public void actionPerformed(final ActionEvent ev) {
        if (this.isEnabled()) {
            ActionInvoker.invokeAction((Action)((Object)this), (ActionEvent)ev, (boolean)this.asynchronous(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if ((ev.getModifiers() & 1) > 0) {
                        ZoomInAction.this.performZoom(true);
                    } else {
                        ZoomInAction.this.performZoom(false);
                    }
                }
            });
        } else {
            super.actionPerformed(ev);
        }
    }

    void performZoom(boolean origSize) {
        EditorTopComponent editor = EditorTopComponent.getActive();
        if (editor != null) {
            if (origSize) {
                editor.zoomTo(1.0f);
            } else {
                editor.zoomIn();
            }
        }
    }

    public void performAction() {
        this.performZoom(false);
    }

    public String getName() {
        return Bundle.ACTION_ZoomIn();
    }

    public ZoomInAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, 2, false));
        this.putValue("ShortDescription", Bundle.ACTION_ZoomIn());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/view/images/zoom_in.png";
    }
}

