/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.util.RangeSliderModel;
import org.openide.util.WeakListeners;

public final class Colorizer {
    private final GraphContainer container;
    private final RangeSliderModel slider;
    private Set<Integer> trackedNodes = Collections.emptySet();
    private final PropertyChangeListener propL;

    public Colorizer(GraphContainer container, RangeSliderModel slider) {
        this.container = container;
        this.slider = slider;
        this.propL = this::rangeSliderChanged;
        slider.addPropertyChangeListener("positions", WeakListeners.propertyChange((PropertyChangeListener)this.propL, (String)"positions", (Object)slider));
    }

    private void rangeSliderChanged(PropertyChangeEvent e) {
        this.refreshColors();
    }

    public Set<Integer> getTrackedNodes() {
        return Collections.unmodifiableSet(this.trackedNodes);
    }

    public void setTrackedNodes(Set<Integer> trackedNodes) {
        this.trackedNodes = new HashSet<Integer>(trackedNodes);
        this.refreshColors();
    }

    private void refreshColors() {
        List graphs = this.container.getGraphs();
        List sliderPositions = this.slider.getPositions();
        ArrayList<Color> colors = new ArrayList<Color>(Collections.nCopies(sliderPositions.size(), Color.black));
        ArrayList<Object> hatches = new ArrayList<Object>(Collections.nCopies(sliderPositions.size(), null));
        if (this.trackedNodes.size() >= 1) {
            for (Integer id : this.trackedNodes) {
                if (id < 0) {
                    id = -id.intValue();
                }
                boolean firstDefined = true;
                InputGraph lastGraph = null;
                for (InputGraph g : graphs) {
                    int index = sliderPositions.indexOf(g.getName());
                    if (index == -1) continue;
                    Color curColor = (Color)colors.get(index);
                    if (g.containsNode(id.intValue())) {
                        if (firstDefined) {
                            curColor = Color.green;
                        } else {
                            assert (lastGraph != null);
                            if (!this.container.isNodeChanged(lastGraph, g, id.intValue())) {
                                if (curColor == Color.black) {
                                    curColor = Color.white;
                                }
                            } else if (curColor != Color.green) {
                                curColor = Color.orange;
                            }
                        }
                        firstDefined = false;
                        lastGraph = g;
                    } else {
                        firstDefined = true;
                        lastGraph = null;
                    }
                    if (g.isDuplicate()) {
                        if (curColor == Color.white) {
                            hatches.set(index, Color.gray);
                        } else {
                            hatches.set(index, Color.white);
                        }
                    }
                    colors.set(index, curColor);
                }
            }
        }
        this.slider.getColorChangedEvent().beginAtomic();
        this.slider.setColors(colors);
        this.slider.setHatchColors(hatches);
        this.slider.getColorChangedEvent().endAtomic();
    }
}

