/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.GraphClassifier;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.util.ListenerSupport;
import org.graalvm.visualizer.util.RangeSliderModel;
import org.graalvm.visualizer.view.api.TimelineEvent;
import org.graalvm.visualizer.view.api.TimelineListener;
import org.graalvm.visualizer.view.api.TimelineModel;
import org.graalvm.visualizer.view.impl.GraphTypeContainer;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class TimelineModelImpl
implements TimelineModel,
ChangedListener<Group>,
Runnable {
    private static final Logger LOG = Logger.getLogger(TimelineModel.class.getName());
    private static final RequestProcessor LOAD_RP = new RequestProcessor(TimelineModelImpl.class.getName());
    private static final String TYPE_DEFAULT_LAST = "99_default";
    private final Group storage;
    private final GraphClassifier classifier;
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private final String primaryType;
    private final GraphContainer primaryContainer;
    private RangeSliderAccess primaryModel;
    private boolean hideDuplicates;
    private Map<String, GraphContainer> containers;
    private Map<String, RangeSliderAccess> sliderModels;
    private RequestProcessor.Task refreshTask;
    private Set<Integer> trackedNodes = new HashSet<Integer>();
    private List<TimelineListener> listeners = new ArrayList<TimelineListener>();
    private boolean suppressRefireEvents;
    private boolean partitionsChanged;
    private L partitionListener = new L();
    private final Executor awtExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            TimelineModelImpl.this.doExecuteWhenStable(command);
        }
    };

    public TimelineModelImpl(Group storage, GraphClassifier classifier, String primaryType) {
        this.storage = storage;
        this.classifier = classifier;
        this.primaryContainer = this.createContainer(primaryType);
        this.primaryModel = this.createSlider(primaryType);
        this.primaryType = primaryType;
        ListenerSupport.addWeakListener((ChangedListener)this, (ChangedEvent)storage.getChangedEvent());
        this.scheduleRefresh(true);
    }

    private GraphContainer createContainer(String type) {
        if (Objects.equals(this.primaryType, type)) {
            return this.primaryContainer;
        }
        this.partitionsChanged = true;
        GraphTypeContainer gtc = new GraphTypeContainer((GraphContainer)this.storage, type, null);
        return gtc;
    }

    private RangeSliderAccess createSlider(String type) {
        if (Objects.equals(this.primaryType, type)) {
            return this.primaryModel;
        }
        RangeSliderAccess a = new RangeSliderAccess(Arrays.asList("dummy"));
        a.addPropertyChangeListener(this.partitionListener);
        a.getChangedEvent().addListener((Object)this.partitionListener);
        a.oldPos1 = a.getFirstPosition();
        a.oldPos2 = a.getSecondPosition();
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimelineListener(TimelineListener l) {
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimelineListener(TimelineListener l) {
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            this.listeners.remove(l);
        }
    }

    private synchronized void ensureInitialized() {
        if (this.sliderModels != null) {
            return;
        }
        this.scheduleRefresh();
        HashMap<String, GraphContainer> ncmap = new HashMap<String, GraphContainer>();
        LinkedHashMap<String, RangeSliderAccess> sliders = new LinkedHashMap<String, RangeSliderAccess>();
        ncmap.put(this.primaryType, this.createContainer(this.primaryType));
        RangeSliderAccess mdl = this.createSlider(this.primaryType);
        sliders.put(this.primaryType, mdl);
        this.sliderModels = sliders;
        this.containers = ncmap;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void changed(Group source) {
        this.scheduleRefresh();
    }

    void scheduleRefresh() {
        this.scheduleRefresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void scheduleRefresh(boolean immediately) {
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            if (this.refreshTask != null) {
                LOG.log(Level.FINER, "{0}: already scheduled", this);
                return;
            }
            LOG.log(Level.FINER, "{0}: Schedule refresh delay", this);
            this.refreshTask = LOAD_RP.post((Runnable)this, immediately ? 0 : 200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _testCompleteRefresh() {
        RequestProcessor.Task rt;
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            rt = this.refreshTask;
        }
        if (rt != null) {
            rt.waitFinished();
        }
        try {
            SwingUtilities.invokeAndWait(() -> {});
        }
        catch (InterruptedException | InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            this.refreshTask = null;
        }
        List els = this.storage.getGraphs();
        LOG.log(Level.FINE, "{0}: Scheduling EDT refresh", this);
        SwingUtilities.invokeLater(() -> this.refresh(els));
    }

    private synchronized String findRangeType(RangeSliderModel mdl) {
        this.ensureInitialized();
        for (Map.Entry<String, RangeSliderAccess> e : this.sliderModels.entrySet()) {
            if (e.getValue() != mdl) continue;
            return e.getKey();
        }
        return null;
    }

    private void fireRangeChanged(RangeSliderModel mdl) {
        RangeSliderAccess acc = (RangeSliderAccess)mdl;
        int p1 = mdl.getFirstPosition();
        int p2 = mdl.getSecondPosition();
        String type = this.findRangeType(mdl);
        if (type == null) {
            return;
        }
        if (p1 == acc.oldPos1 && p2 == acc.oldPos2) {
            return;
        }
        TimelineEvent ev = new TimelineEvent((TimelineModel)this, mdl, type, acc.oldPos1, acc.oldPos2);
        acc.oldPos1 = p1;
        acc.oldPos1 = p2;
        if (mdl == this.getPrimaryRange()) {
            this.fireTimelineEvent(ev, TimelineListener::primaryRangeChanged);
        } else {
            this.fireTimelineEvent(ev, TimelineListener::rangeChanged);
        }
    }

    private void fireRangePropertyChanged(PropertyChangeEvent e) {
        RangeSliderModel mdl = (RangeSliderModel)e.getSource();
        String type = this.findRangeType(mdl);
        if (type == null) {
            return;
        }
        this.fireTimelineEvent(new TimelineEvent((TimelineModel)this, mdl, type, e), TimelineListener::rangePropertyChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTimelineEvent(TimelineEvent e, BiConsumer<TimelineListener, TimelineEvent> f) {
        TimelineListener[] timelineListenerArray = this;
        synchronized (this) {
            if (this.listeners.isEmpty()) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            TimelineListener[] ll = this.listeners.toArray(new TimelineListener[this.listeners.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (TimelineListener l : ll) {
                f.accept(l, e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(List<InputGraph> contents) {
        LinkedHashMap<String, RangeSliderAccess> nsliders;
        Object t;
        HashMap<String, GraphContainer> ncmap;
        LOG.log(Level.FINE, "{0}: Refreshing...", this);
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            ncmap = this.containers == null ? new HashMap<String, GraphContainer>() : new HashMap<String, GraphContainer>(this.containers);
        }
        HashMap<String, List> indices = new HashMap<String, List>();
        ArrayList<InputGraph> els = new ArrayList<InputGraph>(contents);
        this.partitionsChanged = false;
        int b = 0;
        HashSet usedTypes = new HashSet();
        Iterator it = els.iterator();
        while (it.hasNext()) {
            InputGraph graph = (InputGraph)it.next();
            t = graph.getGraphType();
            if (t == null) {
                t = TYPE_DEFAULT_LAST;
            } else if (!this.classifier.knownGraphTypes().contains(t)) {
                it.remove();
                continue;
            }
            ncmap.computeIfAbsent((String)t, this::createContainer);
            if (this.isHideDuplicates() && graph.isDuplicate()) {
                it.remove();
                continue;
            }
            usedTypes.add(t);
            indices.computeIfAbsent((String)t, k -> new ArrayList(els.size())).add(b);
            ++b;
        }
        ncmap.keySet().retainAll(usedTypes);
        ArrayList keys = new ArrayList(ncmap.keySet());
        Collections.sort(keys);
        t = this;
        synchronized (t) {
            nsliders = this.sliderModels == null ? new LinkedHashMap<String, RangeSliderAccess>() : new LinkedHashMap<String, RangeSliderAccess>(this.sliderModels);
            ArrayList oldSliders = new ArrayList(nsliders.values());
            nsliders.put(this.primaryType, this.primaryModel);
            for (String k2 : keys) {
                nsliders.computeIfAbsent(k2, this::createSlider);
            }
            oldSliders.removeAll(nsliders.values());
            for (RangeSliderAccess a : oldSliders) {
                a.removePropertyChangeListener(this.partitionListener);
                a.getChangedEvent().removeListener((Object)this.partitionListener);
            }
            this.sliderModels = nsliders;
            this.containers = ncmap;
        }
        LOG.log(Level.FINE, "{0}: Updating timeline", this);
        for (String k3 : keys) {
            RangeSliderAccess mdl = (RangeSliderAccess)((Object)nsliders.get(k3));
            List itemIndices = (List)indices.get(k3);
            ArrayList<String> names = new ArrayList<String>(itemIndices.size());
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            Iterator iterator = itemIndices.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String s = ((InputGraph)els.get(i)).getName();
                names.add(s);
                m.put(s, i);
            }
            if (mdl != this.primaryModel) {
                this.suppressRefireEvents = true;
            }
            try {
                mdl.getChangedEvent().beginAtomic();
                mdl.setPositions(names);
                mdl.setIndices0(m);
            }
            finally {
                mdl.getChangedEvent().endAtomic();
                if (mdl == this.primaryModel) continue;
                this.suppressRefireEvents = false;
            }
        }
        boolean c = this.partitionsChanged;
        if (c) {
            this.fireOwnPropertyChange("partitions", null, null);
        }
    }

    private void fireOwnPropertyChange(String prop, Object old, Object n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.fireOwnPropertyChange(prop, old, n));
            return;
        }
        if (prop != null && (old != null || n != null) && Objects.equals(old, n)) {
            return;
        }
        PropertyChangeEvent e = new PropertyChangeEvent(this, prop, old, n);
        this.fireTimelineEvent(null, (l, ev) -> l.propertyChange(e));
        this.propSupport.firePropertyChange(e);
    }

    private void updateColors() {
    }

    public synchronized boolean isHideDuplicates() {
        return this.hideDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHideDuplicates(boolean ignore) {
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            if (this.hideDuplicates == ignore) {
                return;
            }
            this.hideDuplicates = ignore;
        }
        this.changed(null);
        this.fireOwnPropertyChange("hideDuplicates", !ignore, ignore);
    }

    public GraphContainer getPartition(String type) {
        this.ensureInitialized();
        return this.containers.get(type);
    }

    public GraphContainer getPrimaryPartition() {
        return this.primaryContainer;
    }

    public RangeSliderModel getPrimaryRange() {
        this.ensureInitialized();
        return this.primaryModel;
    }

    public Set<GraphContainer> getPartitions() {
        this.ensureInitialized();
        return new HashSet<GraphContainer>(this.containers.values());
    }

    public Set<String> getPartitionTypes() {
        this.ensureInitialized();
        return Collections.unmodifiableSet(this.containers.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangeSliderModel getPartitionRange(String type) {
        if (Objects.equals(this.primaryType, type)) {
            return this.primaryModel;
        }
        if (type == null) {
            return null;
        }
        this.ensureInitialized();
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            return this.sliderModels.get(type);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(l);
    }

    public void setTrackedNodes(Set<Integer> nodes) {
        this.trackedNodes = new HashSet<Integer>(nodes);
        this.updateColors();
    }

    public Set<Integer> getTrackedNodes() {
        return Collections.unmodifiableSet(this.trackedNodes);
    }

    public InputGraph findGraph(RangeSliderModel model, int position) {
        List posNames = model.getPositions();
        if (position < 0 || position >= posNames.size()) {
            return null;
        }
        String name = (String)posNames.get(position);
        String type = this.findRangeType(model);
        GraphContainer cont = this.getPartition(type);
        for (InputGraph ig : cont.getGraphs()) {
            if (!name.equals(ig.getName())) continue;
            return ig;
        }
        return null;
    }

    public GraphContainer getSource() {
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteWhenStable(final Runnable r) {
        RequestProcessor.Task t;
        TimelineModelImpl timelineModelImpl = this;
        synchronized (timelineModelImpl) {
            t = this.refreshTask;
        }
        if (t != null) {
            LOG.log(Level.FINER, "{0}: Task pending, adding listener; {1}", new Object[]{this, t.isFinished()});
            t.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    LOG.log(Level.FINER, "{0}: Task finished, invoking in EDT", this);
                    SwingUtilities.invokeLater(r);
                }
            });
        } else {
            LOG.log(Level.FINER, "{0}: No task, going EDT", this);
            SwingUtilities.invokeLater(r);
        }
    }

    public Executor whenStable() {
        return this.awtExecutor;
    }

    public String toString() {
        return "Timeline[" + this.primaryType + ", range=" + this.primaryModel + ", max=" + this.primaryModel.getPositions().size() + "]";
    }

    private class L
    implements PropertyChangeListener,
    ChangedListener<RangeSliderModel> {
        private L() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TimelineModelImpl.this.fireRangePropertyChanged(evt);
        }

        public void changed(RangeSliderModel source) {
            if (!TimelineModelImpl.this.suppressRefireEvents) {
                TimelineModelImpl.this.fireRangeChanged(source);
            }
        }
    }

    private class RangeSliderAccess
    extends RangeSliderModel {
        private int oldPos1;
        private int oldPos2;

        RangeSliderAccess(List<String> positions) {
            super(positions);
        }

        RangeSliderAccess(RangeSliderModel model) {
            super(model);
        }

        public void setPositions(List<String> positions) {
            super.setPositions(positions);
        }

        protected boolean getPositionsDiffers0(RangeSliderModel model) {
            return super.getPositionsDiffers(model);
        }

        protected boolean getColorsDiffers0(RangeSliderModel model) {
            return super.getColorsDiffers(model);
        }

        protected void setIndices0(Map<String, Integer> indices) {
            this.setIndices(indices);
        }

        public String toString() {
            int s;
            int f = this.getFirstPosition();
            if (f == (s = this.getSecondPosition())) {
                return "(" + f + ")";
            }
            return "(" + f + "-" + s + ")";
        }
    }
}

