/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.JavaHelp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class JavaHelpQuery
implements Comparator<SearchTOCItem> {
    private static JavaHelpQuery theInstance;
    private SearchEngine engine;
    private static final Logger LOG;

    private JavaHelpQuery() {
    }

    public static JavaHelpQuery getDefault() {
        if (null == theInstance) {
            theInstance = new JavaHelpQuery();
        }
        return theInstance;
    }

    @Override
    public int compare(SearchTOCItem o1, SearchTOCItem o2) {
        int res = o2.hitCount() - o1.hitCount();
        if (0 == res) {
            double conf2;
            double conf1 = o1.getConfidence();
            if (conf1 < (conf2 = o2.getConfidence())) {
                res = -11;
            } else if (conf1 > conf2) {
                res = 1;
            }
        }
        return res;
    }

    public synchronized List<SearchTOCItem> search(String searchString) {
        if (null == this.engine) {
            this.engine = this.createSearchEngine();
        }
        ArrayList<SearchTOCItem> res = new ArrayList<SearchTOCItem>();
        Thread searchThread = new Thread(this.createSearch(searchString, res), "JavaHelpQuery.search[" + searchString + "]");
        searchThread.start();
        try {
            searchThread.join(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return res;
    }

    private Runnable createSearch(final String searchString, final List<SearchTOCItem> items) {
        Runnable res = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (null == JavaHelpQuery.this.engine) {
                    return;
                }
                SynchronizedSearchListener ssl = new SynchronizedSearchListener(items);
                SearchQuery query = JavaHelpQuery.this.engine.createQuery();
                query.addSearchListener((SearchListener)ssl);
                query.start(searchString, Locale.getDefault());
                SynchronizedSearchListener synchronizedSearchListener = ssl;
                synchronized (synchronizedSearchListener) {
                    while (!ssl.isSearchDone()) {
                        try {
                            ssl.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                items.sort(JavaHelpQuery.this);
            }
        };
        return res;
    }

    private SearchEngine createSearchEngine() {
        JavaHelp jh;
        SearchEngine se = null;
        Help h = (Help)Lookup.getDefault().lookup(Help.class);
        if (h instanceof JavaHelp && null == (se = (jh = (JavaHelp)h).createSearchEngine())) {
            LOG.log(Level.INFO, NbBundle.getMessage(JavaHelpQuery.class, (String)"Err_CreateJavaHelpSearchEngine"));
            se = new DummySearchEngine();
        }
        return se;
    }

    static {
        LOG = Logger.getLogger(JavaHelpQuery.class.getName());
    }

    private static class DummySearchEngine
    extends SearchEngine {
        private DummySearchEngine() {
        }

        public SearchQuery createQuery() throws IllegalStateException {
            return new DummySearchQuery(this);
        }
    }

    private class SynchronizedSearchListener
    implements SearchListener {
        private final List<SearchTOCItem> items;
        private boolean searchDone = false;

        public SynchronizedSearchListener(List<SearchTOCItem> items) {
            this.items = items;
        }

        public void itemsFound(SearchEvent se) {
            this.addItemsToList(se.getSearchItems(), this.items);
        }

        public void searchStarted(SearchEvent se) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void searchFinished(SearchEvent se) {
            SynchronizedSearchListener synchronizedSearchListener = this;
            synchronized (synchronizedSearchListener) {
                this.searchDone = true;
                this.notifyAll();
            }
        }

        public boolean isSearchDone() {
            return this.searchDone;
        }

        private void addItemsToList(Enumeration searchItems, List<SearchTOCItem> results) {
            if (null == searchItems) {
                return;
            }
            while (searchItems.hasMoreElements()) {
                URL url;
                SearchItem si = (SearchItem)searchItems.nextElement();
                try {
                    url = new URL(si.getBase(), si.getFilename());
                }
                catch (MalformedURLException murlE) {
                    LOG.log(Level.FINE, "Invalid URL in SearchItem: " + si.getTitle(), murlE);
                    continue;
                }
                boolean foundToc = false;
                for (SearchTOCItem toc : results) {
                    URL testURL = toc.getURL();
                    if (testURL == null || url == null || !url.sameFile(testURL)) continue;
                    toc.addSearchHit(new SearchHit(si.getConfidence(), si.getBegin(), si.getEnd()));
                    foundToc = true;
                    break;
                }
                if (foundToc) continue;
                SearchTOCItem toc = new SearchTOCItem(si);
                results.add(toc);
            }
        }
    }

    private static class DummySearchQuery
    extends SearchQuery {
        private List<SearchListener> listeners = new ArrayList<SearchListener>(1);

        public DummySearchQuery(DummySearchEngine se) {
            super((SearchEngine)se);
        }

        public void addSearchListener(SearchListener arg0) {
            this.listeners.add(arg0);
        }

        public void removeSearchListener(SearchListener arg0) {
            this.listeners.remove(arg0);
        }

        public void start(String arg0, Locale arg1) throws IllegalArgumentException, IllegalStateException {
            SearchEvent se = new SearchEvent((Object)this, "", false);
            for (SearchListener sl : this.listeners) {
                sl.searchStarted(se);
                sl.searchFinished(se);
            }
        }

        public void stop() throws IllegalStateException {
        }

        public boolean isActive() {
            return false;
        }
    }
}

