/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.controlflow;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import org.graalvm.visualizer.controlflow.ControlFlowScene;
import org.graalvm.visualizer.layout.Cluster;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;

public class BlockWidget
extends LabelWidget
implements Vertex {
    private static final Font FONT = new Font("SansSerif", 0, 12);
    private static final Font BOLD_FONT = FONT.deriveFont(1);
    public static final Color NORMAL_FOREGROUND_COLOR = Color.BLACK;
    public static final Color HOVER_FOREGROUND_COLOR = Color.BLUE;
    public static final Color DEFAULT_COLOR = Color.WHITE;
    public static final Color SELECTED_COLOR = Color.ORANGE;
    public static final Dimension MIN_SIZE = new Dimension(20, 20);
    private InputBlock block;
    private Port inputSlot;
    private final Port outputSlot;
    private Cluster cluster;
    private boolean root;

    public BlockWidget(ControlFlowScene scene, InputBlock block) {
        super((Scene)scene);
        this.block = block;
        this.setLabel(block.getName());
        this.setForeground(NORMAL_FOREGROUND_COLOR);
        this.setBorder(BorderFactory.createLineBorder((int)1, (Color)NORMAL_FOREGROUND_COLOR));
        this.setMinimumSize(MIN_SIZE);
        this.setOpaque(true);
        this.setFont(FONT);
        this.setAlignment(LabelWidget.Alignment.CENTER);
        final BlockWidget widget = this;
        this.inputSlot = new Port(){

            public Point getRelativePosition() {
                return new Point((int)(BlockWidget.this.getSize().getWidth() / 2.0), (int)(BlockWidget.this.getSize().getHeight() / 2.0));
            }

            public Vertex getVertex() {
                return widget;
            }
        };
        this.outputSlot = new Port(){

            public Point getRelativePosition() {
                return new Point((int)(BlockWidget.this.getSize().getWidth() / 2.0), (int)(BlockWidget.this.getSize().getHeight() / 2.0));
            }

            public Vertex getVertex() {
                return widget;
            }
        };
    }

    public Port getInputSlot() {
        return this.inputSlot;
    }

    public Port getOutputSlot() {
        return this.outputSlot;
    }

    public InputBlock getBlock() {
        return this.block;
    }

    public Dimension getSize() {
        Rectangle bounds = this.getBounds();
        if (bounds != null) {
            return bounds.getSize();
        }
        return MIN_SIZE;
    }

    public void setPosition(Point p) {
        this.setPreferredLocation(p);
    }

    public String toString() {
        return this.block.getName();
    }

    public Point getPosition() {
        return this.getPreferredLocation();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setCluster(Cluster c) {
        this.cluster = c;
    }

    public void setRoot(boolean b) {
        this.root = b;
    }

    public int compareTo(Vertex o) {
        return this.toString().compareTo(o.toString());
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        super.notifyStateChanged(previousState, state);
        if (previousState.isHovered() != state.isHovered()) {
            if (state.isHovered()) {
                this.setBorder(BorderFactory.createLineBorder((int)1, (Color)HOVER_FOREGROUND_COLOR));
            } else {
                this.setBorder(BorderFactory.createLineBorder((int)1, (Color)NORMAL_FOREGROUND_COLOR));
            }
        }
        if (previousState.isSelected() != state.isSelected()) {
            if (state.isSelected()) {
                this.setFont(BOLD_FONT);
            } else {
                this.setFont(FONT);
            }
        }
    }
}

