/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.controlflow;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputBlockEdge;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.controlflow.BlockConnectionWidget;
import org.graalvm.visualizer.controlflow.BlockWidget;
import org.graalvm.visualizer.controlflow.DoubleClickSelectAction;
import org.graalvm.visualizer.controlflow.HierarchicalGraphLayout;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ControlFlowScene
extends GraphScene<InputBlock, InputBlockEdge>
implements SelectProvider,
MoveProvider,
RectangularSelectDecorator,
RectangularSelectProvider {
    private static final InputGraph EMPTY = new InputGraph(null, -1, "", new Object[0]);
    private final HashSet<BlockWidget> selection;
    private InputGraphProvider provider;
    private final LayerWidget edgeLayer;
    private final LayerWidget mainLayer;
    private final LayerWidget selectLayer;
    private final WidgetAction hoverAction = this.createWidgetHoverAction();
    private final WidgetAction selectAction = new DoubleClickSelectAction(this);
    private final WidgetAction moveAction = ActionFactory.createMoveAction(null, (MoveProvider)this);
    private InputGraph oldGraph;

    public ControlFlowScene() {
        this.selection = new HashSet();
        this.getInputBindings().setZoomActionModifiers(0);
        this.setLayout(LayoutFactory.createAbsoluteLayout());
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.edgeLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.edgeLayer);
        this.selectLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.selectLayer);
        this.getActions().addAction(this.hoverAction);
        this.getActions().addAction(this.selectAction);
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((RectangularSelectDecorator)this, (LayerWidget)this.selectLayer, (RectangularSelectProvider)this));
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.1));
    }

    public void changeProvider(InputGraphProvider provider) {
        this.provider = provider;
        InputGraph graph = null;
        if (provider != null) {
            graph = provider.getGraph();
        }
        if (graph == null) {
            graph = EMPTY;
        }
        this.setGraph(graph);
        if (provider != null) {
            this.colorSelected();
        }
    }

    private void setGraph(InputGraph g) {
        if (g == this.oldGraph) {
            return;
        }
        this.oldGraph = g;
        ArrayList<InputBlock> blocks = new ArrayList<InputBlock>(this.getNodes());
        blocks.forEach(arg_0 -> ((ControlFlowScene)this).removeNode(arg_0));
        ArrayList<InputBlockEdge> edges = new ArrayList<InputBlockEdge>(this.getEdges());
        edges.forEach(arg_0 -> ((ControlFlowScene)this).removeEdge(arg_0));
        g.getBlocks().forEach(arg_0 -> ((ControlFlowScene)this).addNode(arg_0));
        for (InputBlockEdge e : g.getBlockEdges()) {
            this.addEdge(e);
            assert (g.getBlocks().contains(e.getFrom()));
            assert (g.getBlocks().contains(e.getTo()));
            this.setEdgeSource(e, e.getFrom());
            this.setEdgeTarget(e, e.getTo());
        }
        LayoutFactory.createSceneGraphLayout((GraphScene)this, new HierarchicalGraphLayout()).invokeLayout();
    }

    public void clearSelection() {
        for (BlockWidget w : this.selection) {
            w.setState(w.getState().deriveSelected(false));
        }
        this.selection.clear();
        this.selectionChanged();
    }

    public void selectionChanged() {
        if (this.provider != null) {
            HashSet inputNodes = new HashSet();
            for (BlockWidget w : this.selection) {
                inputNodes.addAll(w.getBlock().getNodes());
            }
            this.provider.setSelectedNodes(inputNodes);
        }
    }

    public void addToSelection(BlockWidget widget) {
        widget.setState(widget.getState().deriveSelected(true));
        this.selection.add(widget);
        this.selectionChanged();
    }

    public void removeFromSelection(BlockWidget widget) {
        widget.setState(widget.getState().deriveSelected(false));
        this.selection.remove((Object)widget);
        this.selectionChanged();
    }

    public boolean isAimingAllowed(Widget widget, Point point, boolean b) {
        return false;
    }

    public boolean isSelectionAllowed(Widget widget, Point point, boolean b) {
        return true;
    }

    public void select(Widget widget, Point point, boolean change) {
        if (widget == this) {
            this.clearSelection();
        } else {
            assert (widget instanceof BlockWidget);
            BlockWidget bw = (BlockWidget)widget;
            if (change) {
                if (this.selection.contains((Object)bw)) {
                    this.removeFromSelection(bw);
                } else {
                    this.addToSelection(bw);
                }
            } else if (!this.selection.contains((Object)bw)) {
                this.clearSelection();
                this.addToSelection(bw);
            }
        }
    }

    public void movementStarted(Widget widget) {
    }

    public void movementFinished(Widget widget) {
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getPreferredLocation();
    }

    public void setNewLocation(Widget widget, Point location) {
        if (widget instanceof BlockWidget && this.selection.contains((Object)((BlockWidget)widget))) {
            Point originalLocation = this.getOriginalLocation(widget);
            int xOffset = location.x - originalLocation.x;
            int yOffset = location.y - originalLocation.y;
            for (BlockWidget w : this.selection) {
                Point p = new Point(w.getPreferredLocation());
                p.translate(xOffset, yOffset);
                w.setPreferredLocation(p);
            }
        } else {
            widget.setPreferredLocation(location);
        }
    }

    public Widget createSelectionWidget() {
        Widget widget = new Widget((Scene)this);
        widget.setOpaque(false);
        widget.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        widget.setForeground(Color.red);
        return widget;
    }

    public void performSelection(Rectangle rectangle) {
        if (rectangle.width < 0) {
            rectangle.x += rectangle.width;
            rectangle.width *= -1;
        }
        if (rectangle.height < 0) {
            rectangle.y += rectangle.height;
            rectangle.height *= -1;
        }
        boolean changed = false;
        for (InputBlock b : this.getNodes()) {
            BlockWidget w = (BlockWidget)this.findWidget(b);
            if (w == null) continue;
            Rectangle r = w.getBounds();
            boolean remove = false;
            if (r != null) {
                r.setLocation(w.getLocation());
                if (r.intersects(rectangle)) {
                    if (!this.selection.contains((Object)w)) {
                        changed = true;
                        this.selection.add(w);
                        w.setState(w.getState().deriveSelected(true));
                    }
                    remove = true;
                }
            }
            if (!remove || !this.selection.contains((Object)w)) continue;
            changed = true;
            this.selection.remove((Object)w);
            w.setState(w.getState().deriveSelected(false));
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    protected Widget attachNodeWidget(InputBlock node) {
        BlockWidget w = new BlockWidget(this, node);
        this.mainLayer.addChild((Widget)w);
        w.getActions().addAction(this.hoverAction);
        w.getActions().addAction(this.selectAction);
        w.getActions().addAction(this.moveAction);
        return w;
    }

    protected Widget attachEdgeWidget(InputBlockEdge edge) {
        BlockConnectionWidget w = new BlockConnectionWidget(this, edge);
        switch (edge.getState()) {
            case NEW: {
                w.setBold(true);
                break;
            }
            case DELETED: {
                w.setDashed(true);
            }
        }
        w.setRouter(RouterFactory.createDirectRouter());
        w.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        this.edgeLayer.addChild((Widget)w);
        return w;
    }

    protected void attachEdgeSourceAnchor(InputBlockEdge edge, InputBlock oldSourceNode, InputBlock sourceNode) {
        Widget w = this.findWidget(edge);
        assert (w instanceof ConnectionWidget);
        ConnectionWidget cw = (ConnectionWidget)w;
        cw.setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)this.findWidget(sourceNode)));
    }

    protected void attachEdgeTargetAnchor(InputBlockEdge edge, InputBlock oldTargetNode, InputBlock targetNode) {
        Widget w = this.findWidget(edge);
        assert (w instanceof ConnectionWidget);
        ConnectionWidget cw = (ConnectionWidget)w;
        cw.setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)this.findWidget(targetNode)));
    }

    private void colorSelected() {
        Collection nodes = this.provider.getLookup().lookupAll(InputNode.class);
        Set selectedBlocks = nodes.stream().map(InputNode::getId).distinct().map(x -> this.oldGraph.getBlock(x.intValue())).filter(b -> b != null).map(InputBlock::getName).collect(Collectors.toSet());
        Set selectedWidgets = this.mainLayer.getChildren().stream().filter(x -> selectedBlocks.contains(((BlockWidget)((Object)x)).getBlock().getName())).collect(Collectors.toSet());
        for (Widget widget : this.mainLayer.getChildren()) {
            widget.setBackground((Paint)BlockWidget.DEFAULT_COLOR);
        }
        for (Widget widget : selectedWidgets) {
            widget.setBackground((Paint)BlockWidget.SELECTED_COLOR);
        }
        this.validate();
    }
}

