/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.openjdk.jtreg.Bundle;
import org.netbeans.modules.java.openjdk.jtreg.Tag;
import org.netbeans.modules.java.openjdk.jtreg.TagParser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;

public class WrongSourceVersion {
    public static List<ErrorDescription> computeWarning(HintContext ctx) {
        TagParser.Result tags = TagParser.parseTags(ctx.getInfo());
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        for (Tag tag : tags.getTags()) {
            String[] params;
            boolean hasEnablePreview;
            if (!"compile".equals(tag.getName()) || !(hasEnablePreview = Arrays.stream(params = tag.getValue().split("[\\s]+")).anyMatch(s -> "--enable-preview".equals(s)))) continue;
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].equals("-source") && !params[i].equals("--source") || i + 1 >= params.length) continue;
                try {
                    Integer.parseInt(params[i + 1]);
                    int pos = tag.getValue().indexOf(params[i]);
                    int start = tag.getValue().indexOf(params[i + 1], pos) + tag.getTagEnd();
                    int end = start + params[i + 1].length();
                    ErrorDescription idealED = org.netbeans.spi.java.hints.ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_HardcodedSource(), (Fix[])new Fix[]{new UseJdkSource(ctx.getInfo(), ctx.getPath(), start, end).toEditorFix()});
                    result.add(ErrorDescriptionFactory.createErrorDescription((Severity)idealED.getSeverity(), (String)idealED.getDescription(), (LazyFixList)idealED.getFixes(), (FileObject)ctx.getInfo().getFileObject(), (int)start, (int)end));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private static final class UseJdkSource
    extends JavaFix {
        private final int start;
        private final int end;

        public UseJdkSource(CompilationInfo info, TreePath tp, int start, int end) {
            super(info, tp);
            this.start = start;
            this.end = end;
        }

        protected String getText() {
            return Bundle.FIX_AddRefOutput();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws IOException {
            ctx.getWorkingCopy().rewriteInComment(this.start, this.end - this.start, "${jdk.version}");
        }
    }
}

