/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.actions;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.graalvm.visualizer.shell.ShellUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;

public class CreateFilterAction
extends AbstractAction
implements ActionListener,
Presenter.Menu,
Presenter.Toolbar {
    private final FileObject file;

    public CreateFilterAction(FileObject file) {
        this.file = file;
        this.setEnabled(ShellUtils.isScriptObject(file) && ShellUtils.visibleScriptObjects().test(file));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            FileObject filterDir = FileUtil.getConfigFile((String)"Filters");
            DataObject original = DataObject.find((FileObject)this.file);
            DataShadow.create((DataFolder)DataFolder.findFolder((FileObject)filterDir), (DataObject)original);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public JMenuItem getMenuPresenter() {
        return ActionPresenterProvider.getDefault().createMenuPresenter((Action)this);
    }

    public Component getToolbarPresenter() {
        return ActionPresenterProvider.getDefault().createToolbarPresenter((Action)this);
    }

    public static Action createContextAction(Lookup lkp) {
        try {
            InstanceDataObject ido = InstanceDataObject.find((DataFolder)DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)"Actions/IGV")), (String)"org-graalvm-visualizer-shell-actions-createFilter", Action.class);
            if (ido == null) {
                return null;
            }
            Object o = ((InstanceCookie)ido.getLookup().lookup(InstanceCookie.class)).instanceCreate();
            if (o instanceof ContextAwareAction) {
                return ((ContextAwareAction)o).createContextAwareInstance(lkp);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

