/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import org.graalvm.visualizer.filter.DiagramFilters;
import org.graalvm.visualizer.util.RangeSliderModel;
import org.graalvm.visualizer.view.api.DiagramModel;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;

public class ResetDiagramGlobalAction
extends AbstractAction
implements ActionListener,
Presenter.Menu,
Presenter.Toolbar,
ChangedListener<RangeSliderModel> {
    private final Reference<DiagramFilters> refModel;

    public ResetDiagramGlobalAction(DiagramModel model) {
        this.refModel = new WeakReference<DiagramFilters>((DiagramFilters)model.getLookup().lookup(DiagramFilters.class));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DiagramFilters m = this.refModel.get();
        if (m != null) {
            m.applyScriptFilter(null, null, false, null);
        }
    }

    public void changed(RangeSliderModel source) {
        DiagramFilters m = this.refModel.get();
        if (m != null) {
            SwingUtilities.invokeLater(() -> this.setEnabled(m.getScriptFilters().isEmpty()));
        }
    }

    public JMenuItem getMenuPresenter() {
        return ActionPresenterProvider.getDefault().createMenuPresenter((Action)this);
    }

    public Component getToolbarPresenter() {
        return ActionPresenterProvider.getDefault().createToolbarPresenter((Action)this);
    }
}

