/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.graalvm.visualizer.coordinator.actions.Bundle;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;
import org.graalvm.visualizer.settings.graal.GraalSettings;
import org.openide.awt.Actions;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;

public class AutoFreezeSessionsAction
extends AbstractAction
implements Presenter.Toolbar {
    public static final String ID = "org.graalvm.visualizer.coordinator.actions.AutoFreezeSessionsAction";

    public AutoFreezeSessionsAction() {
        this.putValue("ShortDescription", Bundle.ACTION_AutoFreezeSessionsAction());
        this.putValue("SwingSelectedKey", GraalSettings.obtain().get(Boolean.class, "autoSeparateSessions"));
        this.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)this.iconResource())));
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/coordinator/images/autoFreezeSessions.png";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean en = Boolean.TRUE != this.getValue("SwingSelectedKey");
        SessionManagerImpl.getInstance().setSeparateSessions(en);
        this.putValue("SwingSelectedKey", en);
        if (en) {
            SessionManagerImpl.getInstance().freezeCurrentDocuments();
        }
    }

    public Component getToolbarPresenter() {
        JToggleButton b = new JToggleButton();
        if (Boolean.TRUE == this.getValue("SwingSelectedKey")) {
            b.setSelected(this.enabled);
        }
        Actions.connect((AbstractButton)b, (Action)this);
        return b;
    }
}

