/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class ActionUtils {
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final MouseListener sharedMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent evt) {
            AbstractButton button;
            Object src = evt.getSource();
            if (src instanceof AbstractButton && (button = (AbstractButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            Object src = evt.getSource();
            if (src instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)evt.getSource();
                ActionUtils.removeButtonContentAreaAndBorder(button);
            }
        }
    };

    private ActionUtils() {
    }

    private static void processButton(AbstractButton button) {
        if (button == null) {
            return;
        }
        ActionUtils.removeButtonContentAreaAndBorder(button);
        button.setMargin(BUTTON_INSETS);
        button.addMouseListener(sharedMouseListener);
        button.setFocusable(false);
    }

    private static void removeButtonContentAreaAndBorder(AbstractButton button) {
        boolean canRemove = true;
        if (button instanceof JToggleButton) {
            boolean bl = canRemove = !button.isSelected();
        }
        if (canRemove) {
            button.setContentAreaFilled(false);
            button.setBorderPainted(false);
        }
    }

    public static Action findAction(String category, String id, Lookup context) {
        Action a = Actions.forID((String)category, (String)id);
        if (a == null) {
            return null;
        }
        if (a instanceof ContextAwareAction) {
            if ((a = ((ContextAwareAction)a).createContextAwareInstance(context)) instanceof PropertyChangeListener) {
                ((PropertyChangeListener)((Object)a)).propertyChange(new PropertyChangeEvent(a, "SwingSelectedKey", null, Boolean.TRUE));
            }
            a.isEnabled();
        }
        return a;
    }

    public static ActionMap populatePopupMenu(JPopupMenu menu, ActionMap am, String configFolder, Lookup context) {
        if (am == null) {
            am = new ActionMap();
        }
        for (Action a : Utilities.actionsForPath((String)configFolder)) {
            if (a == null) {
                menu.addSeparator();
                continue;
            }
            if (a instanceof ContextAwareAction) {
                if ((a = ((ContextAwareAction)a).createContextAwareInstance(context)) instanceof PropertyChangeListener) {
                    ((PropertyChangeListener)((Object)a)).propertyChange(new PropertyChangeEvent(a, "SwingSelectedKey", null, Boolean.TRUE));
                }
                a.isEnabled();
            }
            JMenuItem item = a instanceof Presenter.Popup ? menu.add(((Presenter.Popup)a).getPopupPresenter()) : menu.add(a);
            String n = (String)a.getValue("Name");
            String desc = (String)a.getValue("ShortDescription");
            if (desc == null || desc.equals(n)) continue;
            am.put(n, a);
        }
        return am;
    }

    public static Action addToolbarAction(JToolBar toolBar, Action a, ActionMap am, Lookup context, boolean processButtons) {
        Component item;
        if (a == null) {
            toolBar.addSeparator();
            return null;
        }
        if (a instanceof ContextAwareAction) {
            if ((a = ((ContextAwareAction)a).createContextAwareInstance(context)) instanceof PropertyChangeListener) {
                ((PropertyChangeListener)((Object)a)).propertyChange(new PropertyChangeEvent(a, "SwingSelectedKey", null, Boolean.TRUE));
            }
            a.isEnabled();
        }
        String n = (String)a.getValue("Name");
        String desc = (String)a.getValue("ShortDescription");
        if (a instanceof Presenter.Toolbar) {
            item = toolBar.add(((Presenter.Toolbar)a).getToolbarPresenter());
        } else {
            JButton b = toolBar.add(a);
            String tooltip = desc;
            if (tooltip == null) {
                tooltip = n;
            }
            b.setToolTipText(tooltip);
            item = b;
        }
        if (item instanceof AbstractButton && processButtons) {
            AbstractButton button = (AbstractButton)item;
            ActionUtils.processButton(button);
        }
        if (am != null && desc != null && !desc.equals(n)) {
            am.put(n, a);
        }
        return a;
    }

    public static ActionMap populateToolbar(JToolBar toolBar, ActionMap am, String toolbarConfigFolder, Lookup context, boolean processButtons) {
        if (am == null) {
            am = new ActionMap();
        }
        for (Action a : Utilities.actionsForPath((String)toolbarConfigFolder)) {
            Component item;
            if (a == null) {
                toolBar.addSeparator();
                continue;
            }
            if (a instanceof ContextAwareAction) {
                if ((a = ((ContextAwareAction)a).createContextAwareInstance(context)) instanceof PropertyChangeListener) {
                    ((PropertyChangeListener)((Object)a)).propertyChange(new PropertyChangeEvent(a, "SwingSelectedKey", null, Boolean.TRUE));
                }
                a.isEnabled();
            }
            if ((item = a instanceof Presenter.Toolbar ? toolBar.add(((Presenter.Toolbar)a).getToolbarPresenter()) : toolBar.add(a)) instanceof AbstractButton && processButtons) {
                AbstractButton button = item;
                ActionUtils.processButton(button);
            }
            String n = (String)a.getValue("Name");
            String desc = (String)a.getValue("ShortDescription");
            if (desc == null || desc.equals(n)) continue;
            am.put(n, a);
        }
        return am;
    }
}

