/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.search.GraphItem;
import org.graalvm.visualizer.search.ResultItem;

public class NodeResultItem
implements ResultItem {
    private final GraphItem owner;
    private final int nodeId;
    private Properties itemProperties;
    private InputNode node;

    public NodeResultItem(GraphItem ownerHandle, int nodeId, Properties nodeProperties) {
        this.owner = ownerHandle;
        this.nodeId = nodeId;
        this.itemProperties = nodeProperties;
    }

    public NodeResultItem(GraphItem ownerHandle, InputNode node) {
        this.owner = ownerHandle;
        this.node = node;
        this.nodeId = node.getId();
        this.itemProperties = Properties.newProperties((Properties)node.getProperties());
    }

    public NodeResultItem(GraphItem ownerHandle, InputNode node, Properties itemProperties) {
        this.owner = ownerHandle;
        this.itemProperties = itemProperties;
        this.node = node;
        this.nodeId = node.getId();
    }

    public InputNode getNode() {
        return this.node;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public GraphItem getOwner() {
        return this.owner;
    }

    public Properties getItemProperties() {
        return this.itemProperties;
    }

    @Override
    public String getDisplayName() {
        return this.itemProperties.getString("name", null);
    }

    public Properties getProperties() {
        return this.itemProperties;
    }
}

