/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui;

import java.util.EventListener;
import org.graalvm.visualizer.search.NodeResultItem;
import org.graalvm.visualizer.search.SearchResultsEvent;
import org.graalvm.visualizer.search.SearchResultsListener;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.ui.ItemNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class ResultsFlatChildren
extends Children.Keys<NodeResultItem>
implements SearchResultsListener {
    private final SearchResultsModel model;
    private SearchResultsListener wl;

    public ResultsFlatChildren(SearchResultsModel model) {
        this.model = model;
        this.wl = (SearchResultsListener)WeakListeners.create(SearchResultsListener.class, (EventListener)this, (Object)model);
        model.addSearchResultsListener(this.wl);
        this.refreshKeys();
    }

    protected void removeNotify() {
        this.model.removeSearchResultsListener(this.wl);
        super.removeNotify();
    }

    protected void addNotify() {
        super.addNotify();
        if (this.wl == null) {
            this.wl = (SearchResultsListener)WeakListeners.create(SearchResultsListener.class, (EventListener)this, (Object)this.model);
        }
    }

    @Override
    public void itemsAdded(SearchResultsEvent event) {
        this.refreshKeys();
    }

    @Override
    public void itemsRemoved(SearchResultsEvent event) {
        this.refreshKeys();
    }

    private void refreshKeys() {
        this.setKeys(this.model.getItems());
    }

    protected Node[] createNodes(NodeResultItem t) {
        return new Node[]{ItemNode.createNode(this.model, t, Lookup.EMPTY)};
    }
}

