/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.search.ui.actions.Bundle;
import org.graalvm.visualizer.search.ui.actions.GraphContextAction;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.openide.util.Lookup;

public class ExtractNodesAction
extends GraphContextAction {
    public ExtractNodesAction(List<InputNode> nodes) {
        super(nodes);
    }

    private ExtractNodesAction(Lookup context) {
        super(context);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DiagramViewer vwr = (DiagramViewer)((GraphViewer)Lookup.getDefault().lookup(GraphViewer.class)).getActiveViewer();
        if (vwr != null && vwr.getModel().getContainer().getContentOwner() == this.getTargetGroup()) {
            vwr.getSelections().extractNodes(this.getInputNodes());
        }
        ((GraphViewer)Lookup.getDefault().lookup(GraphViewer.class)).view((success, provider) -> this.doExtract((InputGraphProvider)provider, (Collection<InputNode>)this.getInputNodes()), this.getTargetGraph(), false, true, new Object[0]);
    }

    private void doExtract(InputGraphProvider provider, Collection<InputNode> nodes) {
        DiagramViewer v = (DiagramViewer)provider;
        v.getSelections().extractNodes(nodes);
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new ExtractNodesAction(lkp);
    }

    @Override
    protected String createNameWithTarget(Group targetGroup, InputGraph targetGraph) {
        return Bundle.NAME_ExtractInGraph(targetGroup.getName());
    }
}

