/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.settings;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.graalvm.visualizer.settings.Settings;
import org.openide.util.WeakListeners;

public abstract class SettingsStore<S extends SettingsStore<S, B>, B extends SettingsBean<S, B>>
implements Settings {
    protected final B bean;
    protected final Preferences PREFERENCES = Preferences.userNodeForPackage(this.getClass());
    private static final Map<Class<?>, PrefMapper> prefMaps;
    public final Map<Class, Map<String, Object>> defaults;
    private final WeakeningChangeListenerList LISTENERS = new WeakeningChangeListenerList();

    protected static <S extends SettingsStore<S, B>, B extends SettingsBean<S, B>> S obtain(Class<S> type) {
        return SettingsHolder.obtain(type);
    }

    protected static <S extends SettingsStore<S, B>, B extends SettingsBean<S, B>> S obtain(Class<S> type, Supplier<S> get) {
        return SettingsHolder.obtain(type, get);
    }

    protected SettingsStore() {
        SettingsHolder.register(this);
        HashMap<Class, Map<String, Object>> defs = new HashMap<Class, Map<String, Object>>();
        this.fillDefaults((n, v) -> SettingsStore.def(defs, n, v));
        this.defaults = SettingsStore.finalize(defs);
        this.bean = this.makeBean();
        ((SettingsBean)this.bean).load();
    }

    protected abstract void fillDefaults(BiConsumer<String, Object> var1);

    protected abstract B makeBean();

    public B obtainBean() {
        return ((SettingsBean)this.bean).copy();
    }

    private static void def(Map<Class, Map<String, Object>> defs, String propName, Object def) {
        defs.computeIfAbsent(def.getClass(), c -> new HashMap()).put(propName, def);
    }

    private static Map<Class, Map<String, Object>> finalize(Map<Class, Map<String, Object>> defs) {
        defs.replaceAll((k, m) -> Collections.unmodifiableMap(m));
        return Collections.unmodifiableMap(defs);
    }

    @Override
    public <T> T set(String propertyName, T val) {
        Class<?> type;
        PrefMapper mapper;
        T obj = ((SettingsBean)this.bean).set(propertyName, val);
        if (obj != null && !obj.equals(val) && (mapper = prefMaps.get(type = obj.getClass())) != null) {
            mapper.save(this.PREFERENCES, propertyName, val == null ? this.getDefault(type, propertyName) : val);
        }
        return obj;
    }

    @Override
    public <T> T get(Class<T> type, String propertyName) {
        return ((SettingsBean)this.bean).get(type, propertyName);
    }

    @Override
    public <T> T get(String propertyName) {
        return ((SettingsBean)this.bean).get(propertyName);
    }

    <T> T getDefault(Class<T> type, String propertyName) {
        return (T)this.defaults.getOrDefault(type, Collections.EMPTY_MAP).get(propertyName);
    }

    <T> T getDefault(String propertyName) {
        for (Map<String, Object> map : this.defaults.values()) {
            Object val = map.get(propertyName);
            if (val == null) continue;
            return (T)val;
        }
        return null;
    }

    @Override
    public void store() {
        ((SettingsBean)this.bean).store();
    }

    public void addWeakChangeListener(ChangeListener l) {
        this.LISTENERS.addWeakChangeListener(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.LISTENERS.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.LISTENERS.removeChangeListener(l);
    }

    public void addPreferenceChangeListener(PreferenceChangeListener l) {
        this.PREFERENCES.addPreferenceChangeListener(l);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener l) {
        this.PREFERENCES.removePreferenceChangeListener(l);
    }

    @Override
    public void fireChanged() {
        this.fireChanged(this.bean);
    }

    void fireChanged(B bean) {
        this.LISTENERS.fire(new ChangeEvent(((SettingsBean)bean).copy()));
    }

    static {
        HashMap prefMapps = new HashMap();
        prefMapps.put(Boolean.class, new PrefMapper(p -> n -> v -> p.putBoolean((String)n, (boolean)v), p -> n -> v -> p.getBoolean((String)n, (boolean)v)));
        prefMapps.put(Integer.class, new PrefMapper(p -> n -> v -> p.putInt((String)n, (int)v), p -> n -> v -> p.getInt((String)n, (int)v)));
        prefMapps.put(Float.class, new PrefMapper(p -> n -> v -> p.putFloat((String)n, v.floatValue()), p -> n -> v -> Float.valueOf(p.getFloat((String)n, v.floatValue()))));
        prefMapps.put(Double.class, new PrefMapper(p -> n -> v -> p.putDouble((String)n, (double)v), p -> n -> v -> p.getDouble((String)n, (double)v)));
        prefMapps.put(String.class, new PrefMapper(p -> n -> v -> p.put((String)n, (String)v), p -> n -> v -> p.get((String)n, (String)v)));
        prefMaps = Collections.unmodifiableMap(prefMapps);
    }

    private static class SettingsHolder {
        private static Map<Class<? extends SettingsStore>, WeakReference<? extends SettingsStore>> hold = new HashMap<Class<? extends SettingsStore>, WeakReference<? extends SettingsStore>>();

        private SettingsHolder() {
        }

        private static synchronized void register(SettingsStore store) {
            Class<?> type = store.getClass();
            WeakReference<? extends SettingsStore> wk = hold.get(type);
            if (wk != null && wk.get() != null) {
                throw new IllegalStateException("Can't instanciate more than one " + store.getClass());
            }
            hold.put(type, new WeakReference<SettingsStore>(store));
        }

        private static synchronized <S extends SettingsStore<S, B>, B extends SettingsBean<S, B>> S obtain(Class<S> type) {
            WeakReference<? extends SettingsStore> wk = hold.get(type);
            if (wk == null) {
                return null;
            }
            return (S)((SettingsStore)wk.get());
        }

        private static synchronized <S extends SettingsStore<S, B>, B extends SettingsBean<S, B>> S obtain(Class<S> type, Supplier<S> get) {
            Object settings = SettingsHolder.obtain(type);
            if (settings == null) {
                settings = (SettingsStore)get.get();
            }
            return settings;
        }
    }

    private static class WeakeningChangeListenerList
    extends EventListenerList {
        private final WeakHashMap<ChangeListener, ChangeListener> weakListenersMapping = new WeakHashMap();

        private WeakeningChangeListenerList() {
        }

        public void removeChangeListener(ChangeListener l) {
            ChangeListener wL = this.weakListenersMapping.get(l);
            if (wL != null) {
                this.weakListenersMapping.remove(l);
                this.remove(ChangeListener.class, wL);
            } else {
                this.remove(ChangeListener.class, l);
            }
        }

        public void addWeakChangeListener(ChangeListener l) {
            if (!this.weakListenersMapping.containsKey(l)) {
                ChangeListener wL = WeakListeners.change((ChangeListener)l, (Object)this);
                this.weakListenersMapping.put(l, wL);
                this.add(ChangeListener.class, wL);
            }
        }

        public void addChangeListener(ChangeListener l) {
            if (!this.weakListenersMapping.containsKey(l)) {
                this.add(ChangeListener.class, l);
                this.weakListenersMapping.put(l, l);
            }
        }

        public void fire(ChangeEvent event) {
            for (ChangeListener l : (ChangeListener[])this.getListeners(ChangeListener.class)) {
                l.stateChanged(event);
            }
        }
    }

    public static abstract class SettingsBean<S extends SettingsStore<S, B>, B extends SettingsBean<S, B>>
    implements Settings {
        final Map<Class, Map<String, Object>> settings;
        protected final S store;

        private SettingsBean() {
            this(null, null);
        }

        private SettingsBean(S store, Map<Class, Map<String, Object>> settings) {
            this.settings = settings;
            this.store = store;
        }

        protected SettingsBean(S store) {
            this(store, SettingsBean.repack(((SettingsStore)store).defaults));
        }

        protected SettingsBean(B bean) {
            this(((SettingsBean)bean).store, SettingsBean.repack(((SettingsBean)bean).settings));
        }

        private static Map<Class, Map<String, Object>> repack(Map<Class, Map<String, Object>> defs) {
            return SettingsBean.repack(defs, new HashMap<Class, Map<String, Object>>());
        }

        private static Map<Class, Map<String, Object>> repack(Map<Class, Map<String, Object>> defs, Map<Class, Map<String, Object>> tmp) {
            defs.forEach((t, m) -> tmp.put((Class)t, new HashMap(m)));
            return tmp;
        }

        public abstract B copy();

        public void load() {
            Preferences prefs = ((SettingsStore)this.store).PREFERENCES;
            ((SettingsStore)this.store).defaults.forEach((t, m) -> {
                PrefMapper mapper;
                Map<String, Object> map = this.settings.get(t);
                if (map != null && (mapper = prefMaps.get(t)) != null) {
                    for (Map.Entry entry : m.entrySet()) {
                        map.put((String)entry.getKey(), mapper.load(prefs, entry));
                    }
                }
            });
        }

        void pull(B bean) {
            if (!((SettingsBean)bean).settings.equals(this.settings)) {
                SettingsBean.repack(((SettingsBean)bean).settings, this.settings);
            }
        }

        public void reset() {
            SettingsBean.repack(((SettingsStore)this.store).defaults, this.settings);
        }

        @Override
        public void store() {
            if (((SettingsStore)this.store).bean != this) {
                ((SettingsStore)this.store).bean.pull((SettingsBean)this);
            }
            Preferences prefs = ((SettingsStore)this.store).PREFERENCES;
            this.settings.forEach((t, m) -> {
                PrefMapper mapper = prefMaps.get(t);
                if (mapper != null) {
                    m.entrySet().forEach(e -> mapper.save(prefs, e));
                }
            });
        }

        @Override
        public <T> T set(String propertyName, T val) {
            if (val == null && (val = ((SettingsStore)this.store).getDefault(propertyName)) == null) {
                return null;
            }
            Map<String, Object> tmap = this.settings.get(val.getClass());
            if (tmap != null && tmap.containsKey(propertyName)) {
                return (T)tmap.put(propertyName, val);
            }
            return null;
        }

        @Override
        public <T> T get(Class<T> type, String propertyName) {
            return (T)this.settings.getOrDefault(type, Collections.EMPTY_MAP).get(propertyName);
        }

        @Override
        public <T> T get(String propertyName) {
            for (Map<String, Object> map : this.settings.values()) {
                Object val = map.get(propertyName);
                if (val == null) continue;
                return (T)val;
            }
            return null;
        }

        @Override
        public void fireChanged() {
            ((SettingsStore)this.store).fireChanged((SettingsBean)this);
        }

        public int hashCode() {
            return 97 * this.settings.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SettingsBean other = (SettingsBean)obj;
            return this.settings.equals(other.settings);
        }
    }

    private static final class PrefMapper<T> {
        private final Function<Preferences, Function<String, Consumer<T>>> setter;
        private final Function<Preferences, Function<String, Function<T, T>>> getter;

        public PrefMapper(Function<Preferences, Function<String, Consumer<T>>> setter, Function<Preferences, Function<String, Function<T, T>>> getter) {
            this.setter = setter;
            this.getter = getter;
        }

        public void save(Preferences p, String name, T val) {
            this.setter.apply(p).apply(name).accept(val);
        }

        public void save(Preferences p, Map.Entry<String, T> entry) {
            this.save(p, entry.getKey(), entry.getValue());
        }

        public T load(Preferences p, String name, T val) {
            return this.getter.apply(p).apply(name).apply(val);
        }

        public T load(Preferences p, Map.Entry<String, T> entry) {
            return this.load(p, entry.getKey(), entry.getValue());
        }
    }
}

