/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter.profiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.FilterRegistry;
import org.graalvm.visualizer.filter.profiles.impl.BuiltinGraphMatcher;
import org.graalvm.visualizer.filter.profiles.mgmt.SimpleProfileSelector;
import org.graalvm.visualizer.filter.profiles.spi.ProfileGraphMatcher;
import org.openide.util.Lookup;

public class Profiles {
    private Profiles() {
    }

    public static List<FilterProfile> selectProfiles(Collection<FilterProfile> profiles, InputGraph in, GraphContainer parent, Lookup context) {
        Collection matchers = Lookup.getDefault().lookupAll(ProfileGraphMatcher.class);
        HashSet<FilterProfile> notAssigned = new HashSet<FilterProfile>(profiles);
        final HashMap<FilterProfile, Integer> priorities = new HashMap<FilterProfile, Integer>();
        for (ProfileGraphMatcher m : matchers) {
            for (FilterProfile fp : new ArrayList<FilterProfile>(notAssigned)) {
                int priority = m.matchesInputGraph(fp, in, parent, context);
                if (priority == -1) continue;
                notAssigned.remove(fp);
                priorities.put(fp, priority);
            }
        }
        priorities.putIfAbsent(((FilterRegistry)Lookup.getDefault().lookup(FilterRegistry.class)).getDefaultProfile(), Integer.MIN_VALUE);
        ArrayList<FilterProfile> result = new ArrayList<FilterProfile>(priorities.keySet());
        Collections.sort(result, new Comparator<FilterProfile>(){

            @Override
            public int compare(FilterProfile o1, FilterProfile o2) {
                return (Integer)priorities.get(o1) - (Integer)priorities.get(o2);
            }
        });
        return result;
    }

    public static List<FilterProfile> allProfiles() {
        return Lookup.getDefault().lookupAll(FilterRegistry.class).stream().flatMap(r -> r.getProfiles().stream()).collect(Collectors.toList());
    }

    public static void saveSelector(SimpleProfileSelector selector) throws IOException {
        BuiltinGraphMatcher.saveSelectorImpl(selector);
    }

    public static boolean canSimpleEdit(FilterProfile p) {
        SimpleProfileSelector ss = Profiles.simpleSelector(p);
        return ss != null && ss.isValid();
    }

    public static SimpleProfileSelector simpleSelector(FilterProfile p) {
        return BuiltinGraphMatcher.simpleSelectorImpl(p);
    }
}

