/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter.profiles.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import org.graalvm.visualizer.filter.CustomFilter;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.filter.Filters;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.impl.Bundle;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileStorage;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class FilterProfileAdapter
implements FilterProfile {
    static RequestProcessor REFRESH_RP = new RequestProcessor(FilterProfileAdapter.class);
    public static final String ENABLED_ID = "enabled";
    public static final String DISPLAY_NAME = "name";
    private final FileObject profileFolder;
    private final ProfileFilterChain sequence = new ProfileFilterChain();
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private final ProfileFilterChain profileFilters = new ProfileFilterChain();
    private final ProfileService root;
    private final ProfileStorage storage;
    private boolean initialized;
    private final L pcl = new L();
    private final FileChangeListener weakFL;
    private final DataFolder dFolder;
    private final ChangedL chainsListener = new ChangedL();
    private final Map<FileObject, FileChangeListener> weakRL = new WeakHashMap<FileObject, FileChangeListener>();
    private RequestProcessor.Task refreshTask;

    public FilterProfileAdapter(FileObject filterFolder, ProfileService root, ProfileStorage storage) {
        this.root = root;
        this.storage = storage;
        this.profileFolder = filterFolder;
        this.dFolder = DataFolder.findFolder((FileObject)filterFolder);
        assert (this.dFolder != null);
        this.weakFL = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.pcl, (Object)this.profileFolder);
        this.profileFilters.getChangedEvent().addListener((Object)this.chainsListener);
        this.sequence.getChangedEvent().addListener((Object)this.chainsListener);
        this.profileFolder.addFileChangeListener(this.weakFL);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(l);
    }

    @Override
    public String getName() {
        return this.dFolder.getNodeDelegate().getDisplayName();
    }

    @Override
    public void setName(String profileName) throws IOException {
        String oN = this.getName();
        this.dFolder.rename(profileName);
        this.propSupport.firePropertyChange(DISPLAY_NAME, oN, profileName);
    }

    void setDisplayName(String profileName) {
        String oN = this.getName();
        this.dFolder.getNodeDelegate().setDisplayName(profileName);
        this.propSupport.firePropertyChange(DISPLAY_NAME, oN, profileName);
    }

    @Override
    public FilterSequence getAllFilters() {
        this.init();
        return this.profileFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        FilterProfileAdapter filterProfileAdapter = this;
        synchronized (filterProfileAdapter) {
            if (this.initialized) {
                return;
            }
        }
        this.refresh();
        filterProfileAdapter = this;
        synchronized (filterProfileAdapter) {
            this.initialized = true;
        }
    }

    @Override
    public FilterSequence getSelectedFilters() {
        this.init();
        return this.sequence;
    }

    private synchronized void postRefresh() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        this.refreshTask = REFRESH_RP.post(this::refresh, 100);
    }

    private FileObject getDefaultProfileFolder() {
        return this.storage.getProfileFolder(this.root.getDefaultProfile());
    }

    @Override
    public Filter addSharedFilter(Filter f) throws IOException {
        FileObject fo = (FileObject)f.getLookup().lookup(FileObject.class);
        if (fo == null || fo.getParent() != this.getDefaultProfileFolder()) {
            throw new IOException("Invalid shared filter");
        }
        if (fo.getParent() == this.getProfileFolder()) {
            return f;
        }
        FileObject ff = DataShadow.create((DataFolder)DataFolder.findFolder((FileObject)this.getProfileFolder()), (String)fo.getName(), (DataObject)DataObject.find((FileObject)fo)).getPrimaryFile();
        Filter result = this.createFilter(ff);
        this.refresh();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        List oldAllFilters;
        ArrayList<Filter> newFilters = new ArrayList<Filter>();
        ArrayList<Filter> newAllFilters = new ArrayList<Filter>();
        HashSet<Filter> oldFilterSet = new HashSet<Filter>();
        HashSet oldAllFilterSet = new HashSet();
        HashSet<FileObject> current = new HashSet<FileObject>();
        FilterProfileAdapter filterProfileAdapter = this;
        synchronized (filterProfileAdapter) {
            Map<FileObject, FileChangeListener> fLs = this.weakRL;
            this.chainsListener.changed = false;
            List children = FileUtil.getOrder(Arrays.asList(this.profileFolder.getChildren()), (boolean)false);
            for (FileObject f : children) {
                Filter filter = this.createFilter(f);
                if (filter == null) continue;
                if (Boolean.TRUE.equals(f.getAttribute(ENABLED_ID))) {
                    newFilters.add(filter);
                }
                newAllFilters.add(filter);
                current.add(f);
            }
            oldAllFilters = this.profileFilters.getFilters();
            ArrayList<FileObject> toUnregister = new ArrayList<FileObject>(fLs.keySet());
            toUnregister.removeAll(current);
            for (FileObject f : toUnregister) {
                f.removeFileChangeListener(fLs.remove(f));
            }
            current.removeAll(fLs.keySet());
        }
        oldFilterSet.addAll(newFilters);
        oldAllFilterSet.addAll(oldAllFilters);
        this.profileFilters.replaceFilters(newAllFilters);
        this.sequence.replaceFilters(newFilters);
        if (this.chainsListener.changed) {
            boolean filtersChanged = false;
            if (!oldFilterSet.containsAll(newFilters)) {
                filtersChanged = true;
            } else {
                oldFilterSet.removeAll(newFilters);
                filtersChanged = oldFilterSet.isEmpty();
            }
            boolean allFiltersChanged = false;
            if (!oldAllFilterSet.containsAll(newAllFilters)) {
                allFiltersChanged = true;
            } else {
                oldAllFilterSet.removeAll(newAllFilters);
                allFiltersChanged = oldAllFilterSet.isEmpty();
            }
            if (allFiltersChanged) {
                this.propSupport.firePropertyChange("profileFilters", oldAllFilters, newAllFilters);
            } else {
                this.propSupport.firePropertyChange("filterOrder", null, null);
            }
            if (filtersChanged) {
                this.propSupport.firePropertyChange("enabledFilters", null, null);
            }
        }
    }

    protected Filter createFilter(FileObject fo) {
        return this.storage.createFilter(fo, this);
    }

    @Override
    public void moveDown(Filter f) throws IOException {
        this.changeOrder(f, true);
    }

    private void changeOrder(Filter f, boolean down) throws IOException {
        FileObject storage = (FileObject)f.getLookup().lookup(FileObject.class);
        if (storage == null) {
            throw new IOException(Bundle.FILTER_ErrorNoStorage());
        }
        FileObject profile = storage.getParent();
        if (profile != this.profileFolder) {
            throw new IOException(Bundle.FILTER_ErrorNoStorage());
        }
        ArrayList<Filter> filters = new ArrayList<Filter>(this.profileFilters.getFilters());
        int index = filters.indexOf(f);
        if (index == -1) {
            throw new IOException(Bundle.FILTER_NotFound(f.getName()));
        }
        int nIndex = index + (down ? 1 : -1);
        if (nIndex < 0 || nIndex >= filters.size()) {
            return;
        }
        filters.remove(f);
        filters.add(nIndex, f);
        this.setFilterOrder(filters);
    }

    void setFilterOrder(List<Filter> filters) throws IOException {
        ArrayList<FileObject> filterOrder = new ArrayList<FileObject>(filters.size());
        for (Filter x : filters) {
            FileObject s = (FileObject)x.getLookup().lookup(FileObject.class);
            if (s == null) continue;
            filterOrder.add(s);
        }
        ArrayList<FileObject> children = new ArrayList<FileObject>(FileUtil.getOrder(Arrays.asList(this.profileFolder.getChildren()), (boolean)false));
        children.removeAll(filterOrder);
        children.addAll(filterOrder);
        FileUtil.setOrder(children);
        this.propSupport.firePropertyChange("filterOrder", null, null);
    }

    @Override
    public void setEnabled(Filter f, boolean state) throws IOException {
        FileObject storage = (FileObject)f.getLookup().lookup(FileObject.class);
        if (storage == null || storage.getParent() != this.profileFolder) {
            throw new IOException(Bundle.FILTER_ErrorNoStorage());
        }
        boolean nowState = this.getSelectedFilters().getFilters().contains(f);
        if (nowState != state) {
            storage.setAttribute(ENABLED_ID, (Object)state);
            this.postRefresh();
        }
    }

    @Override
    public void moveUp(Filter f) throws IOException {
        this.changeOrder(f, false);
    }

    @Override
    public List<Filter> getProfileFilters() {
        this.init();
        return this.profileFilters.getFilters();
    }

    FileObject getProfileFolder() {
        return this.profileFolder;
    }

    void createRootFilter(Filter f) throws IOException {
        FileObject storage = (FileObject)f.getLookup().lookup(FileObject.class);
        if (storage != null) {
            FileObject source = DataShadow.findOriginal((FileObject)storage);
            if (source == null) {
                source = storage;
            }
            if (source.getParent() == this.getDefaultProfileFolder() || source.getParent() == this.getProfileFolder()) {
                throw new IOException(Bundle.ERROR_FilterAlreadyPresent());
            }
            DataObject orig = DataObject.find((FileObject)source);
            this.getDefaultProfileFolder().getFileSystem().runAtomicAction(() -> {
                DataObject o = orig.copy(DataFolder.findFolder((FileObject)this.getDefaultProfileFolder()));
                o.rename(f.getName());
            });
            return;
        }
        CustomFilter cf = (CustomFilter)f.getLookup().lookup(CustomFilter.class);
        if (cf == null) {
            throw new IOException(Bundle.ERROR_UnknownExtensionForMime(f.getClass().getName()));
        }
        List exts = FileUtil.getMIMETypeExtensions((String)cf.getMimeType());
        if (exts.isEmpty()) {
            throw new IOException(Bundle.ERROR_UnknownExtensionForMime(cf.getMimeType()));
        }
        FileObject folder = this.getDefaultProfileFolder();
        folder.getFileSystem().runAtomicAction(() -> {
            try (OutputStream out = folder.createAndOpen(cf.getName() + "." + (String)exts.get(0));
                 ByteArrayInputStream in = new ByteArrayInputStream(cf.getCode().getBytes());){
                FileUtil.copy((InputStream)in, (OutputStream)out);
            }
        });
    }

    void addProfileFilter(Filter filter) {
        FileObject original;
        FileObject storage = (FileObject)filter.getLookup().lookup(FileObject.class);
        if (storage == null) {
            throw new IllegalArgumentException(Bundle.FILTER_ErrorNoStorage());
        }
        try {
            original = DataShadow.findOriginal((FileObject)storage);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (original == null) {
            original = storage;
        }
        if (original.getParent() != this.getDefaultProfileFolder()) {
            throw new IllegalArgumentException(Bundle.FILTER_ErrorNoStorage());
        }
        try {
            DataShadow.create((DataFolder)this.dFolder, (String)filter.getName(), (DataObject)DataObject.find((FileObject)original));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(Bundle.PROFILE_CannotAddFilter(ex.toString()), ex);
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.profileFolder);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterProfileAdapter other = (FilterProfileAdapter)obj;
        return Objects.equals(this.profileFolder, other.profileFolder);
    }

    public String toString() {
        return "Profile[" + this.profileFolder.getName() + "]";
    }

    private void handleFileRenamed(FileObject f, String newName) {
        try {
            CustomFilter cf;
            List<Filter> filters = this.getProfileFilters();
            this.setFilterOrder(filters);
            Filter filter = this.storage.getFilter(f);
            if (filter != null && (cf = (CustomFilter)Filters.lookupFilter((Filter)filter, CustomFilter.class)) != null) {
                cf.setName(newName);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class ProfileFilterChain
    extends FilterChain {
        private ProfileFilterChain() {
        }

        public void replaceFilters(List<Filter> newFilters) {
            super.replaceFilters(newFilters);
        }
    }

    private class L
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private L() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FilterProfileAdapter.this.postRefresh();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            super.fileAttributeChanged(fe);
            String an = fe.getName();
            if (an == null || "displayName".equals(an)) {
                if (fe.getFile().isFolder()) {
                    FilterProfileAdapter.this.propSupport.firePropertyChange(FilterProfileAdapter.DISPLAY_NAME, null, FilterProfileAdapter.this.getName());
                    return;
                }
                Object nv = fe.getNewValue();
                if (nv == null) {
                    nv = fe.getFile().getAttribute("displayName");
                }
                if (nv != null) {
                    FilterProfileAdapter.this.handleFileRenamed(fe.getFile(), nv.toString());
                }
            }
            if ((an == null || "position".equals(an)) && fe.getFile().isData()) {
                FilterProfileAdapter.this.postRefresh();
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (fe.getFile().isData()) {
                super.fileRenamed(fe);
                FilterProfileAdapter.this.handleFileRenamed(fe.getFile(), fe.getFile().getName());
            }
        }

        public void fileDeleted(FileEvent fe) {
            super.fileDeleted(fe);
            if (fe.getFile().isData()) {
                FilterProfileAdapter.this.postRefresh();
            }
        }

        public void fileDataCreated(FileEvent fe) {
            super.fileDataCreated(fe);
            FilterProfileAdapter.this.postRefresh();
        }
    }

    static class ChangedL
    implements ChangedListener<FilterChain> {
        volatile boolean changed;

        ChangedL() {
        }

        public void changed(FilterChain source) {
            this.changed = true;
        }
    }
}

