/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter.profiles.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import org.graalvm.visualizer.filter.CustomFilter;
import org.graalvm.visualizer.filter.Filter;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Exceptions;

public class LegacyFilterSynchronizer
extends FileChangeAdapter
implements ChangedListener<Filter> {
    private FileObject fileObject;
    private final CustomFilter filter;
    private final AtomicBoolean sync = new AtomicBoolean();

    public LegacyFilterSynchronizer(FileObject fo, CustomFilter cf) {
        this.fileObject = fo;
        this.filter = cf;
    }

    private <T extends FileEvent> void syncOnce(Runnable f) {
        if (!this.sync.compareAndSet(false, true)) {
            return;
        }
        try {
            f.run();
        }
        finally {
            this.sync.set(false);
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.syncOnce(() -> {
            if (fe.getFile().getParent() != this.fileObject.getParent()) {
                return;
            }
            this.filter.setName(fe.getName());
        });
    }

    public void fileChanged(FileEvent fe) {
        this.syncOnce(() -> {
            try {
                if (!fe.getFile().isValid()) {
                    return;
                }
                this.filter.setCode(fe.getFile().asText());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    public void changed(Filter source) {
        this.syncOnce(() -> {
            block20: {
                try {
                    FileLock lock;
                    if (!this.fileObject.getName().equals(this.filter.getName())) {
                        lock = this.fileObject.lock();
                        FileObject newFileObject = this.fileObject.move(lock, this.fileObject.getParent(), this.filter.getName(), "");
                        lock.releaseLock();
                        this.fileObject = newFileObject;
                    }
                    if (this.fileObject.asText().equals(this.filter.getCode())) break block20;
                    lock = this.fileObject.lock();
                    try (OutputStream os = this.fileObject.getOutputStream(lock);
                         OutputStreamWriter w = new OutputStreamWriter(os);){
                        String s = this.filter.getCode();
                        w.write(s);
                    }
                    finally {
                        if (lock != null) {
                            lock.close();
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }
}

