/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import jdk.jshell.execution.JdiExecutionControl;
import jdk.jshell.execution.JdiInitiator;
import jdk.jshell.execution.Util;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionEnv;

public class JdiDefaultExecutionControl
extends JdiExecutionControl {
    private VirtualMachine vm;
    private Process process;
    private final String remoteAgent;
    private final Object STOP_LOCK = new Object();
    private boolean userCodeRunning = false;

    static ExecutionControl create(ExecutionEnv env, String remoteAgent, boolean isLaunch, String host, int timeout) throws IOException {
        try (ServerSocket listener = new ServerSocket(0, 1, InetAddress.getLoopbackAddress());){
            listener.setSoTimeout(timeout);
            int port = listener.getLocalPort();
            JdiInitiator jdii = new JdiInitiator(port, env.extraRemoteVMOptions(), remoteAgent, isLaunch, host, timeout, Collections.emptyMap());
            VirtualMachine vm = jdii.vm();
            Process process = jdii.process();
            ArrayList deathListeners = new ArrayList();
            Util.detectJdiExitEvent(vm, s -> {
                for (Consumer h : deathListeners) {
                    h.accept(s);
                }
            });
            Socket socket = listener.accept();
            OutputStream out = socket.getOutputStream();
            HashMap<String, OutputStream> outputs = new HashMap<String, OutputStream>();
            outputs.put("out", env.userOut());
            outputs.put("err", env.userErr());
            HashMap<String, InputStream> input = new HashMap<String, InputStream>();
            input.put("in", env.userIn());
            ExecutionControl executionControl = Util.remoteInputOutput(socket.getInputStream(), out, outputs, input, (objIn, objOut) -> new JdiDefaultExecutionControl(env, (ObjectOutput)objOut, (ObjectInput)objIn, vm, process, remoteAgent, deathListeners));
            return executionControl;
        }
    }

    private JdiDefaultExecutionControl(ExecutionEnv env, ObjectOutput cmdout, ObjectInput cmdin, VirtualMachine vm, Process process, String remoteAgent, List<Consumer<String>> deathListeners) {
        super(cmdout, cmdin);
        this.vm = vm;
        this.process = process;
        this.remoteAgent = remoteAgent;
        deathListeners.add(s -> env.closeDown());
        deathListeners.add(s -> this.disposeVM());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String invoke(String classname, String methodname) throws ExecutionControl.RunException, ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        String res;
        Object object = this.STOP_LOCK;
        synchronized (object) {
            this.userCodeRunning = true;
        }
        try {
            res = super.invoke(classname, methodname);
        }
        finally {
            object = this.STOP_LOCK;
            synchronized (object) {
                this.userCodeRunning = false;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        Object object = this.STOP_LOCK;
        synchronized (object) {
            block12: {
                if (!this.userCodeRunning) {
                    return;
                }
                this.vm().suspend();
                try {
                    for (ThreadReference thread : this.vm().allThreads()) {
                        for (StackFrame frame : thread.frames()) {
                            if (!this.remoteAgent.equals(frame.location().declaringType().name()) || !"invoke".equals(frame.location().method().name()) && !"varValue".equals(frame.location().method().name())) continue;
                            ObjectReference thiz = frame.thisObject();
                            Field inClientCode = thiz.referenceType().fieldByName("inClientCode");
                            Field expectingStop = thiz.referenceType().fieldByName("expectingStop");
                            Field stopException = thiz.referenceType().fieldByName("stopException");
                            if (((BooleanValue)thiz.getValue(inClientCode)).value()) {
                                thiz.setValue(expectingStop, this.vm().mirrorOf(true));
                                ObjectReference stopInstance = (ObjectReference)thiz.getValue(stopException);
                                this.vm().resume();
                                JdiDefaultExecutionControl.debug("Attempting to stop the client code...\n", new Object[0]);
                                thread.stop(stopInstance);
                                thiz.setValue(expectingStop, this.vm().mirrorOf(false));
                            }
                            break block12;
                        }
                    }
                }
                catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException ex) {
                    throw new ExecutionControl.InternalException("Exception on remote stop: " + ex);
                }
                finally {
                    this.vm().resume();
                }
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.disposeVM();
    }

    private synchronized void disposeVM() {
        try {
            if (this.vm != null) {
                this.vm.dispose();
                this.vm = null;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (Throwable ex) {
            JdiDefaultExecutionControl.debug(ex, "disposeVM");
        }
        finally {
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
        }
    }

    @Override
    protected synchronized VirtualMachine vm() throws ExecutionControl.EngineTerminationException {
        if (this.vm == null) {
            throw new ExecutionControl.EngineTerminationException("VM closed");
        }
        return this.vm;
    }

    private static void debug(String format, Object ... args) {
    }

    private static void debug(Throwable ex, String where) {
    }
}

