/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.control.AbstractIfNode;
import com.oracle.truffle.js.nodes.control.GeneratorIfNodeGen;
import com.oracle.truffle.js.nodes.control.IfNodeGen;
import com.oracle.truffle.js.nodes.unary.JSNotNode;

public abstract class IfNode
extends AbstractIfNode {
    @Node.Child
    @Executed
    protected JavaScriptNode condition;
    @Node.Child
    protected JavaScriptNode thenPart;
    @Node.Child
    protected JavaScriptNode elsePart;

    public static IfNode create(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart) {
        if (condition instanceof JSNotNode) {
            JavaScriptNode operand = ((JSNotNode)condition).getOperand();
            IfNode.transferSourceSectionAddExpressionTag(condition, operand);
            return IfNodeGen.create(operand, elsePart, thenPart);
        }
        return IfNodeGen.create(condition, thenPart, elsePart);
    }

    protected IfNode(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart) {
        this.condition = condition;
        this.thenPart = thenPart;
        this.elsePart = elsePart;
    }

    @Specialization
    protected Object doBoolean(VirtualFrame frame, boolean conditionResult, @Cached @Cached.Shared(value="profile") InlinedCountingConditionProfile conditionProfile) {
        if (conditionProfile.profile((Node)this, conditionResult)) {
            if (this.thenPart != null) {
                return this.thenPart.execute(frame);
            }
            return EMPTY;
        }
        if (this.elsePart != null) {
            return this.elsePart.execute(frame);
        }
        return EMPTY;
    }

    @Specialization(replaces={"doBoolean"})
    protected Object doObject(VirtualFrame frame, Object conditionResult, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached @Cached.Shared(value="profile") InlinedCountingConditionProfile conditionProfile) {
        boolean booleanResult = toBooleanNode.executeBoolean(this, conditionResult);
        return this.doBoolean(frame, booleanResult, conditionProfile);
    }

    @Override
    public JavaScriptNode getCondition() {
        return this.condition;
    }

    @Override
    public JavaScriptNode getThenPart() {
        return this.thenPart;
    }

    @Override
    public JavaScriptNode getElsePart() {
        return this.elsePart;
    }

    @Override
    protected AbstractIfNode copyWith(JavaScriptNode newCondition, JavaScriptNode newThenPart, JavaScriptNode newElsePart) {
        return IfNode.create(newCondition, newThenPart, newElsePart);
    }

    @Override
    public JavaScriptNode asResumableNode(int stateSlot) {
        return GeneratorIfNodeGen.create(this.condition, this.thenPart, this.elsePart, stateSlot);
    }
}

