/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.bytecodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.bytecodes.MethodNode;
import org.graalvm.visualizer.data.SuppressFBWarnings;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class BytecodeViewTopComponent
extends TopComponent
implements ExplorerManager.Provider,
ChangeListener {
    private static BytecodeViewTopComponent instance;
    private static final String PREFERRED_ID = "BytecodeViewTopComponent";
    private static final InputGraph EMPTY;
    private final ExplorerManager manager;
    private final BeanTreeView treeView;
    private final MethodNode rootNode;
    private final GraphViewer viewer = (GraphViewer)Lookup.getDefault().lookup(GraphViewer.class);
    private final ChangeListener wListener = WeakListeners.change((ChangeListener)this, (Object)this.viewer);
    private Reference<InputGraph> lastActive = new WeakReference<Object>(null);

    private BytecodeViewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(BytecodeViewTopComponent.class, (String)"CTL_BytecodeViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(BytecodeViewTopComponent.class, (String)"HINT_BytecodeViewTopComponent"));
        this.manager = new ExplorerManager();
        this.rootNode = new MethodNode(null, null, "");
        this.manager.setRootContext((Node)this.rootNode);
        this.setLayout(new BorderLayout());
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.add("Center", (Component)this.treeView);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap()));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized BytecodeViewTopComponent getDefault() {
        if (instance == null) {
            instance = new BytecodeViewTopComponent();
        }
        return instance;
    }

    public static synchronized BytecodeViewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find BytecodeView component. It will not be located properly in the window system.");
            return BytecodeViewTopComponent.getDefault();
        }
        if (win instanceof BytecodeViewTopComponent) {
            return (BytecodeViewTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'BytecodeViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return BytecodeViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Force init of the graph system")
    public void componentOpened() {
        Lookup.Template tpl = new Lookup.Template(InputGraphProvider.class);
        this.viewer.addChangeListener(this.wListener);
    }

    public void componentClosed() {
        this.viewer.removeChangeListener(this.wListener);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void requestActive() {
        super.requestActive();
        this.treeView.requestFocus();
    }

    public boolean requestFocus(boolean temporary) {
        this.treeView.requestFocus();
        return super.requestFocus(temporary);
    }

    protected boolean requestFocusInWindow(boolean temporary) {
        this.treeView.requestFocus();
        return super.requestFocusInWindow(temporary);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        final InputGraphProvider p = this.viewer.getActiveViewer();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InputGraph g = p != null ? p.getGraph() : EMPTY;
                InputGraph lg = BytecodeViewTopComponent.this.lastActive.get();
                if (lg != g) {
                    Group grp = g.getGroup();
                    BytecodeViewTopComponent.this.rootNode.update(g, grp == null ? null : grp.getMethod());
                    BytecodeViewTopComponent.this.lastActive = new WeakReference<InputGraph>(g);
                }
            }
        });
    }

    static {
        EMPTY = new InputGraph(null, -1, "", new Object[0]);
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return BytecodeViewTopComponent.getDefault();
        }
    }
}

