/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.ConstantPool;
import jdk.graal.compiler.graphio.parsing.DocumentFactory;
import jdk.graal.compiler.graphio.parsing.NameTranslator;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.TemplateParser;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphClassifier;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputEdge;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputMethod;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;

public class ModelBuilder
implements Builder {
    private static final Logger LOG = Logger.getLogger(ModelBuilder.class.getName());
    private final ParseMonitor monitor;
    private final DocumentFactory rootDocumentFactory;
    private GraphDocument rootDocument;
    private ConstantPool pool = new ConstantPool();
    private Builder.ModelControl control;
    private Properties.Entity entity;
    private Folder folder;
    private InputGraph currentGraph;
    private List<EdgeInfo> inputEdges;
    private List<EdgeInfo> successorEdges;
    private List<EdgeInfo> nodeEdges;
    private List<EdgeInfo> blockEdges;
    private InputNode currentNode;
    private String propertyObjectKey;
    private InputBlock currentBlock;
    private Properties newProperties;
    private Properties documentLevelProperties = Properties.newProperties();
    private GraphClassifier classifier = new GraphClassifier();
    private Object documentId;
    private Map<String, byte[]> lastDigests = new LinkedHashMap<String, byte[]>();
    private final Deque<Object> stack = new ArrayDeque<Object>();
    static final Set<String> SYSTEM_PROPERTIES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("hasPredecessor", "name", "class", "id", "idx", "block")));
    private static final String NOT_DATA = "!data.";
    private static final String NO_BLOCK = "noBlock";

    public ModelBuilder(GraphDocument rootDocument, ParseMonitor monitor) {
        this.rootDocument = rootDocument;
        this.monitor = monitor;
        this.folder = rootDocument;
        this.rootDocumentFactory = null;
    }

    public ModelBuilder(DocumentFactory factory, ParseMonitor monitor) {
        this.rootDocument = null;
        this.folder = null;
        this.monitor = monitor;
        this.rootDocumentFactory = factory;
    }

    public void setDocumentId(Object id) {
        this.documentId = id;
    }

    public void setGraphClassifier(GraphClassifier c) {
        this.classifier = c;
    }

    protected GraphClassifier getGraphClassifier() {
        return this.classifier;
    }

    @Override
    public final GraphDocument rootDocument() {
        return this.rootDocument;
    }

    public final Folder folder() {
        return this.folder;
    }

    public final InputGraph graph() {
        return this.currentGraph;
    }

    protected final InputNode node() {
        return this.currentNode;
    }

    private Folder getParent() {
        if (this.currentGraph != null) {
            return this.folder;
        }
        Object o = this.stack.peek();
        return o instanceof Folder ? (Folder)o : null;
    }

    protected void popContext() {
        Object o;
        if (this.currentNode != null) {
            this.currentNode = null;
            this.propertyObjectKey = null;
            this.nodeEdges = null;
        } else if (this.currentGraph != null) {
            this.currentGraph = null;
            this.inputEdges = null;
            this.successorEdges = null;
            this.blockEdges = null;
        }
        if (this.stack.isEmpty()) {
            this.folder = this.rootDocument;
            o = this.folder;
        } else {
            o = this.stack.pop();
            if (o instanceof InputGraph) {
                this.currentGraph = (InputGraph)o;
            } else if (o instanceof InputNode) {
                this.currentNode = (InputNode)o;
                Object[] oo = (Object[])this.stack.pop();
                this.currentGraph = (InputGraph)oo[0];
                this.inputEdges = (List)oo[1];
                this.successorEdges = (List)oo[2];
                this.nodeEdges = (List)oo[3];
            } else if (o instanceof Folder) {
                this.folder = (Folder)o;
                this.lastDigests = (Map)this.stack.pop();
            }
        }
        if (o instanceof Properties.Entity) {
            this.entity = (Properties.Entity)o;
        }
        this.newProperties = null;
    }

    private void pushContext() {
        this.newProperties = null;
        if (this.currentNode != null) {
            this.stack.push(new Object[]{this.currentGraph, this.inputEdges, this.successorEdges, this.nodeEdges});
            this.stack.push(this.currentNode);
            this.currentNode = null;
            this.currentGraph = null;
        } else if (this.currentGraph != null) {
            this.stack.push(this.currentGraph);
            this.currentNode = null;
        } else if (this.folder != null) {
            this.stack.push(this.lastDigests);
            this.stack.push(this.folder);
        }
    }

    @Override
    public void setPropertySize(int size) {
        this.getProperties().reserve(size);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.getProperties().setProperty(key, value);
    }

    protected Properties getProperties() {
        if (this.newProperties != null) {
            return this.newProperties;
        }
        return this.entity.getProperties();
    }

    protected Properties.Entity getEntity() {
        return this.entity;
    }

    @Override
    public NameTranslator prepareNameTranslator() {
        return null;
    }

    @Override
    public void startNestedProperty(String propertyKey) {
        assert (this.propertyObjectKey == null);
        this.propertyObjectKey = propertyKey;
    }

    protected final String getNestedProperty() {
        return this.propertyObjectKey;
    }

    protected final InputGraph pushGraph(InputGraph g) {
        this.pushContext();
        if (this.currentNode != null) {
            this.lastDigests = new LinkedHashMap<String, byte[]>();
        }
        this.currentGraph = g;
        this.entity = g;
        this.inputEdges = new ArrayList<EdgeInfo>();
        this.successorEdges = new ArrayList<EdgeInfo>();
        return g;
    }

    protected void connectModifiedProperties(FolderElement g) {
        Properties props;
        if (!(g instanceof Properties.MutableOwner)) {
            return;
        }
        Properties.MutableOwner mu = (Properties.MutableOwner)((Object)g);
        GraphDocument doc = g.getOwner();
        if (doc != null && (props = doc.getModifiedProperties(g)) != null) {
            mu.updateProperties(props);
        }
    }

    public static String makeGraphName(int dumpId, String format, Object[] args) {
        assert (format != null && args != null);
        if (args.length == 0) {
            return dumpId < 0 ? format : dumpId + ": " + format;
        }
        Object[] tmpArgs = (Object[])args.clone();
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof BinaryReader.Klass)) continue;
            String className = args[i].toString();
            String s = className.substring(className.lastIndexOf(".") + 1);
            int innerClassPos = s.indexOf(36);
            if (innerClassPos > 0) {
                s = s.substring(0, innerClassPos);
            }
            if (s.endsWith("Phase")) {
                s = s.substring(0, s.length() - "Phase".length());
            }
            tmpArgs[i] = s;
        }
        return dumpId < 0 ? String.format(format, tmpArgs) : dumpId + ": " + String.format(format, tmpArgs);
    }

    protected InputGraph createGraph(Properties.Entity parent, int dumpId, String format, Object[] args) {
        return new InputGraph(null, dumpId, format, args);
    }

    protected final InputGraph doCreateGraph(Properties.Entity parent, Object id, int dumpId, String format, Object[] args) {
        InputGraph g = new InputGraph(id, dumpId, format, args);
        this.connectModifiedProperties(g);
        return g;
    }

    @Override
    public void graphContentDigest(byte[] digest) {
        byte[] prevDigest;
        InputGraph g = this.graph();
        if (g == null) {
            return;
        }
        String t = g.getGraphType();
        if (t == null) {
            t = "";
        }
        if (Arrays.equals(prevDigest = this.lastDigests.put(t, digest), digest)) {
            this.markGraphDuplicate();
        }
    }

    @Override
    public void startGraphContents(InputGraph g) {
        if (g == null) {
            return;
        }
        String graphType = null;
        GraphClassifier cl = this.getGraphClassifier();
        if (cl != null) {
            graphType = cl.classifyGraphType(g.getProperties());
        }
        g.setGraphType(graphType);
    }

    @Override
    public InputGraph startGraph(int dumpId, String format, Object[] args) {
        InputGraph g;
        InputNode n;
        if (this.monitor != null) {
            this.monitor.updateProgress();
        }
        if ((n = this.currentNode) != null) {
            g = this.createGraph(n, n.getId(), this.propertyObjectKey, new Object[0]);
            this.propertyObjectKey = null;
        } else {
            g = this.createGraph((Group)this.folder, dumpId, format, args);
        }
        return this.pushGraph(g);
    }

    @Override
    public InputGraph endGraph() {
        InputGraph g = this.currentGraph;
        for (InputNode node : g.getNodes()) {
            node.internProperties();
        }
        this.popContext();
        if (this.currentNode != null) {
            new Group(null, new FakeGID(this.currentGraph.getID(), g.getID())).addElement(g);
            this.currentNode.addSubgraph(g);
        } else {
            this.registerToParent(this.folder, g);
        }
        return g;
    }

    @Override
    public void start() {
        if (this.monitor != null) {
            this.monitor.setState("Starting parsing");
        }
    }

    @Override
    public void end() {
        if (this.monitor != null) {
            this.monitor.setState("Finished parsing");
        }
    }

    protected final Group pushGroup(Group group, boolean startNew) {
        this.pushContext();
        this.entity = group;
        this.folder = group;
        if (startNew) {
            this.lastDigests = new LinkedHashMap<String, byte[]>();
        }
        return group;
    }

    protected Group createGroup(Folder parent) {
        return this.doCreateGroup(parent, null);
    }

    protected Group doCreateGroup(Folder parent, Object id) {
        Group g = new Group(parent, id);
        this.connectModifiedProperties(g);
        return g;
    }

    @Override
    public Group startGroup() {
        Group group = this.createGroup(this.folder);
        return this.pushGroup(group, true);
    }

    protected void rootDocumentResolved(GraphDocument doc) {
        this.rootDocument = doc;
    }

    @Override
    public void startDocumentHeader() {
        Folder f = this.getParent();
        if (f != null) {
            if (!(f instanceof GraphDocument)) {
                throw new IllegalStateException("Document header not at root level.");
            }
            this.newProperties = ((GraphDocument)f).getProperties();
        } else {
            this.newProperties = this.rootDocument == null ? Properties.newProperties() : this.rootDocument.getProperties();
        }
    }

    @Override
    public void endDocumentHeader() {
        if (this.newProperties == null) {
            throw new IllegalStateException("Unexpected end document header");
        }
        this.documentLevelProperties = this.newProperties;
        this.newProperties = null;
    }

    private GraphDocument resolveDocument(Properties props, Group g) {
        if (this.rootDocument != null) {
            return this.rootDocument;
        }
        this.rootDocument = this.rootDocumentFactory.documentFor(this.documentId, props, g);
        if (this.rootDocument == null) {
            throw new IllegalStateException("Could not find a parent for group " + this.folder);
        }
        this.rootDocumentResolved(this.rootDocument);
        return this.rootDocument;
    }

    @Override
    public void startGroupContent() {
        assert (this.folder instanceof Group);
        Group g = (Group)this.folder;
        Folder parent = this.getParent();
        if (parent == null) {
            parent = this.resolveDocument(this.documentLevelProperties, g);
            g.setParent(parent);
        }
        this.registerToParent(parent, this.folder);
    }

    @Override
    public void endGroup() {
        this.popContext();
    }

    protected final int level() {
        return this.stack.size();
    }

    @Override
    public void markGraphDuplicate() {
        this.getProperties().setProperty("_isDuplicate", "true");
    }

    protected void registerToParent(Folder parent, FolderElement item) {
        parent.addElement(item);
    }

    protected final void pushNode(InputNode node) {
        this.pushContext();
        this.currentNode = node;
        this.entity = this.currentNode;
        this.nodeEdges = new ArrayList<EdgeInfo>();
    }

    protected InputNode createNode(int id, Builder.NodeClass nodeClass) {
        return new InputNode(id, nodeClass);
    }

    @Override
    public void startNode(int nodeId, boolean hasPredecessors, Builder.NodeClass nodeClass) {
        assert (this.currentGraph != null);
        InputNode node = this.createNode(nodeId, nodeClass);
        node.getProperties().setProperty("idx", Integer.toString(nodeId));
        if (hasPredecessors) {
            node.getProperties().setProperty("hasPredecessor", "true");
        }
        this.pushNode(node);
        this.registerToParent(this.currentGraph, node);
    }

    protected void registerToParent(InputGraph g, InputNode n) {
        g.addNode(n);
    }

    @Override
    public void endNode(int nodeId) {
        this.popContext();
    }

    private static boolean isSystemProperty(String key) {
        return switch (key) {
            case "hasPredecessor", "name", "class", "id", "idx", "block" -> true;
            default -> false;
        };
    }

    @Override
    public void setGroupName(String name, String shortName) {
        assert (this.folder instanceof Group);
        this.setProperty("name", name);
        this.reportState(name);
    }

    protected final void reportState(String name) {
        if (this.monitor != null) {
            this.monitor.setState(name);
        }
    }

    protected final void reportProgress() {
        if (this.monitor != null) {
            this.monitor.updateProgress();
        }
    }

    @Override
    public void setNodeName(Builder.NodeClass nodeClass) {
        assert (this.currentNode != null);
        this.getProperties().setProperty("name", this.createName(nodeClass, this.nodeEdges));
        this.getProperties().setProperty("class", nodeClass.className);
        switch (nodeClass.className) {
            case "BeginNode": {
                this.getProperties().setProperty("shortName", "B");
                break;
            }
            case "EndNode": {
                this.getProperties().setProperty("shortName", "E");
            }
        }
    }

    private String createName(Builder.NodeClass nodeClass, List<EdgeInfo> edges) {
        if (nodeClass.nameTemplate.isEmpty()) {
            return nodeClass.toShortString();
        }
        StringBuilder sb = new StringBuilder(nodeClass.nameTemplate.length());
        Properties p = this.getProperties();
        List<TemplateParser.TemplatePart> templateParts = nodeClass.getTemplateParts();
        block17: for (TemplateParser.TemplatePart template : templateParts) {
            String type;
            if (!template.isReplacement) {
                sb.append(template.value);
                continue;
            }
            String name = template.name;
            switch (type = template.type) {
                case "i": {
                    boolean first = true;
                    for (EdgeInfo edge : edges) {
                        if (!edge.label.startsWith(name) || name.length() != edge.label.length() && edge.label.charAt(name.length()) != '[') continue;
                        if (!first) {
                            sb.append(", ");
                        }
                        first = false;
                        sb.append(edge.from);
                    }
                    continue block17;
                }
                case "p": {
                    String result;
                    Object prop = p.get(name);
                    String length = template.length;
                    if (prop == null) {
                        result = "?";
                    } else if (length != null && prop instanceof Builder.LengthToString) {
                        Builder.LengthToString lengthProp = (Builder.LengthToString)prop;
                        switch (length) {
                            case "s": {
                                result = lengthProp.toString(Builder.Length.S);
                                break;
                            }
                            case "m": {
                                result = lengthProp.toString(Builder.Length.M);
                                break;
                            }
                            default: {
                                result = lengthProp.toString(Builder.Length.L);
                                break;
                            }
                        }
                    } else {
                        result = prop.toString();
                    }
                    sb.append(result);
                    break;
                }
                default: {
                    sb.append("#?#");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void setNodeProperty(String key, Object value) {
        assert (this.currentNode != null);
        Object k = key;
        if (!(value instanceof InputGraph)) {
            if (ModelBuilder.isSystemProperty(key)) {
                k = NOT_DATA + (String)k;
            }
            this.setProperty((String)k, value);
        }
    }

    protected static String inputEdgeType(Builder.Port p) {
        BinaryReader.EnumValue type = ((Builder.TypedPort)p).type;
        return type == null ? null : type.toString(Builder.Length.S);
    }

    @Override
    public void inputEdge(Builder.Port p, int from, int to, char num, int index) {
        assert (this.currentNode != null);
        if (from < 0) {
            return;
        }
        EdgeInfo ei = new EdgeInfo(from, to, num, index, p.name, ModelBuilder.inputEdgeType(p), true);
        this.inputEdges.add(ei);
        this.nodeEdges.add(ei);
    }

    @Override
    public void successorEdge(Builder.Port p, int from, int to, char num, int index) {
        assert (this.currentNode != null);
        if (from < 0) {
            return;
        }
        EdgeInfo ei = new EdgeInfo(to, from, num, index, p.name, "Successor", false);
        this.successorEdges.add(ei);
        this.nodeEdges.add(ei);
    }

    protected InputEdge immutableEdge(char fromIndex, char toIndex, int from, int to, int listIndex, String label, String type) {
        return InputEdge.createImmutable(fromIndex, toIndex, from, to, listIndex, label, type);
    }

    @Override
    public void makeGraphEdges() {
        char toIndex;
        char fromIndex;
        assert (this.currentGraph != null);
        InputGraph graph = this.currentGraph;
        assert (this.inputEdges != null && this.successorEdges != null || graph.getNodes().isEmpty());
        LinkedHashSet<InputNode> nodesWithSuccessor = new LinkedHashSet<InputNode>();
        for (EdgeInfo e : this.successorEdges) {
            assert (!e.input);
            fromIndex = e.num;
            nodesWithSuccessor.add(graph.getNode(e.from));
            toIndex = '\u0000';
            if (this.currentGraph.getNode(e.from) == null) {
                this.reportLoadingError(ErrorMessages.edgeStartNodeNotExists(e.label, e.from));
            }
            if (this.currentGraph.getNode(e.to) == null) {
                this.reportLoadingError(ErrorMessages.edgeEndNodeNotExists(e.label, e.to));
            }
            graph.addEdge(this.immutableEdge(fromIndex, toIndex, e.from, e.to, e.listIndex, e.label, e.type));
        }
        for (EdgeInfo e : this.inputEdges) {
            assert (e.input);
            fromIndex = (char)(nodesWithSuccessor.contains(graph.getNode(e.from)) ? 1 : 0);
            toIndex = e.num;
            graph.addEdge(this.immutableEdge(fromIndex, toIndex, e.from, e.to, e.listIndex, e.label, e.type));
        }
    }

    private static String blockName(int id) {
        return id >= 0 ? Integer.toString(id) : NO_BLOCK;
    }

    @Override
    public InputBlock startBlock(int id) {
        return this.startBlock(ModelBuilder.blockName(id));
    }

    @Override
    public InputBlock startBlock(String name) {
        assert (this.currentGraph != null);
        assert (this.currentBlock == null);
        if (this.blockEdges == null) {
            this.blockEdges = new ArrayList<EdgeInfo>();
        }
        this.currentBlock = this.currentGraph.addBlock(name);
        return this.currentBlock;
    }

    @Override
    public void endBlock(int id) {
        this.currentBlock = null;
    }

    @Override
    public Properties getNodeProperties(int nodeId) {
        assert (this.currentGraph != null);
        return this.currentGraph.getNode(nodeId).getProperties();
    }

    protected boolean updateNodeBlock(int nodeId, String name) {
        Properties properties = this.getNodeProperties(nodeId);
        if (properties == null) {
            this.reportLoadingError(ErrorMessages.unknownNodeInblock(name, nodeId));
            return false;
        }
        String oldBlock = properties.get("block", String.class);
        if (oldBlock != null) {
            properties.setProperty("block", oldBlock + ", " + name);
            return false;
        }
        properties.setProperty("block", name);
        return true;
    }

    @Override
    public void addNodeToBlock(int nodeId) {
        assert (this.currentBlock != null);
        String name = this.currentBlock.getName();
        if (this.updateNodeBlock(nodeId, name)) {
            this.currentBlock.addNode(nodeId);
        }
    }

    @Override
    public void addBlockEdge(int from, int to) {
        this.blockEdges.add(new EdgeInfo(from, to));
    }

    @Override
    public void makeBlockEdges() {
        assert (this.currentGraph != null);
        if (this.blockEdges != null) {
            for (EdgeInfo e : this.blockEdges) {
                String fromName = ModelBuilder.blockName(e.from);
                String toName = ModelBuilder.blockName(e.to);
                this.currentGraph.addBlockEdge(this.currentGraph.getBlock(fromName), this.currentGraph.getBlock(toName));
            }
        }
        this.currentGraph.ensureNodesInBlocks();
    }

    @Override
    public void setMethod(String name, String shortName, int bci, BinaryReader.Method method) {
        assert (this.currentNode == null);
        assert (this.currentGraph == null);
        assert (this.folder instanceof Group);
        Group g = (Group)this.folder;
        g.setMethod(new InputMethod(g, name, shortName, bci, method));
    }

    @Override
    public void resetStreamData() {
        this.replacePool(this.getConstantPool().restart());
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.pool;
    }

    protected void replacePool(ConstantPool newPool) {
        this.pool = newPool;
        if (this.control != null) {
            this.control.setConstantPool(newPool);
        }
    }

    @Override
    public void setModelControl(Builder.ModelControl target) {
        this.control = target;
    }

    protected ConstantPool getReaderPool() {
        return this.control.getConstantPool();
    }

    @Override
    public void startRoot() {
    }

    protected List<EdgeInfo> getInputEdges() {
        return this.inputEdges;
    }

    protected List<EdgeInfo> getSuccessorEdges() {
        return this.successorEdges;
    }

    protected List<EdgeInfo> getNodeEdges() {
        return this.nodeEdges;
    }

    public void reportLoadingError(String logMessage) {
        this.reportLoadingError(logMessage, null);
    }

    @Override
    public void reportLoadingError(String logMessage, List<String> initialParentNames) {
        String name;
        LOG.log(Level.WARNING, logMessage);
        ArrayList<FolderElement> parents = new ArrayList<Folder>();
        for (Folder f = this.folder(); f != null; f = f.getParent()) {
            parents.add(f);
        }
        List<String> parentNames = initialParentNames;
        if (parentNames == null) {
            parentNames = new ArrayList<String>(parents.size());
            for (FolderElement parent : parents) {
                parentNames.add(parent.getName());
            }
        }
        if (this.currentGraph != null) {
            name = this.currentGraph.getName();
        } else if (parentNames.isEmpty()) {
            name = "<none>";
        } else {
            name = parentNames.remove(parentNames.size() - 1);
            int listSize = Math.min(parents.size(), parentNames.size());
            parents = parents.subList(parents.size() - listSize, parents.size());
        }
        LOG.log(Level.WARNING, "Location: {0}", name);
        StringBuilder indent = new StringBuilder("          ");
        for (FolderElement parent : parents) {
            indent.append("   -> ");
            LOG.log(Level.WARNING, "{0} {1}", new Object[]{indent, parent.getName()});
        }
        ParseMonitor mon = this.getMonitor();
        if (mon != null) {
            Collections.reverse(parents);
            mon.reportError(parents, parentNames, name, logMessage);
        }
    }

    protected ParseMonitor getMonitor() {
        return this.monitor;
    }

    private static class FakeGID {
        private final Object outerId;
        private final Object nestedID;

        FakeGID(Object outerId, Object nestedID) {
            this.outerId = outerId;
            this.nestedID = nestedID;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.outerId);
            hash = 17 * hash + Objects.hashCode(this.nestedID);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FakeGID other = (FakeGID)obj;
            if (!Objects.equals(this.outerId, other.outerId)) {
                return false;
            }
            return Objects.equals(this.nestedID, other.nestedID);
        }
    }

    public static final class EdgeInfo {
        final int from;
        final int to;
        final char num;
        final int listIndex;
        final String label;
        final String type;
        final boolean input;

        EdgeInfo(int from, int to) {
            this(from, to, '\u0000', -1, null, null, false);
        }

        EdgeInfo(int from, int to, char num, int listIndex, String label, String type, boolean input) {
            this.from = from;
            this.to = to;
            this.label = label;
            this.type = type;
            this.num = num;
            this.listIndex = listIndex;
            this.input = input;
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        public int getListIndex() {
            return this.listIndex;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != EdgeInfo.class) {
                return false;
            }
            EdgeInfo otherEdge = (EdgeInfo)other;
            return this.from == otherEdge.from && this.to == otherEdge.to && this.num == otherEdge.num && this.listIndex == otherEdge.listIndex && this.input == otherEdge.input && Objects.equals(this.label, otherEdge.label) && Objects.equals(this.type, otherEdge.type);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to, this.listIndex, this.label);
        }
    }

    private static final class ErrorMessages {
        private ErrorMessages() {
        }

        public static String edgeStartNodeNotExists(String label, int node) {
            return String.format("Start node for edge %s does not exist: %d", label, node);
        }

        public static String edgeEndNodeNotExists(String label, int node) {
            return String.format("End node for edge %s does not exist: %d", label, node);
        }

        public static String unknownNodeInblock(String block, int node) {
            return String.format("Adding unknown node %d to block %s", node, block);
        }
    }
}

