/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.model.InputMethod;

public class InputBytecode {
    private final int bci;
    private final int length;
    private final byte[] code;
    private final String name;
    private String operands;
    private final String comment;
    private InputMethod inlined;
    private static final String[] OPCODE = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "invokedynamic", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w"};
    private static final int[] OPCODE_AFTER_BYTES = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, -1, -1, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2, 1, 2, 0, 0, 2, 2, 0, 0, -1, 3, 2, 2, 4, 4};
    private static final int[] OPCODE_AFTER_SIZE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 4, 4, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 0, 0, 2, 2, 0, 0, 2, 2, 2, 2, 4, 4};

    private InputBytecode(int bci, byte[] code, int opcode, int length) {
        this.bci = bci;
        this.length = length;
        this.code = code;
        this.name = OPCODE[opcode];
        this.operands = null;
        this.comment = null;
    }

    public InputBytecode(int bci, String name, String operands, String comment) {
        this.bci = bci;
        this.length = -1;
        this.code = null;
        this.name = name;
        this.operands = operands;
        this.comment = comment;
    }

    public InputMethod getInlined() {
        return this.inlined;
    }

    public void setInlined(InputMethod inlined) {
        this.inlined = inlined;
    }

    public int getBci() {
        return this.bci;
    }

    public String getName() {
        return this.name;
    }

    public String getOperands() {
        if (this.operands == null) {
            this.operands = this.code == null ? "" : InputBytecode.readOperands(this.code, this.bci, this.length, InputBytecode.toUnsignedInt(this.code[this.bci]));
        }
        return this.operands;
    }

    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.bci;
        hash = 83 * hash + Objects.hashCode(this.name);
        hash = 83 * hash + (this.code == null ? Objects.hashCode(this.operands) : InputBytecode.hashFromRange(this.code, this.bci, this.bci + this.length));
        hash = 83 * hash + Objects.hashCode(this.comment);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputBytecode)) {
            return false;
        }
        InputBytecode other = (InputBytecode)obj;
        return this.bci == other.bci && Objects.equals(this.name, other.name) && (this.code == null ? Objects.equals(this.operands, other.operands) : InputBytecode.equalsInRanges(this.code, this.bci, this.bci + this.length, other.code, other.bci, other.bci + other.length)) && Objects.equals(this.comment, other.comment) && Objects.equals(this.inlined, other.inlined);
    }

    public static List<InputBytecode> parseCode(byte[] code, List<InputBytecode> initialBytecodes, List<InputMethod> inlinedMethods) {
        int toSkip;
        List<InputMethod> inlined;
        assert (code != null && code.length > 0);
        List<InputBytecode> bytecodes = initialBytecodes;
        if (bytecodes == null) {
            bytecodes = new ArrayList<InputBytecode>();
        }
        if ((inlined = inlinedMethods) == null) {
            inlined = Collections.emptyList();
        }
        block0: for (int i = 0; i < code.length; i += toSkip + 1) {
            int opcode = InputBytecode.toUnsignedInt(code[i]);
            assert (opcode >= 0 && opcode <= 201) : "Opcode \"" + opcode + "\" isn't in expected range: <0-201>";
            toSkip = InputBytecode.resolveLength(code, i, opcode);
            InputBytecode bc = new InputBytecode(i, code, opcode, toSkip);
            bytecodes.add(bc);
            for (InputMethod m : inlined) {
                if (m.getBci() != i) continue;
                bc.setInlined(m);
                continue block0;
            }
        }
        return bytecodes;
    }

    private static String readOperands(byte[] code, int startPos, int length, int opcode) {
        int pos = startPos + 1;
        int toRead = length;
        StringBuilder bld = new StringBuilder();
        int size = OPCODE_AFTER_SIZE[opcode];
        if (opcode == 196) {
            bld.append(OPCODE[InputBytecode.toUnsignedInt(code[pos])]).append(", ");
            ++pos;
            --toRead;
        } else if (opcode == 170 || opcode == 171) {
            int padding = pos % 4;
            padding = padding == 0 ? 0 : 4 - padding;
            pos += padding;
            toRead -= padding;
        }
        for (int i = pos; i < pos + toRead; i += size) {
            bld.append(InputBytecode.intFromRange(code, i, i + size)).append(", ");
        }
        if (bld.length() > 0) {
            bld.setLength(bld.length() - 2);
        }
        return bld.toString();
    }

    private static int resolveLength(byte[] code, int startPos, int opcode) {
        int position = startPos + 1;
        switch (opcode) {
            case 196: {
                if (InputBytecode.toUnsignedInt(code[position]) == 132) {
                    return 5;
                }
                return 3;
            }
            case 170: 
            case 171: {
                int padding = position % 4;
                padding = padding == 0 ? 0 : 4 - padding;
                int l = InputBytecode.intFromRange(code, (position += padding) + 4, position + 8);
                if (opcode == 171) {
                    return 8 + padding + 8 * l;
                }
                int h = InputBytecode.intFromRange(code, position + 8, position + 12);
                return 12 + padding + 4 * (h - l + 1);
            }
        }
        return OPCODE_AFTER_BYTES[opcode];
    }

    private static int intFromRange(byte[] bytes, int from, int to) {
        assert (from >= 0 && to - from <= 4);
        int val = 0;
        for (int i = from; i < to; ++i) {
            val <<= 8;
            val |= bytes[i] & 0xFF;
        }
        return val;
    }

    private static int hashFromRange(byte[] source, int from, int to) {
        int hash = 23;
        for (int i = from; i < Math.min(source.length, to); ++i) {
            hash = hash * 7 + source[i];
        }
        return hash;
    }

    private static boolean equalsInRanges(byte[] source1, int start1, int end1, byte[] source2, int start2, int end2) {
        int to2;
        int from1 = InputBytecode.toRange(start1, source1.length, 0);
        int from2 = InputBytecode.toRange(start2, source2.length, 0);
        int to1 = InputBytecode.toRange(end1, source1.length, 0);
        if (to1 - from1 != (to2 = InputBytecode.toRange(end2, source2.length, 0)) - from2) {
            return false;
        }
        for (int i = 0; i < to1 - from1; ++i) {
            if (source1[from1 + i] == source2[from2 + i]) continue;
            return false;
        }
        return true;
    }

    private static int toRange(int value, int max, int min) {
        return Math.max(min, Math.min(max, value));
    }

    private static int toUnsignedInt(byte b) {
        return b & 0xFF;
    }
}

