/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.ModelBuilder;
import jdk.graal.compiler.graphio.parsing.model.AbstractMutableDocumentItem;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.DumpedElement;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputBlockEdge;
import jdk.graal.compiler.graphio.parsing.model.InputEdge;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;

public class InputGraph
extends AbstractMutableDocumentItem<InputGraph>
implements FolderElement,
DumpedElement {
    public static final int INVALID_INDEX = -1;
    private final transient ChangedEvent<InputGraph> propertyChangedEvent;
    private final int dumpId;
    private final String format;
    private final Object[] args;
    private final transient Object id;
    private Folder parent;
    private Group parentGroup;
    private Set<Integer> nodeIds;
    private volatile boolean frozen;
    private String graphType;
    private final GraphData data = new GraphData();

    public int getDumpId() {
        return this.dumpId;
    }

    public String getFormat() {
        return this.format;
    }

    public Object[] getArgs() {
        return this.args;
    }

    void freeze() {
        assert (this.graphType != null) : "InputGraph type must be set before being frozen";
        this.freezeProperties();
        this.frozen = true;
    }

    boolean isFrozen() {
        return this.frozen;
    }

    public String getGraphType() {
        return this.graphType;
    }

    public final void setGraphType(String type) {
        assert (!this.isFrozen());
        this.graphType = type;
    }

    @Override
    public ChangedEvent<InputGraph> getPropertyChangedEvent() {
        return this.propertyChangedEvent;
    }

    public InputGraph(int dumpId, String format, Object[] args) {
        this(null, dumpId, format, args);
    }

    public InputGraph(Object id, int dumpId, String format, Object[] args) {
        super(Properties.newProperties("name", ModelBuilder.makeGraphName(dumpId, format, args)));
        this.id = id == null ? Long.valueOf(Group.uniqueIDGenerator.getAndIncrement()) : id;
        this.dumpId = dumpId;
        this.format = format;
        this.args = args;
        this.propertyChangedEvent = new ChangedEvent<InputGraph>(this);
    }

    public static InputGraph createTestGraph(String name) {
        int index;
        int dumpId = -1;
        String format = name;
        if (name != null && (index = name.indexOf(":")) != -1) {
            dumpId = Integer.parseInt(name.substring(0, index));
            format = name.substring(index + 1).trim();
        }
        if (format == null) {
            format = "";
        }
        InputGraph ig = new InputGraph(null, dumpId, format, new Object[0]);
        ig.setGraphType("defaultType");
        return ig;
    }

    @Override
    public Object getID() {
        return this.id;
    }

    protected GraphData data() {
        return this.data;
    }

    @Override
    public void setParent(Folder parent) {
        assert (!this.isFrozen());
        this.parent = parent;
        if (parent instanceof Group) {
            assert (this.parentGroup == null);
            this.parentGroup = (Group)parent;
            if (this.parentGroup.isPlaceholderGroup()) {
                return;
            }
        }
        if (parent != null) {
            this.freeze();
        }
    }

    public InputBlockEdge addBlockEdge(InputBlock left, InputBlock right) {
        assert (!this.isFrozen());
        InputBlockEdge edge = new InputBlockEdge(left, right);
        this.data().blockEdges.add(edge);
        left.addSuccessor(right);
        return edge;
    }

    public Map<Integer, InputNode> getNodeMap() {
        return Collections.unmodifiableMap(this.data().nodes);
    }

    public Set<Integer> getNodeIds() {
        if (this.nodeIds != null) {
            return this.nodeIds;
        }
        this.nodeIds = Collections.unmodifiableSet(new LinkedHashSet<Integer>(this.data().nodes.keySet()));
        return this.nodeIds;
    }

    public List<InputNode> findRootNodes() {
        ArrayList<InputNode> result = new ArrayList<InputNode>();
        LinkedHashSet<Integer> nonRoot = new LinkedHashSet<Integer>();
        GraphData d = this.data();
        for (InputEdge curEdges : d.edges) {
            nonRoot.add(curEdges.getTo());
        }
        for (InputNode node : d.getNodes()) {
            if (nonRoot.contains(node.getId())) continue;
            result.add(node);
        }
        return result;
    }

    public Map<InputNode, List<InputEdge>> findAllOutgoingEdges() {
        LinkedHashMap<InputNode, List<InputEdge>> result = new LinkedHashMap<InputNode, List<InputEdge>>(this.getNodes().size());
        for (InputNode n : this.getNodes()) {
            result.put(n, new ArrayList());
        }
        GraphData d = this.data();
        for (InputEdge e : d.edges) {
            int from = e.getFrom();
            InputNode fromNode = this.getNode(from);
            List fromList = (List)result.get(fromNode);
            assert (fromList != null);
            fromList.add(e);
        }
        for (InputNode n : d.getNodes()) {
            List list = (List)result.get(n);
            list.sort(InputEdge.OUTGOING_COMPARATOR);
        }
        return result;
    }

    public Map<InputNode, List<InputEdge>> findAllIngoingEdges() {
        LinkedHashMap<InputNode, List<InputEdge>> result = new LinkedHashMap<InputNode, List<InputEdge>>(this.getNodes().size());
        GraphData d = this.data();
        for (InputNode n : d.getNodes()) {
            result.put(n, new ArrayList());
        }
        for (InputEdge e : d.edges) {
            int to = e.getTo();
            InputNode toNode = this.getNode(to);
            List toList = (List)result.get(toNode);
            assert (toList != null);
            toList.add(e);
        }
        for (InputNode n : d.getNodes()) {
            List list = (List)result.get(n);
            list.sort(InputEdge.INGOING_COMPARATOR);
        }
        return result;
    }

    public List<InputEdge> findOutgoingEdges(InputNode n) {
        ArrayList<InputEdge> result = new ArrayList<InputEdge>();
        for (InputEdge e : this.data().edges) {
            if (e.getFrom() != n.getId()) continue;
            result.add(e);
        }
        result.sort(InputEdge.OUTGOING_COMPARATOR);
        return result;
    }

    public void clearBlocks() {
        assert (!this.isFrozen());
        this.data().blocks.clear();
        this.data().nodeToBlock.clear();
    }

    public void setEdge(int fromIndex, int toIndex, int from, int to) {
        assert (!this.isFrozen());
        assert (fromIndex == (char)fromIndex) : "Downcast must be safe";
        assert (toIndex == (char)toIndex) : "Downcast must be safe";
        InputEdge edge = new InputEdge((char)fromIndex, (char)toIndex, from, to);
        if (!this.getEdges().contains(edge)) {
            this.addEdge(edge);
        }
    }

    public void ensureNodesInBlocks() {
        InputBlock noBlock = null;
        GraphData d = this.data();
        for (InputNode n : d.getNodes()) {
            assert (d.nodes.get(n.getId()) == n);
            if (!d.nodeToBlock.containsKey(n.getId())) {
                if (noBlock == null) {
                    noBlock = this.addBlock("(no block)");
                }
                noBlock.addNode(n.getId());
            }
            assert (this.getBlock(n) != null);
        }
    }

    public void setBlock(InputNode node, InputBlock block) {
        assert (!this.isFrozen());
        this.data().nodeToBlock.put(node.getId(), block);
    }

    public InputBlock getBlock(int nodeId) {
        return this.data().nodeToBlock.get(nodeId);
    }

    public InputBlock getBlock(InputNode node) {
        assert (this.data().nodes.containsKey(node.getId()));
        assert (this.data().nodes.get(node.getId()).equals(node));
        return this.getBlock(node.getId());
    }

    public InputGraph getNext() {
        return this.parentGroup.getNext(this);
    }

    public InputGraph getPrev() {
        return this.parentGroup.getPrev(this);
    }

    public boolean isNodeChanged(int nodeId) {
        InputGraph prev = this.getPrev();
        if (prev == null || !this.containsNode(nodeId)) {
            return true;
        }
        if (!prev.containsNode(nodeId)) {
            return true;
        }
        if (this.isDuplicate()) {
            return false;
        }
        InputNode our = this.getNode(nodeId);
        InputNode their = prev.getNode(nodeId);
        return our.getProperties().equals(their.getProperties());
    }

    @Override
    public String getName() {
        return this.getProperties().get("name", String.class);
    }

    public int getNodeCount() {
        return this.data().nodes.size();
    }

    public int getEdgeCount() {
        return this.data().edges.size();
    }

    public Collection<InputNode> getNodes() {
        return Collections.unmodifiableCollection(this.data().nodes.values());
    }

    public Set<Integer> getNodesAsSet() {
        return Collections.unmodifiableSet(this.data().nodes.keySet());
    }

    public Collection<InputBlock> getBlocks() {
        return Collections.unmodifiableCollection(this.data().blocks.values());
    }

    public void addNode(InputNode node) {
        assert (!this.isFrozen());
        if (this.data().nodes.containsKey(node.getId())) {
            throw new IllegalStateException("InputGraph already contains InputNode with Id=" + node.getId());
        }
        this.data().nodes.put(node.getId(), node);
        if (this.data().highestNodeId < node.getId()) {
            this.data().highestNodeId = node.getId();
        }
        this.nodeIds = null;
    }

    public int getHighestNodeId() {
        return this.data().highestNodeId;
    }

    public InputNode getNode(int nodeId) {
        return this.data().nodes.get(nodeId);
    }

    public InputNode removeNode(int nodeId) {
        assert (!this.isFrozen());
        InputNode n = this.data().nodes.remove(nodeId);
        if (n != null) {
            this.nodeIds = null;
        }
        return n;
    }

    public Collection<InputEdge> getEdges() {
        return Collections.unmodifiableCollection(this.data().edges);
    }

    public void removeEdge(InputEdge c) {
        assert (!this.isFrozen());
        boolean removed = this.data().edges.remove(c);
        assert (removed);
    }

    public void addEdge(InputEdge c) {
        assert (!this.isFrozen());
        this.data().edges.add(c);
    }

    public Group getGroup() {
        return this.parentGroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Graph ").append(this.getName()).append(" ").append(this.getProperties().toString()).append("\n");
        for (InputNode n : this.data().nodes.values()) {
            sb.append(n.toString());
            sb.append("\n");
        }
        for (InputEdge c : this.data().edges) {
            sb.append(c.toString());
            sb.append("\n");
        }
        for (InputBlock b : this.getBlocks()) {
            sb.append(b.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public InputBlock addBlock(String name) {
        assert (!this.isFrozen());
        InputBlock b = new InputBlock(this, name);
        this.data().blocks.put(b.getName(), b);
        return b;
    }

    public InputBlock getBlock(String s) {
        return this.data().blocks.get(s);
    }

    public Collection<InputBlockEdge> getBlockEdges() {
        return Collections.unmodifiableList(this.data().blockEdges);
    }

    @Override
    public Folder getParent() {
        return this.parent;
    }

    protected void complete() {
    }

    public boolean containsNode(int nodeId) {
        return this.getNode(nodeId) != null;
    }

    public boolean isDuplicate() {
        return this.getProperties().get("_isDuplicate") != null;
    }

    public static final class GraphData {
        private final Map<Integer, InputNode> nodes = new LinkedHashMap<Integer, InputNode>();
        private final Collection<InputEdge> edges = new LinkedHashSet<InputEdge>();
        private final Map<String, InputBlock> blocks = new LinkedHashMap<String, InputBlock>();
        private final List<InputBlockEdge> blockEdges = new ArrayList<InputBlockEdge>();
        private final Map<Integer, InputBlock> nodeToBlock = new LinkedHashMap<Integer, InputBlock>();
        private int highestNodeId = -1;

        public Collection<InputNode> getNodes() {
            return this.nodes.values();
        }

        public Collection<InputEdge> getEdges() {
            return this.edges;
        }

        public Map<String, InputBlock> getBlocks() {
            return this.blocks;
        }

        public List<InputBlockEdge> getBlockEdges() {
            return this.blockEdges;
        }

        public Map<Integer, InputBlock> getNodeToBlock() {
            return this.nodeToBlock;
        }

        public Map<Integer, InputNode> getNodeMap() {
            return this.nodes;
        }
    }
}

