/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.data.serialization.lazy.Completer;
import org.graalvm.visualizer.data.serialization.lazy.GraphMetadata;
import org.graalvm.visualizer.data.serialization.lazy.GroupCompleter;
import org.graalvm.visualizer.data.serialization.lazy.LoadSupport;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;

public final class LazyGroup
extends Group
implements Group.LazyContent<List<? extends FolderElement>> {
    private static final Reference<List<InputGraph>> EMPTY = new WeakReference<Object>(null);
    private volatile Reference<List<InputGraph>> graphs = EMPTY;
    private final LoadSupport<List<? extends FolderElement>> cSupport;
    private final Set<String> excludedNames = new HashSet<String>();
    private final GroupCompleter completer;

    public LazyGroup(Folder parent, GroupCompleter completer, StreamEntry entry) {
        super(parent, entry);
        this.completer = completer;
        this.cSupport = new LoadSupport<List<? extends FolderElement>>((Completer)completer){

            @Override
            protected List<? extends FolderElement> emptyData() {
                return new ArrayList();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dataReceived() {
        LazyGroup lazyGroup = this;
        synchronized (lazyGroup) {
            this.graphs = EMPTY;
        }
    }

    @Override
    public boolean isComplete() {
        return this.cSupport.isComplete();
    }

    @Override
    public List<FolderElement> getElements() {
        return this.cSupport.getContents();
    }

    @Override
    protected List<? extends FolderElement> getElementsInternal() {
        return this.cSupport.getContents();
    }

    @Override
    public List<? extends FolderElement> partialData() {
        return this.cSupport.partialData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElement(FolderElement element) {
        if (element == null) {
            return;
        }
        List<? extends FolderElement> els = this.getElementsInternal();
        if (!els.contains(element)) {
            return;
        }
        this.completer.removeData(element);
        LazyGroup lazyGroup = this;
        synchronized (lazyGroup) {
            this.graphs = EMPTY;
            this.excludedNames.add(element.getName());
        }
        this.fireChangedEvent();
        this.notifyContentRemoved(Collections.singletonList(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        List<? extends FolderElement> els = this.getElementsInternal();
        for (FolderElement folderElement : els) {
            this.completer.removeData(folderElement);
        }
        LazyGroup lazyGroup = this;
        synchronized (lazyGroup) {
            this.graphs = EMPTY;
            els.forEach(e -> this.excludedNames.add(e.getName()));
        }
        this.fireChangedEvent();
        this.notifyContentRemoved(els);
    }

    synchronized Set<String> getExcludedNames() {
        return new HashSet<String>(this.excludedNames);
    }

    @Override
    public int getGraphsCount() {
        return this.getGraphs().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputGraph> getGraphs() {
        List<InputGraph> l;
        LazyGroup lazyGroup = this;
        synchronized (lazyGroup) {
            Reference<List<InputGraph>> rg = this.graphs;
            l = rg.get();
        }
        if (l != null) {
            return l;
        }
        List<? extends FolderElement> fl = this.getElementsInternal();
        l = Collections.unmodifiableList(fl.stream().filter(e -> e instanceof InputGraph).collect(Collectors.toList()));
        this.graphs = new WeakReference<List<InputGraph>>(l);
        return l;
    }

    @Override
    public synchronized Future<List<? extends FolderElement>> completeContents(Group.Feedback feedback) {
        return this.cSupport.completeContents(feedback);
    }

    @Override
    public void addElement(FolderElement element) {
    }

    @Override
    public void addElements(List<? extends FolderElement> newElements) {
    }

    @Override
    public String toString() {
        if (this.isComplete()) {
            return super.toString();
        }
        return "Group " + this.getProperties() + "\n";
    }

    static class LoadedGraph
    extends InputGraph
    implements ChangedEventProvider<Object> {
        private final ChangedEvent<Object> ev = new ChangedEvent<LoadedGraph>(this);
        private final GraphMetadata meta;

        public LoadedGraph(StreamEntry graphEntry, GraphMetadata meta, int dumpId, String format, Object[] args) {
            super(graphEntry, dumpId, format, args);
            this.meta = meta;
        }

        @Override
        public ChangedEvent<Object> getChangedEvent() {
            return this.ev;
        }

        @Override
        public boolean isNodeChanged(int nodeId) {
            if (this.meta != null) {
                return this.meta.changedNodeIds.get(nodeId);
            }
            return super.isNodeChanged(nodeId);
        }
    }
}

