/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ScheduledExecutorService;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import org.graalvm.visualizer.data.serialization.lazy.CachedContent;
import org.graalvm.visualizer.data.serialization.lazy.FileContent;
import org.graalvm.visualizer.data.serialization.lazy.LoadSupport;
import org.graalvm.visualizer.data.serialization.lazy.ScanningModelBuilder;
import org.graalvm.visualizer.data.serialization.lazy.SingleGroupBuilder;
import org.openide.util.RequestProcessor;

public class LazySerDebugUtils {
    public static void init() {
    }

    public static void setLargeThreshold(int threshold) {
        SingleGroupBuilder.setLargeEntryThreshold(threshold);
    }

    public static GraphDocument loadResource(GraphDocument doc, File file) throws IOException {
        if (doc == null) {
            doc = new GraphDocument();
        }
        GraphDocument fDoc = doc;
        FileContent fc = new FileContent(file.toPath(), FileChannel.open(file.toPath(), StandardOpenOption.READ));
        BinarySource scanSource = new BinarySource(null, fc);
        ScanningModelBuilder smb = new ScanningModelBuilder(scanSource, (CachedContent)fc, (i, p, g) -> fDoc, null, (ScheduledExecutorService)RequestProcessor.getDefault());
        BinaryReader reader = new BinaryReader(scanSource, smb);
        reader.parse();
        return doc;
    }

    static {
        LoadSupport._testUseWeakRefs = true;
    }
}

