/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualizer.data.serialization.lazy.CachedContent;
import org.graalvm.visualizer.data.serialization.lazy.FileContent;
import org.openide.util.Exceptions;

public class NetworkStreamContent
implements ReadableByteChannel,
CachedContent,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(NetworkStreamContent.class.getName());
    static int DEFAULT_RECEIVE_BUFFER_SIZE = 0xA00000;
    private static final boolean KEEP_CACHES = Boolean.getBoolean(NetworkStreamContent.class.getName() + ".keepCaches");
    private static final String CACHE_FILE_EXT = ".bgv";
    private static final String CACHE_FILE_TEMPLATE = "igvdata_%d";
    private static final String CACHE_DIRECTORY_NAME = "igv";
    private final int receiveBufferSize = DEFAULT_RECEIVE_BUFFER_SIZE;
    private final List<ByteBuffer> cacheBuffers = new ArrayList<ByteBuffer>();
    private ByteBuffer receiveBuffer;
    private final ReadableByteChannel ioDelegate;
    private final File cacheDir;
    private FileChannel dumpChannel;
    File dumpFile;
    private long readBytes;
    private static final AtomicInteger contentIdGenerator = new AtomicInteger();
    private long receiveBufferOffset;
    private long firstBufferOffset;
    private final AtomicInteger bufferId = new AtomicInteger();
    private final String contentId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkStreamContent(ReadableByteChannel ioDelegate, File cacheDir) throws IOException {
        this.cacheDir = cacheDir;
        this.ioDelegate = ioDelegate;
        this.receiveBuffer = ByteBuffer.allocateDirect(this.receiveBufferSize);
        NetworkStreamContent networkStreamContent = this;
        synchronized (networkStreamContent) {
            if (cacheDir != null) {
                this.dumpFile = this.tempFile();
                this.contentId = this.dumpFile.getPath();
                LOG.log(Level.FINE, "Created temp file {0}, ", this.dumpFile);
                if (!KEEP_CACHES) {
                    this.dumpFile.deleteOnExit();
                }
                this.dumpChannel = FileChannel.open(this.dumpFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.DSYNC, StandardOpenOption.TRUNCATE_EXISTING);
            } else {
                this.dumpFile = null;
                this.dumpChannel = null;
                this.contentId = "";
            }
        }
    }

    public File getDumpFile() {
        return this.dumpFile;
    }

    private File tempFile() throws IOException {
        return File.createTempFile(String.format(CACHE_FILE_TEMPLATE, this.bufferId.incrementAndGet()), CACHE_FILE_EXT, this.cacheDir);
    }

    @Override
    public synchronized boolean resetCache(long offset) {
        ByteBuffer bb;
        int l;
        if (KEEP_CACHES || this.firstBufferOffset > offset) {
            return false;
        }
        long pos = this.firstBufferOffset;
        long off = this.firstBufferOffset;
        Iterator<ByteBuffer> bit = this.cacheBuffers.iterator();
        while (bit.hasNext() && (pos += (long)(l = (bb = bit.next()).capacity())) <= offset) {
            bit.remove();
            off = pos;
        }
        AbstractInterruptibleChannel wfch = null;
        File f = null;
        if (this.receiveBuffer != null || this.readBytes > offset) {
            try {
                f = this.tempFile();
                wfch = FileChannel.open(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.DSYNC, StandardOpenOption.TRUNCATE_EXISTING);
                if (!this.cacheBuffers.isEmpty()) {
                    ByteBuffer out = ByteBuffer.allocate(this.receiveBufferSize);
                    for (ByteBuffer bb2 : this.cacheBuffers) {
                        ByteBuffer copy = bb2.asReadOnlyBuffer();
                        out.put(copy);
                        out.flip();
                        while (out.hasRemaining()) {
                            ((FileChannel)wfch).write(out);
                        }
                        out.clear();
                    }
                }
                ((FileChannel)wfch).force(true);
            }
            catch (IOException ex) {
                try {
                    if (f != null) {
                        f.delete();
                    }
                    if (wfch != null) {
                        wfch.close();
                    }
                }
                catch (IOException clex) {
                    Exceptions.printStackTrace((Throwable)clex);
                }
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        if (wfch == null && this.receiveBuffer != null) {
            return false;
        }
        try {
            this.dumpFile.delete();
            this.dumpChannel.close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.dumpFile = f;
        this.dumpChannel = wfch;
        this.firstBufferOffset = off;
        return this.receiveBuffer == null && this.dumpFile == null;
    }

    @Override
    public String id() {
        return this.contentId;
    }

    private synchronized void flushToDisk() throws IOException {
        if (this.dumpChannel == null) {
            return;
        }
        ByteBuffer bb = this.receiveBuffer.duplicate();
        bb.flip();
        long startPos = this.dumpChannel.position();
        int len = bb.remaining();
        this.dumpChannel.write(bb);
        this.dumpChannel.force(false);
        this.receiveBufferOffset += (long)len;
        LOG.log(Level.FINER, "Flushed {0} bytes to {1}, recbuffer starts at {2}", new Object[]{len, this.dumpFile, this.receiveBufferOffset});
        MappedByteBuffer mappedBB = this.dumpChannel.map(FileChannel.MapMode.READ_ONLY, startPos, len);
        ((ByteBuffer)mappedBB).position(len);
        this.cacheBuffers.add(mappedBB);
        this.receiveBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        NetworkStreamContent networkStreamContent = this;
        synchronized (networkStreamContent) {
            if (this.receiveBuffer == null) {
                this.notifyAll();
                throw new EOFException();
            }
        }
        int pos = dst.position();
        int count = this.ioDelegate.read(dst);
        NetworkStreamContent networkStreamContent2 = this;
        synchronized (networkStreamContent2) {
            try {
                if (count < 0) {
                    if (this.receiveBuffer != null) {
                        this.flushToDisk();
                        this.receiveBuffer = null;
                    }
                    int n = count;
                    return n;
                }
                this.readBytes += (long)count;
                ByteBuffer del = dst.asReadOnlyBuffer();
                del.flip();
                del.position(pos);
                while (del.remaining() > 0) {
                    if (del.remaining() < this.receiveBuffer.remaining()) {
                        this.receiveBuffer.put(del);
                        continue;
                    }
                    del.limit(pos + this.receiveBuffer.remaining());
                    this.receiveBuffer.put(del);
                    this.flushToDisk();
                    pos = del.position();
                    del = dst.asReadOnlyBuffer();
                    del.flip();
                    del.position(pos);
                }
            }
            finally {
                this.notifyAll();
            }
        }
        long bufferedCount = (long)this.cacheBuffers.size() * (long)this.receiveBufferSize + (long)this.receiveBuffer.position();
        assert (bufferedCount == this.readBytes);
        return count;
    }

    @Override
    public boolean isOpen() {
        return this.ioDelegate.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        NetworkStreamContent networkStreamContent = this;
        synchronized (networkStreamContent) {
            if (this.receiveBuffer != null) {
                this.flushToDisk();
                this.receiveBuffer = null;
                this.notifyAll();
            }
        }
        this.ioDelegate.close();
    }

    @Override
    public synchronized ReadableByteChannel subChannel(long start, long end) throws IOException {
        if (start < this.firstBufferOffset) {
            throw new IOException("Cached content not available");
        }
        LOG.log(Level.FINER, "Allocating subchannel from dumpfile {0} range {1}-{2}", new Object[]{this.dumpFile, start, end});
        Iterator<ByteBuffer> buffers = this.buffers(start, end);
        if (end > 0L) {
            return new FileContent.BufferListChannel(buffers, null);
        }
        return new FileContent.BufferListChannel(new FollowupIterator(buffers, this.readBytes), null);
    }

    private Iterator<ByteBuffer> buffers(long start, long endPos) {
        ByteBuffer endBuf;
        int toBuffer;
        ByteBuffer b;
        ByteBuffer startBuf;
        int fromBuffer = -1;
        long pos = this.firstBufferOffset;
        long prevPos = 0L;
        int startAt = 0;
        int endAt = 0;
        ByteBuffer copyBuffer = null;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        long end = endPos == -1L ? this.readBytes : endPos;
        LOG.log(Level.FINER, "Total read bytes {0}, receiveBufferOffset {1}", new Object[]{this.readBytes, this.receiveBufferOffset});
        try {
            ByteBuffer src;
            if (start >= this.receiveBufferOffset) {
                copyBuffer = ByteBuffer.allocate(this.receiveBuffer.position());
                src = this.receiveBuffer.duplicate().flip();
                copyBuffer.put(src);
                startAt = (int)(start - this.receiveBufferOffset);
                startBuf = copyBuffer;
                fromBuffer = this.cacheBuffers.size() - 1;
                LOG.log(Level.FINEST, "start in receiveBuffer, offset {0}", startAt);
            } else {
                do {
                    b = this.cacheBuffers.get(++fromBuffer);
                    prevPos = pos;
                } while ((pos += (long)b.position()) <= start);
                startAt = (int)(start - prevPos);
                startBuf = this.cacheBuffers.get(fromBuffer).asReadOnlyBuffer();
                LOG.log(Level.FINEST, "start in buffer {0}, offset {1}", new Object[]{fromBuffer, startAt});
            }
            toBuffer = fromBuffer;
            pos = prevPos;
            if (end > this.receiveBufferOffset) {
                if (copyBuffer == null) {
                    copyBuffer = ByteBuffer.allocate(this.receiveBuffer.position());
                    src = this.receiveBuffer.duplicate().flip();
                    copyBuffer.put(src);
                    copyBuffer.flip();
                }
                toBuffer = this.cacheBuffers.size();
                endAt = (int)(end - this.receiveBufferOffset);
                endBuf = copyBuffer;
                LOG.log(Level.FINEST, "end in receiveBuffer, offset {0}", endAt);
            } else {
                do {
                    b = this.cacheBuffers.get(toBuffer);
                    ++toBuffer;
                    prevPos = pos;
                } while ((pos += (long)b.position()) < end);
                endAt = (int)(end - prevPos);
                if (fromBuffer == --toBuffer) {
                    endBuf = startBuf;
                } else {
                    endBuf = fromBuffer == toBuffer ? startBuf : this.cacheBuffers.get(toBuffer).asReadOnlyBuffer();
                    endBuf.flip();
                }
                LOG.log(Level.FINEST, "end in buffer {0}, offset {1}", new Object[]{toBuffer, endAt});
            }
            startBuf.flip();
            startBuf.position(startAt);
            endBuf.limit(endAt);
        }
        catch (RuntimeException ex) {
            LOG.log(Level.SEVERE, "Error reading from dumpfile " + this.dumpFile, ex);
            throw ex;
        }
        buffers.add(startBuf);
        for (int i = fromBuffer + 1; i < toBuffer; ++i) {
            b = this.cacheBuffers.get(i).asReadOnlyBuffer();
            buffers.add(b.flip());
        }
        if (startBuf != endBuf) {
            buffers.add(endBuf);
        }
        return buffers.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<ByteBuffer> waitBuffers(long fromPos, Consumer<Long> newPos) {
        while (true) {
            NetworkStreamContent networkStreamContent = this;
            synchronized (networkStreamContent) {
                if (this.readBytes > fromPos) {
                    LOG.log(Level.FINEST, "Additional buffers available, total read {0}, need {1}", new Object[]{this.readBytes, fromPos});
                    newPos.accept(this.readBytes);
                    return this.buffers(fromPos, -1L);
                }
                if (this.receiveBuffer == null) {
                    return null;
                }
                try {
                    LOG.log(Level.FINEST, "Not enough data ({0}, need {1}), sleeping...", new Object[]{this.readBytes, fromPos});
                    this.wait();
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }
        }
    }

    private synchronized boolean hasMoreData(long pos) {
        return this.receiveBuffer != null || this.readBytes > pos;
    }

    class FollowupIterator
    implements Iterator<ByteBuffer> {
        private Iterator<ByteBuffer> delegate;
        private long pos;
        private boolean eof;

        public FollowupIterator(Iterator<ByteBuffer> delegate, long pos) {
            LOG.log(Level.FINER, "Created followup iterator after pos {0}", pos);
            this.delegate = delegate;
            this.pos = pos;
        }

        void setPos(long pos) {
            this.pos = pos;
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.delegate != null) {
                if (this.delegate.hasNext()) {
                    return true;
                }
                this.delegate = null;
            }
            return NetworkStreamContent.this.hasMoreData(this.pos);
        }

        @Override
        public ByteBuffer next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            if (this.delegate == null) {
                this.delegate = NetworkStreamContent.this.waitBuffers(this.pos, this::setPos);
                if (this.delegate == null) {
                    this.eof = true;
                    return ByteBuffer.allocate(0);
                }
            }
            return this.delegate.next();
        }
    }
}

