/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.List;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.Group;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;

final class ParseMonitorBridge
implements ParseMonitor {
    private final Group.Feedback feedback;
    private final BinarySource dataSource;
    private final StreamEntry entry;
    private double scaleFactor;

    public ParseMonitorBridge(StreamEntry entry, Group.Feedback feedback, BinarySource dataSource) {
        this.feedback = feedback;
        this.dataSource = dataSource;
        this.entry = entry;
    }

    private int entrySize() {
        long size = this.entry.unfinishedSize();
        if (size > Integer.MAX_VALUE) {
            this.scaleFactor = (int)Math.ceil((double)this.entry.size() / 2.147483647E9);
            return (int)((double)this.entry.size() / this.scaleFactor);
        }
        this.scaleFactor = 1.0;
        return (int)size;
    }

    private int work(int total) {
        if (total == -1) {
            return (int)((double)this.dataSource.getMarkRelative() / this.scaleFactor);
        }
        return (int)Math.min((double)total, (double)this.dataSource.getMarkRelative() / this.scaleFactor);
    }

    @Override
    public void updateProgress() {
        if (this.feedback != null) {
            int total = this.entrySize();
            this.feedback.reportProgress(this.work(total), total, null);
        }
    }

    @Override
    public void setState(String state) {
        if (this.feedback != null) {
            int total = this.entrySize();
            this.feedback.reportProgress(this.work(total), total, state);
        }
    }

    @Override
    public boolean isCancelled() {
        if (this.feedback != null) {
            return this.feedback.isCancelled();
        }
        return false;
    }

    @Override
    public void reportError(List<FolderElement> parents, List<String> parentNames, String name, String errorMessage) {
        if (this.feedback != null) {
            this.feedback.reportError(parents, parentNames, name, errorMessage);
        }
    }
}

