/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.Selector;

public class RemoveFilter
extends AbstractFilter {
    private List<RemoveRule> rules;
    private String name;

    public RemoveFilter(String name) {
        this.name = name;
        this.rules = new ArrayList<RemoveRule>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void apply(Diagram diagram) {
        for (RemoveRule r : this.rules) {
            this.checkCancelled();
            List selected = r.getSelector().selected(diagram);
            HashSet<Figure> toRemove = new HashSet<Figure>(selected);
            if (r.getRemoveOrphans()) {
                boolean changed;
                do {
                    changed = false;
                    for (Figure f : diagram.getFigures()) {
                        if (toRemove.contains(f) || !toRemove.containsAll(f.getPredecessors()) || !toRemove.containsAll(f.getSuccessors())) continue;
                        toRemove.add(f);
                        changed = true;
                    }
                } while (changed);
            }
            diagram.removeAllFigures(toRemove);
        }
    }

    public void addRule(RemoveRule rule) {
        this.rules.add(rule);
    }

    public static class RemoveRule {
        private Selector selector;
        private boolean removeOrphans;

        public RemoveRule(Selector selector) {
            this(selector, false);
        }

        public RemoveRule(Selector selector, boolean removeOrphans) {
            this.selector = selector;
            this.removeOrphans = removeOrphans;
        }

        public Selector getSelector() {
            return this.selector;
        }

        public boolean getRemoveOrphans() {
            return this.removeOrphans;
        }
    }
}

