/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graph;

import java.awt.Point;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.Slot;

public class OutputSlot
extends Slot {
    protected OutputSlot(Figure figure, int wantedIndex) {
        super(figure, wantedIndex);
    }

    @Override
    protected Slot copyInto(Figure f) {
        int index = this.getWantedIndex();
        if (index == -1) {
            return f.createOutputSlot();
        }
        return f.createOutputSlot(index);
    }

    public Point getRelativePosition() {
        int gap = this.getFigure().getWidth() - this.getFigure().getOutputSlotsWidth();
        if (gap < 0) {
            gap = 0;
        }
        double gapRatio = (double)gap / (double)(this.getFigure().getOutputSlots().size() + 1);
        int gapAmount = (int)((double)(this.getPosition() + 1) * gapRatio);
        return new Point(gapAmount + Figure.getSlotsWidth(Figure.getAllBefore(this.getFigure().getOutputSlots(), this)) + this.getWidth() / 2, 4);
    }

    public String toString() {
        return "OutputSlot[figure=" + this.getFigure().toString() + ", position=" + this.getPosition() + "]";
    }
}

