/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.ConstantPool;
import jdk.graal.compiler.graphio.parsing.DataSource;
import jdk.graal.compiler.graphio.parsing.GraphParser;
import jdk.graal.compiler.graphio.parsing.LocationCache;
import jdk.graal.compiler.graphio.parsing.LocationStackFrame;
import jdk.graal.compiler.graphio.parsing.LocationStratum;
import jdk.graal.compiler.graphio.parsing.NameTranslator;
import jdk.graal.compiler.graphio.parsing.SkipRootException;
import jdk.graal.compiler.graphio.parsing.VersionMismatchException;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;

public class BinaryReader
implements GraphParser,
Builder.ModelControl {
    private static final Logger LOG = Logger.getLogger(BinaryReader.class.getName());
    static final boolean TRACE_PARSE_TIME = false;
    private final Logger instLog;
    private final DataSource dataSource;
    private NameTranslator nameTranslator;
    private final Deque<byte[]> hashStack;
    private int folderLevel;
    private ConstantPool constantPool;
    private final Builder builder;
    private final ErrorReporter reporter;
    private static final long timeStart = System.currentTimeMillis();

    public BinaryReader(DataSource dataSource, Builder builder) {
        this.dataSource = dataSource;
        this.builder = builder;
        this.reporter = new ErrorReporter();
        this.constantPool = builder.getConstantPool();
        this.hashStack = new LinkedList<byte[]>();
        this.instLog = Logger.getLogger(LOG.getName() + "." + Integer.toHexString(System.identityHashCode(dataSource)));
        builder.setModelControl(this);
    }

    private Object[] readPoolObjects() throws IOException {
        int len = this.dataSource.readInt();
        if (len < 0) {
            return null;
        }
        Object[] props = new Object[len];
        for (int i = 0; i < len; ++i) {
            props[i] = this.readPoolObject(Object.class);
        }
        return props;
    }

    private <T> T readPoolObject(Class<T> klass) throws IOException {
        int type = this.dataSource.readByte();
        if (type == 5) {
            return null;
        }
        if (type == 0) {
            return (T)this.addPoolEntry(klass);
        }
        assert (BinaryReader.assertObjectType(klass, type)) : "Wrong object type : " + klass + " != " + type;
        char index = this.dataSource.readShort();
        if (index >= this.constantPool.size()) {
            throw new IOException("Invalid constant pool index : " + index);
        }
        Object obj = this.getPoolData(index);
        return (T)obj;
    }

    private Object getPoolData(int index) {
        return this.constantPool.get(index, -1L);
    }

    private static boolean assertObjectType(Class<?> klass, int type) {
        switch (type) {
            case 3: {
                return klass.isAssignableFrom(EnumKlass.class);
            }
            case 2: {
                return klass.isAssignableFrom(EnumValue.class);
            }
            case 4: {
                return klass.isAssignableFrom(Method.class);
            }
            case 1: {
                return klass.isAssignableFrom(String.class);
            }
            case 6: {
                return klass.isAssignableFrom(Builder.NodeClass.class);
            }
            case 7: {
                return klass.isAssignableFrom(Field.class);
            }
            case 8: {
                return klass.isAssignableFrom(Signature.class);
            }
            case 9: {
                return klass.isAssignableFrom(LocationStackFrame.class);
            }
            case 10: {
                return klass.isAssignableFrom(Builder.Node.class);
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    private Object addPoolEntry(Class<?> klass) throws IOException {
        char index = this.dataSource.readShort();
        int type = this.dataSource.readByte();
        assert (BinaryReader.assertObjectType(klass, type)) : "Wrong object type : " + klass + " != " + type;
        return this.constantPool.addPoolEntry(index, switch (type) {
            case 3 -> {
                int klasstype;
                String conv;
                String name = this.dataSource.readString();
                String v0 = conv = this.nameTranslator == null ? null : this.nameTranslator.translate(name);
                if (conv != null) {
                    name = conv;
                }
                if ((klasstype = this.dataSource.readByte()) == 1) {
                    int len = this.dataSource.readInt();
                    String[] values = new String[len];
                    for (int i = 0; i < len; ++i) {
                        values[i] = this.readPoolObject(String.class);
                    }
                    yield new EnumKlass(name, values);
                }
                if (klasstype == 0) {
                    yield new Klass(name);
                }
                throw new IOException("unknown klass type : " + klasstype);
            }
            case 2 -> {
                EnumKlass enumClass = this.readPoolObject(EnumKlass.class);
                int ordinal = this.dataSource.readInt();
                yield enumClass.get(ordinal);
            }
            case 6 -> {
                String className;
                if (this.dataSource.getMajorVersion() < 2) {
                    className = this.dataSource.readString();
                } else {
                    Klass nodeClass = this.readPoolObject(Klass.class);
                    className = nodeClass.toString();
                }
                String nameTemplate = this.dataSource.readString();
                int inputCount = this.dataSource.readShort();
                ArrayList<Builder.TypedPort> inputs = new ArrayList<Builder.TypedPort>(inputCount);
                for (int i = 0; i < inputCount; ++i) {
                    boolean isList = this.dataSource.readByte() != 0;
                    String name = this.readPoolObject(String.class);
                    EnumValue inputType = this.readPoolObject(EnumValue.class);
                    inputs.add(new Builder.TypedPort(isList, name, inputType));
                }
                int suxCount = this.dataSource.readShort();
                ArrayList<Builder.Port> sux = new ArrayList<Builder.Port>(suxCount);
                for (int i = 0; i < suxCount; ++i) {
                    boolean isList = this.dataSource.readByte() != 0;
                    String name = this.readPoolObject(String.class);
                    sux.add(new Builder.Port(isList, name));
                }
                yield new Builder.NodeClass(className, nameTemplate, inputs, sux);
            }
            case 4 -> {
                Klass holder = this.readPoolObject(Klass.class);
                String name = this.readPoolObject(String.class);
                Signature sign = this.readPoolObject(Signature.class);
                int flags = this.dataSource.readInt();
                byte[] code = this.dataSource.readBytes();
                yield new Method(name, sign, code, holder, flags);
            }
            case 7 -> {
                Klass holder = this.readPoolObject(Klass.class);
                String name = this.readPoolObject(String.class);
                String fType = this.readPoolObject(String.class);
                int flags = this.dataSource.readInt();
                yield new Field(fType, holder, name, flags);
            }
            case 8 -> {
                int argc = this.dataSource.readShort();
                String[] args = new String[argc];
                for (int i = 0; i < argc; ++i) {
                    args[i] = this.readPoolObject(String.class);
                }
                String returnType = this.readPoolObject(String.class);
                yield new Signature(returnType, args);
            }
            case 9 -> {
                String uri;
                Method method = this.readPoolObject(Method.class);
                int bci = this.dataSource.readInt();
                if (this.dataSource.getMajorVersion() < 6) {
                    String fileName = this.readPoolObject(String.class);
                    int line = -1;
                    if (fileName != null) {
                        line = this.dataSource.readInt();
                    }
                    LocationStackFrame parent = this.readPoolObject(LocationStackFrame.class);
                    yield LocationCache.createFrame(method, bci, LocationCache.fileLineStratum(fileName, line), parent);
                }
                ArrayList<LocationStratum> infos = new ArrayList<LocationStratum>();
                while ((uri = this.readPoolObject(String.class)) != null) {
                    String language = this.dataSource.readString();
                    int line = this.dataSource.readInt();
                    int startOffset = this.dataSource.readInt();
                    int endOffset = this.dataSource.readInt();
                    infos.add(LocationCache.createStratum(uri, null, language, line, startOffset, endOffset));
                }
                if (infos.isEmpty()) {
                    LocationCache.fileLineStratum(null, -1);
                }
                LocationStackFrame parent = this.readPoolObject(LocationStackFrame.class);
                infos.trimToSize();
                yield LocationCache.createFrame(method, bci, infos, parent);
            }
            case 10 -> {
                int id = this.dataSource.readInt();
                Builder.NodeClass clazz = this.readPoolObject(Builder.NodeClass.class);
                yield new Builder.Node(id, clazz);
            }
            case 1 -> this.dataSource.readString();
            default -> throw new IOException("unknown pool type");
        }, -1L);
    }

    private Object readPropertyObject(String key) throws IOException {
        int type = this.dataSource.readByte();
        switch (type) {
            case 1: {
                return this.dataSource.readInt();
            }
            case 2: {
                return this.dataSource.readLong();
            }
            case 4: {
                return Float.valueOf(this.dataSource.readFloat());
            }
            case 3: {
                return this.dataSource.readDouble();
            }
            case 5: {
                return Boolean.TRUE;
            }
            case 6: {
                return Boolean.FALSE;
            }
            case 0: {
                return this.readPoolObject(Object.class);
            }
            case 7: {
                int subType = this.dataSource.readByte();
                switch (subType) {
                    case 1: {
                        return this.dataSource.readInts();
                    }
                    case 3: {
                        return this.dataSource.readDoubles();
                    }
                    case 0: {
                        return this.readPoolObjects();
                    }
                }
                throw new IOException("Unknown type");
            }
            case 8: {
                this.reporter.pushContext(ContextStrings::propertyGraph, key);
                this.builder.startNestedProperty(key);
                return this.parseGraph("", false);
            }
        }
        throw new IOException("Unknown type");
    }

    private void closeDanglingGroups() throws IOException {
        while (this.folderLevel > 0) {
            this.builder.startRoot();
            this.doCloseGroup();
        }
        this.builder.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphDocument parse() throws IOException {
        this.hashStack.push(null);
        boolean restart = false;
        long start = System.nanoTime();
        try {
            try {
                while (true) {
                    if (this.dataSource.readHeader() && restart) {
                        this.closeDanglingGroups();
                        this.builder.resetStreamData();
                        this.constantPool = this.builder.getConstantPool();
                    }
                    restart = true;
                    if (this.dataSource.getMajorVersion() < 1) {
                        throw new VersionMismatchException("File header is missing");
                    }
                    this.parseRoot();
                }
            }
            catch (EOFException eOFException) {
                this.closeDanglingGroups();
                long l = System.nanoTime();
            }
        }
        catch (Throwable throwable) {
            this.closeDanglingGroups();
            long l = System.nanoTime();
            throw throwable;
        }
        return this.builder.rootDocument();
    }

    protected void beginGroup() throws IOException {
        this.parseGroup();
        ++this.folderLevel;
        this.hashStack.push(null);
        this.builder.startGroupContent();
    }

    private void doCloseGroup() throws IOException {
        if (this.folderLevel-- == 0) {
            throw new IOException("Unbalanced groups");
        }
        this.builder.endGroup();
        this.hashStack.pop();
        this.reporter.popContext();
    }

    protected void parseRoot() throws IOException {
        block12: {
            try {
                this.builder.startRoot();
                int type = this.dataSource.readByte();
                switch (type) {
                    case 1: {
                        this.parseGraph();
                        break;
                    }
                    case 0: {
                        this.beginGroup();
                        break;
                    }
                    case 2: {
                        this.doCloseGroup();
                        break;
                    }
                    case 3: {
                        this.loadDocumentProperties();
                        break;
                    }
                    default: {
                        this.reporter.reportLoadingError(ContextStrings.unknownObjectType(type), this.builder);
                        throw new IOException("unknown root : " + type);
                    }
                }
            }
            catch (SkipRootException ex) {
                long s = ex.getStart();
                long e = ex.getEnd();
                long pos = this.dataSource.getMark();
                ConstantPool pool = ex.getConstantPool();
                if (e == -1L) {
                    throw new EOFException();
                }
                this.instLog.log(Level.FINE, "Skipping to offset {0}, {1} bytes skipped, using cpool", new Object[]{e, e - pos, Integer.toHexString(pool == null ? 0 : System.identityHashCode(pool))});
                assert (s < pos && e >= pos);
                if (pos < e) {
                    int l;
                    long count;
                    byte[] scratch = new byte[(int)Math.min(count, 0x3200000L)];
                    for (count = e - pos; count > 0L; count -= (long)l) {
                        l = (int)Math.min((long)scratch.length, count);
                        this.dataSource.readBytes(scratch, l);
                    }
                }
                if (pool == null) break block12;
                this.setConstantPool(pool);
            }
        }
    }

    protected Group parseGroup() throws IOException {
        this.reporter.pushInitialContext(ContextStrings::firstGroup);
        Group group = this.builder.startGroup();
        String name = this.readPoolObject(String.class);
        String shortName = this.readPoolObject(String.class);
        this.reporter.updateContext(name);
        Method method = this.readPoolObject(Method.class);
        int bci = this.dataSource.readInt();
        this.builder.setGroupName(name, shortName);
        this.parseProperties();
        this.builder.setMethod(name, shortName, bci, method);
        return group;
    }

    private InputGraph parseGraph() throws IOException {
        this.reporter.pushInitialContext(ContextStrings::firstGraph);
        this.nameTranslator = this.builder.prepareNameTranslator();
        if (this.dataSource.getMajorVersion() < 2) {
            String title = this.readPoolObject(String.class);
            this.reporter.updateContext(title);
            return this.parseGraph(title, true);
        }
        int dumpId = this.dataSource.readInt();
        String format = this.dataSource.readString();
        int argsCount = this.dataSource.readInt();
        Object[] args = new Object[argsCount];
        StringBuilder sb = new StringBuilder(format);
        sb.append("{");
        if (this.dataSource.getMajorVersion() == 2) {
            for (int i = 0; i < argsCount; ++i) {
                args[i] = this.readPoolObject(Object.class);
                sb.append(args[i]);
                sb.append(", ");
            }
        } else {
            for (int i = 0; i < argsCount; ++i) {
                args[i] = this.readPropertyObject(null);
                sb.append(args[i]);
                sb.append(", ");
            }
        }
        sb.append("}");
        this.reporter.updateContext(sb.toString());
        return this.parseGraph(dumpId, format, args, true);
    }

    private void parseProperties() throws IOException {
        this.reporter.pushContext(ContextStrings::properties);
        this.parseProperties(this.builder::setProperty);
        this.reporter.popContext();
    }

    private void parseProperties(BiConsumer<String, Object> propertyConsumer) throws IOException {
        int propCount = this.dataSource.readShort();
        if (this.dataSource.getMajorVersion() > 7) {
            propCount = propCount == 65535 ? this.dataSource.readInt() : propCount;
        }
        this.builder.setPropertySize(propCount);
        for (int j = 0; j < propCount; ++j) {
            String key = this.readPoolObject(String.class);
            this.reporter.pushContext(ContextStrings::inProperty, key);
            Object value = this.readPropertyObject(key);
            propertyConsumer.accept(key, value);
            this.reporter.popContext();
        }
    }

    private void computeGraphDigest() {
        byte[] d = this.dataSource.finishDigest();
        this.builder.graphContentDigest(d);
        this.hashStack.pop();
        this.hashStack.push(d);
    }

    private InputGraph parseGraph(String title, boolean toplevel) throws IOException {
        int index = title.indexOf(":");
        if (index == -1) {
            return this.parseGraph(-1, title, new Object[0], toplevel);
        }
        return this.parseGraph(Integer.parseInt(title.substring(0, index)), title.substring(index + 1).trim(), new Object[0], toplevel);
    }

    private InputGraph parseGraph(int dumpId, String format, Object[] args, boolean toplevel) throws IOException {
        long start = System.nanoTime();
        InputGraph g = this.builder.startGraph(dumpId, format, args);
        try {
            this.parseProperties();
            this.reporter.setDetail(ContextStrings::nodes);
            this.builder.startGraphContents(g);
            this.dataSource.startDigest();
            this.parseNodes();
            this.reporter.setDetail(ContextStrings::blocks);
            this.parseBlocks();
            if (toplevel) {
                this.computeGraphDigest();
            }
        }
        catch (SkipRootException ex) {
            throw ex;
        }
        catch (IOException | Error | RuntimeException ex) {
            this.reporter.reportLoadingError(ContextStrings.loadingGraphErrorMessage(ex.toString()), this.builder);
            throw ex;
        }
        finally {
            this.reporter.popContext();
            g = this.builder.endGraph();
            long l = System.nanoTime();
        }
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBlocks() throws IOException {
        try {
            int blockCount = this.dataSource.readInt();
            for (int i = 0; i < blockCount; ++i) {
                int id = this.dataSource.readInt();
                this.reporter.pushContext(ContextStrings::inBlock, id);
                this.builder.startBlock(id);
                int nodeCount = this.dataSource.readInt();
                for (int j = 0; j < nodeCount; ++j) {
                    int nodeId = this.dataSource.readInt();
                    if (nodeId < 0) continue;
                    this.builder.addNodeToBlock(nodeId);
                }
                this.builder.endBlock(id);
                int edgeCount = this.dataSource.readInt();
                for (int j = 0; j < edgeCount; ++j) {
                    int to = this.dataSource.readInt();
                    this.builder.addBlockEdge(id, to);
                }
                this.reporter.popContext();
            }
        }
        finally {
            this.builder.makeBlockEdges();
        }
    }

    private void createEdges(int id, int startNum, List<? extends Builder.Port> portList, EdgeBuilder factory) throws IOException {
        int portNum = 0;
        for (Builder.Port port : portList) {
            if (port.isList) {
                int size = this.dataSource.readShort();
                for (int j = 0; j < size; ++j) {
                    int in = this.dataSource.readInt();
                    port.ids.add(in);
                    factory.edge(port, in, id, (char)(startNum + portNum), j);
                    ++portNum;
                }
            } else {
                int in = this.dataSource.readInt();
                port.ids.add(in);
                factory.edge(port, in, id, (char)(startNum + portNum), -1);
                ++portNum;
            }
            port.ids = new ArrayList<Integer>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseNodes() throws IOException {
        try {
            int count = this.dataSource.readInt();
            for (int i = 0; i < count; ++i) {
                int id = this.dataSource.readInt();
                this.reporter.pushContext(ContextStrings::inNode, id);
                Builder.NodeClass nodeClass = this.readPoolObject(Builder.NodeClass.class);
                int preds = this.dataSource.readByte();
                this.builder.startNode(id, preds > 0, nodeClass);
                this.reporter.setDetail(ContextStrings::nodeProperties);
                this.parseProperties(this.builder::setNodeProperty);
                this.reporter.setDetail(ContextStrings::edges);
                this.createEdges(id, preds, nodeClass.inputs, this.builder::inputEdge);
                this.createEdges(id, 0, nodeClass.sux, this.builder::successorEdge);
                this.builder.setNodeName(nodeClass);
                this.builder.endNode(id);
                this.reporter.popContext();
            }
        }
        finally {
            this.builder.makeGraphEdges();
        }
    }

    protected void loadDocumentProperties() throws IOException {
        if (this.dataSource.getMajorVersion() < 7) {
            throw new IllegalStateException("Document properties unexpected in version < 7");
        }
        try {
            this.builder.startDocumentHeader();
            this.parseProperties();
        }
        finally {
            this.builder.endDocumentHeader();
        }
    }

    @Override
    public final ConstantPool getConstantPool() {
        return this.constantPool;
    }

    @Override
    public void setConstantPool(ConstantPool cp) {
        this.constantPool = cp;
    }

    private static final class ErrorReporter {
        private final List<Supplier<String>> namesStack = new ArrayList<Supplier<String>>();
        private Supplier<String> lastName = null;
        private Supplier<String> detail = null;

        private ErrorReporter() {
        }

        public static Supplier<String> initialFollowing(Supplier<String> lastName) {
            return () -> String.format("< after %s >", lastName.get());
        }

        public static String addDetail(String message, Supplier<String> detail) {
            return String.format("%s during %s", message, detail.get());
        }

        public static String addPreceding(String message, Supplier<String> lastName) {
            return String.format("%s. Previous object: %s", message, lastName.get());
        }

        public void pushInitialContext(Supplier<String> init) {
            if (this.lastName == null) {
                this.pushContext(init);
            } else {
                this.pushContext(ErrorReporter.initialFollowing(this.lastName));
                this.lastName = null;
            }
        }

        public void pushContext(Function<Object, String> messageFactory, Object messageDetail) {
            this.pushContext(() -> (String)messageFactory.apply(messageDetail));
        }

        public void pushContext(Supplier<String> n) {
            this.namesStack.add(n);
            this.detail = null;
        }

        public void updateContext(String n) {
            this.namesStack.set(this.namesStack.size() - 1, () -> n);
            this.lastName = null;
        }

        public void popContext() {
            this.lastName = this.namesStack.remove(this.namesStack.size() - 1);
            this.detail = null;
        }

        public void setDetail(Supplier<String> messageFactory) {
            this.detail = messageFactory;
        }

        public void reportLoadingError(String message, Builder builder) {
            ArrayList<String> parents = new ArrayList<String>();
            String detailedMessage = message;
            try {
                for (Supplier<String> c : this.namesStack) {
                    parents.add(c.get());
                }
                if (this.detail != null) {
                    detailedMessage = ErrorReporter.addDetail(detailedMessage, this.detail);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            if (this.lastName != null) {
                detailedMessage = ErrorReporter.addPreceding(detailedMessage, this.lastName);
            }
            builder.reportLoadingError(detailedMessage, parents);
        }
    }

    public static final class EnumKlass
    extends Klass {
        public final String[] values;
        public final EnumValue[] enums;
        private volatile int hashCode = 0;

        public EnumKlass(String name, String[] values) {
            super(name);
            this.values = values;
            this.enums = new EnumValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.enums[i] = new EnumValue(this, i);
            }
        }

        EnumValue get(int ordinal) {
            if (ordinal >= 0 && ordinal < this.enums.length) {
                return this.enums[ordinal];
            }
            return new EnumValue(this, ordinal);
        }

        @Override
        public int hashCode() {
            int h = this.hashCode;
            if (h == 0) {
                this.hashCode = h = Objects.hash(super.hashCode(), Arrays.hashCode(this.values));
            }
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            EnumKlass other = (EnumKlass)obj;
            return Arrays.equals(this.values, other.values);
        }
    }

    public static final class EnumValue
    implements Builder.LengthToString {
        public EnumKlass enumKlass;
        public int ordinal;

        EnumValue(EnumKlass enumKlass, int ordinal) {
            this.enumKlass = enumKlass;
            this.ordinal = ordinal;
        }

        public String toString() {
            return this.enumKlass.simpleName + "." + this.enumKlass.values[this.ordinal];
        }

        @Override
        public String toString(Builder.Length l) {
            switch (l) {
                case S: {
                    return this.enumKlass.values[this.ordinal];
                }
            }
            return this.toString();
        }

        public int hashCode() {
            return (this.ordinal + 7) * 13 ^ this.enumKlass.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumValue other = (EnumValue)obj;
            if (this.ordinal != other.ordinal) {
                return false;
            }
            return Objects.equals(this.enumKlass, other.enumKlass);
        }
    }

    public static final class Method
    extends Member {
        public final Signature signature;
        public final byte[] code;

        public Method(String name, Signature signature, byte[] code, Klass holder, int accessFlags) {
            super(holder, name, accessFlags);
            this.signature = signature;
            this.code = code;
        }

        public String toString() {
            int sz = 0;
            for (int i = 0; i < this.signature.argTypes.length; ++i) {
                sz += 1 + this.signature.argTypes[i].length();
            }
            StringBuilder sb = new StringBuilder((sz += this.name.length()) + 4);
            sb.append(this.holder).append('.').append(this.name).append('(');
            for (int i = 0; i < this.signature.argTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.signature.argTypes[i]);
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public String toString(Builder.Length l) {
            switch (l) {
                case M: {
                    return this.holder.toString(Builder.Length.L) + "." + this.name;
                }
                case S: {
                    return this.holder.toString(Builder.Length.S) + "." + this.name;
                }
            }
            return this.toString();
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = 79 * hash + Objects.hashCode(this.signature);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            Method other = (Method)obj;
            if (!Objects.equals(this.signature, other.signature)) {
                return false;
            }
            return Arrays.equals(this.code, other.code);
        }
    }

    public static final class Field
    extends Member {
        public final String type;

        public Field(String type, Klass holder, String name, int accessFlags) {
            super(holder, name, accessFlags);
            this.type = type;
        }

        public String toString() {
            return this.holder + "." + this.name;
        }

        @Override
        public String toString(Builder.Length l) {
            switch (l) {
                case M: {
                    return this.holder.toString(Builder.Length.L) + "." + this.name;
                }
                case S: {
                    return this.holder.toString(Builder.Length.S) + "." + this.name;
                }
            }
            return this.toString();
        }
    }

    public static final class Signature {
        public final String returnType;
        public final String[] argTypes;
        private final int hash;

        public Signature(String returnType, String[] argTypes) {
            this.returnType = returnType;
            this.argTypes = argTypes;
            this.hash = this.toString().hashCode();
        }

        public String toString() {
            return "Signature(" + this.returnType + ":" + Arrays.toString(this.argTypes) + ")";
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Signature other = (Signature)obj;
            if (!Objects.equals(this.returnType, other.returnType)) {
                return false;
            }
            return Arrays.equals(this.argTypes, other.argTypes);
        }
    }

    public static class Klass
    implements Builder.LengthToString {
        public final String name;
        public final String simpleName;
        private final int hash;

        public Klass(String name) {
            String simple;
            this.name = name;
            try {
                simple = name.substring(name.lastIndexOf(46) + 1);
            }
            catch (IndexOutOfBoundsException e) {
                simple = name;
            }
            this.simpleName = simple;
            this.hash = (simple + "#" + name).hashCode();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String toString(Builder.Length l) {
            switch (l) {
                case S: {
                    return this.simpleName;
                }
            }
            return this.toString();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Klass other = (Klass)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.simpleName, other.simpleName);
        }
    }

    private static final class ContextStrings {
        private ContextStrings() {
        }

        private static String propertyGraph(Object s) {
            return String.format("Property %s graph", s);
        }

        private static String unknownObjectType(int i) {
            return String.format("Binary stream corrupted, unknown root object type: %d", i);
        }

        private static String firstGroup() {
            return "<first group>";
        }

        private static String firstGraph() {
            return "<first graph>";
        }

        private static String properties() {
            return "Properties";
        }

        private static String inProperty(Object key) {
            return String.format("Property %s", key);
        }

        private static String nodes() {
            return "Nodes";
        }

        private static String blocks() {
            return "Blocks";
        }

        private static String loadingGraphErrorMessage(String message) {
            return String.format("Corrupted graph data: %s, loading terminated", message);
        }

        private static String inBlock(Object id) {
            return String.format("Block %s", id);
        }

        private static String inNode(Object id) {
            return String.format("Node %s", id);
        }

        private static String nodeProperties() {
            return "Node properties";
        }

        private static String edges() {
            return "Edges";
        }
    }

    static interface EdgeBuilder {
        public void edge(Builder.Port var1, int var2, int var3, char var4, int var5);
    }

    public static abstract class Member
    implements Builder.LengthToString {
        public final Klass holder;
        public final int accessFlags;
        public final String name;

        private Member(Klass holder, String name, int accessFlags) {
            assert (holder != null) : "GraphElements.methodDeclaringClass must not return null!";
            assert (name != null);
            this.holder = holder;
            this.accessFlags = accessFlags;
            this.name = name;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + Objects.hashCode(this.holder);
            hash = 29 * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.holder, other.holder);
        }
    }
}

