/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;

public final class BGVUrlParser {
    public static ParsedBGVUrl parse(String url) {
        String pathPart;
        if (!url.startsWith("bgv://")) {
            throw new IllegalArgumentException("URL must start with bgv://");
        }
        String withoutScheme = url.substring(6);
        int firstSlash = withoutScheme.indexOf(47);
        if (firstSlash < 0) {
            throw new IllegalArgumentException("No path in BGV URL: " + url);
        }
        String filePart = URLDecoder.decode(withoutScheme.substring(0, firstSlash), StandardCharsets.UTF_8);
        String pathAndQuery = withoutScheme.substring(firstSlash + 1);
        String queryPart = null;
        int qidx = pathAndQuery.indexOf(63);
        if (qidx >= 0) {
            pathPart = pathAndQuery.substring(0, qidx);
            queryPart = pathAndQuery.substring(qidx + 1);
        } else {
            pathPart = pathAndQuery;
        }
        String[] rawSegments = pathPart.split("/");
        ArrayList<PathSegment> segments = new ArrayList<PathSegment>();
        for (String raw : rawSegments) {
            segments.add(BGVUrlParser.parseSegment(raw));
        }
        NodeSelector selector = BGVUrlParser.parseNodeSelector(queryPart);
        return new ParsedBGVUrl(filePart, segments, selector);
    }

    private static PathSegment parseSegment(String text) {
        int idx;
        int close;
        String decoded = URLDecoder.decode(text, StandardCharsets.UTF_8);
        int bracket = decoded.lastIndexOf(91);
        int n = close = decoded.endsWith("]") ? decoded.length() - 1 : -1;
        if (bracket < 0 || close < 0 || bracket >= close) {
            throw new IllegalArgumentException("Malformed segment: " + text);
        }
        String name = decoded.substring(0, bracket);
        String idxStr = decoded.substring(bracket + 1, close);
        try {
            idx = Integer.parseInt(idxStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Malformed index in segment: " + text);
        }
        return new PathSegment(name, idx);
    }

    private static NodeSelector parseNodeSelector(String query) {
        if (query == null) {
            return null;
        }
        String trimmed = query.trim();
        if (trimmed.startsWith("get=")) {
            String[] parts = trimmed.substring(4).split(",");
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (String p : parts) {
                if (p.isEmpty()) continue;
                try {
                    ids.add(Integer.parseInt(p.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new NodeSelector(Collections.unmodifiableList(ids));
        }
        return null;
    }

    public static Object resolve(GraphDocument root, String url) {
        ParsedBGVUrl parsed = BGVUrlParser.parse(url);
        List<? extends FolderElement> current = root.getElements();
        FolderElement result = null;
        for (PathSegment seg : parsed.segments) {
            String nodeName;
            if (seg.index < 0 || seg.index >= current.size()) {
                throw new IllegalStateException("Index " + seg.index + " out of bounds for parent with " + current.size() + " children while resolving '" + seg + "'");
            }
            if (!Objects.equals(seg.name == null ? "" : seg.name, (nodeName = (result = current.get(seg.index)).getName()) == null ? "" : nodeName)) {
                throw new IllegalStateException("Name mismatch at segment '" + seg + "': expected '" + seg.name + "', found '" + nodeName + "'");
            }
            if (result instanceof Folder) {
                current = ((Folder)result).getElements();
                continue;
            }
            if (seg == parsed.segments.get(parsed.segments.size() - 1)) continue;
            throw new IllegalStateException("Non-terminal segment does not point to Folder: " + seg);
        }
        if (parsed.nodeSelector != null) {
            if (!(result instanceof InputGraph)) {
                throw new IllegalStateException("InputNode selection requested but last segment does not resolve to InputGraph");
            }
            InputGraph graph = (InputGraph)result;
            ArrayList<InputNode> nodes = new ArrayList<InputNode>();
            for (Integer id : parsed.nodeSelector.nodeIds) {
                InputNode node = graph.getNode(id);
                if (node == null) {
                    throw new IllegalStateException("InputNode with ID " + id + " not found in InputGraph");
                }
                nodes.add(node);
            }
            return nodes;
        }
        return result;
    }

    public static final class PathSegment {
        public final String name;
        public final int index;

        public PathSegment(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return (this.name == null ? "" : this.name) + "[" + this.index + "]";
        }
    }

    public static final class NodeSelector {
        public final List<Integer> nodeIds;

        NodeSelector(List<Integer> nodeIds) {
            this.nodeIds = nodeIds;
        }
    }

    public static final class ParsedBGVUrl {
        public final String file;
        public final List<PathSegment> segments;
        public final NodeSelector nodeSelector;

        ParsedBGVUrl(String file, List<PathSegment> segments, NodeSelector nodeSelector) {
            this.file = file;
            this.segments = segments;
            this.nodeSelector = nodeSelector;
        }
    }
}

