/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import jdk.graal.compiler.graphio.parsing.model.AbstractMutableDocumentItem;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.DumpedElement;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputMethod;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;

public class Group
extends AbstractMutableDocumentItem<Group>
implements ChangedEventProvider<Group>,
GraphContainer,
Folder,
FolderElement,
DumpedElement {
    private final List<FolderElement> elements;
    private final List<InputGraph> graphs;
    private InputMethod method;
    private final transient Object id;
    private final transient ChangedEvent<Group> changedEvent;
    private final transient ChangedEvent<Group> propertyChangedEvent;
    private Folder parent;
    static final AtomicLong uniqueIDGenerator = new AtomicLong(1L);

    public Group(Folder parent) {
        this(parent, null);
    }

    public Group(Folder parent, Object id) {
        super(Properties.newProperties("name", "", "type", ""));
        this.id = id == null ? Long.valueOf(uniqueIDGenerator.getAndIncrement()) : id;
        this.elements = new ArrayList<FolderElement>();
        this.graphs = new ArrayList<InputGraph>();
        this.parent = parent;
        this.changedEvent = new ChangedEvent<Group>(this);
        this.propertyChangedEvent = new ChangedEvent<Group>(this);
    }

    @Override
    public ChangedEvent<Group> getPropertyChangedEvent() {
        return this.propertyChangedEvent;
    }

    @Override
    public Group getContentOwner() {
        return this;
    }

    boolean isPlaceholderGroup() {
        return this.parent == null;
    }

    @Override
    public Object getID() {
        return this.id;
    }

    public void fireChangedEvent() {
        this.changedEvent.fire();
    }

    public void setMethod(InputMethod method) {
        this.method = method;
    }

    public InputMethod getMethod() {
        return this.method;
    }

    @Override
    public ChangedEvent<Group> getChangedEvent() {
        return this.changedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FolderElement> getElements() {
        Group group = this;
        synchronized (group) {
            return List.copyOf(this.getElementsInternal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGraphsCount() {
        Group group = this;
        synchronized (group) {
            return this.graphs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElement(FolderElement element) {
        Group group = this;
        synchronized (group) {
            this.elements.add(element);
            if (element instanceof InputGraph) {
                this.graphs.add((InputGraph)element);
            }
            if (element.getParent() == null) {
                element.setParent(this);
            }
        }
        this.changedEvent.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElements(List<? extends FolderElement> newElements) {
        if (newElements.isEmpty()) {
            return;
        }
        Group group = this;
        synchronized (group) {
            for (FolderElement folderElement : newElements) {
                this.elements.add(folderElement);
                if (folderElement instanceof InputGraph) {
                    this.graphs.add((InputGraph)folderElement);
                }
                if (folderElement.getParent() != null) continue;
                folderElement.setParent(this);
            }
        }
        this.changedEvent.fire();
        GraphDocument owner = this.getOwner();
        if (owner != null) {
            owner.fireDataAdded(new ArrayList<FolderElement>(newElements));
        }
    }

    protected List<? extends FolderElement> getElementsInternal() {
        return this.elements;
    }

    @Override
    public Set<Integer> getChildNodeIds() {
        LinkedHashSet<Integer> res = new LinkedHashSet<Integer>();
        for (InputGraph g : this.getGraphs()) {
            res.addAll(g.getNodeIds());
        }
        return res;
    }

    @Override
    public Set<InputNode> getChildNodes() {
        LinkedHashSet<InputNode> res = new LinkedHashSet<InputNode>();
        for (InputGraph g : this.getGraphs()) {
            res.addAll(g.getNodes());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Group@").append(Integer.toHexString(System.identityHashCode(this))).append(this.getProperties()).append("\n");
        Group group = this;
        synchronized (group) {
            for (FolderElement folderElement : this.getElementsInternal()) {
                sb.append(folderElement.toString());
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getProperties().get("name", String.class);
    }

    @Override
    public String getType() {
        return this.getProperties().get("type", String.class);
    }

    @Override
    public boolean accept(InputGraph g) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputGraph getPrev(InputGraph graph) {
        InputGraph lastGraph = null;
        Group group = this;
        synchronized (group) {
            for (FolderElement folderElement : this.getElementsInternal()) {
                InputGraph candidate;
                if (folderElement == graph) {
                    return lastGraph;
                }
                if (!(folderElement instanceof InputGraph) || !Objects.equals((candidate = (InputGraph)folderElement).getGraphType(), graph.getGraphType())) continue;
                lastGraph = candidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputGraph getNext(InputGraph graph) {
        boolean found = false;
        Group group = this;
        synchronized (group) {
            for (FolderElement folderElement : this.getElementsInternal()) {
                InputGraph candidate;
                if (folderElement == graph) {
                    found = true;
                    continue;
                }
                if (!found || !(folderElement instanceof InputGraph) || !Objects.equals((candidate = (InputGraph)folderElement).getGraphType(), graph.getGraphType())) continue;
                return candidate;
            }
        }
        return null;
    }

    @Override
    public InputGraph getLastGraph() {
        List<InputGraph> l = this.getGraphs();
        return l.get(l.size() - 1);
    }

    @Override
    public Folder getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElement(FolderElement element) {
        Group group = this;
        synchronized (group) {
            if (!this.elements.remove(element)) {
                return;
            }
            if (element instanceof InputGraph) {
                this.graphs.remove(element);
            }
        }
        this.changedEvent.fire();
        this.notifyContentRemoved(Collections.singleton(element));
    }

    protected void notifyContentRemoved(Collection<? extends FolderElement> removed) {
        GraphDocument gd = this.getOwner();
        if (gd != null) {
            gd.fireDataRemoved(removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Group group = this;
        synchronized (group) {
            if (this.elements.isEmpty()) {
                return;
            }
            this.elements.clear();
            this.graphs.clear();
        }
        this.changedEvent.fire();
    }

    @Override
    public synchronized List<InputGraph> getGraphs() {
        return new ArrayList<InputGraph>(this.graphs);
    }

    @Override
    public void setParent(Folder parent) {
        this.parent = parent;
    }

    @Override
    public boolean isNodeChanged(InputGraph base, InputGraph to, int nodeId) {
        List<InputGraph> inputGraphs = this.getGraphs();
        int fromIndex = inputGraphs.indexOf(base);
        int toIndex = inputGraphs.indexOf(to);
        assert (fromIndex != -1 && toIndex >= fromIndex);
        if (fromIndex == toIndex) {
            return false;
        }
        for (int i = fromIndex + 1; i <= toIndex; ++i) {
            InputGraph g = inputGraphs.get(i);
            if (g.isDuplicate() || !g.isNodeChanged(nodeId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isParentOf(FolderElement other) {
        for (FolderElement f = other; f != null; f = f.getParent()) {
            if (f != this) continue;
            return true;
        }
        return false;
    }

    public static interface Feedback {
        public void reportProgress(int var1, int var2, String var3);

        public boolean isCancelled();

        public void finish();

        public void reportError(List<FolderElement> var1, List<String> var2, String var3, String var4);
    }

    public static interface LazyContent<T> {
        public boolean isComplete();

        public Future<T> completeContents(Feedback var1);

        public T partialData();
    }
}

