/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;

public final class InputBlock {
    public static final String NO_BLOCK_NAME = "(no block)";
    private final List<InputNode> nodes;
    private final String name;
    private final InputGraph graph;
    private final Set<InputBlock> successors;

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputBlock)) {
            return false;
        }
        InputBlock b = (InputBlock)o;
        boolean bl = result = b.nodes.equals(this.nodes) && b.name.equals(this.name) && b.successors.size() == this.successors.size();
        if (!result) {
            return false;
        }
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (InputBlock succ : this.successors) {
            s.add(succ.name);
        }
        for (InputBlock succ : b.successors) {
            if (s.contains(succ.name)) continue;
            return false;
        }
        return true;
    }

    InputBlock(InputGraph graph, String name) {
        this.graph = graph;
        this.name = name;
        this.nodes = new ArrayList<InputNode>();
        this.successors = new LinkedHashSet<InputBlock>(2);
    }

    public String getName() {
        return this.name;
    }

    public List<InputNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public void addNode(int id) {
        InputNode node = this.graph.getNode(id);
        assert (node != null);
        assert (this.graph.getBlock(id) == null) : "duplicate : " + node;
        this.graph.setBlock(node, this);
        this.nodes.add(node);
    }

    public Set<InputBlock> getSuccessors() {
        return Collections.unmodifiableSet(this.successors);
    }

    public String toString() {
        return "Block " + this.getName();
    }

    void addSuccessor(InputBlock b) {
        this.successors.add(b);
    }
}

