/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.Objects;
import java.util.WeakHashMap;

public class InputEdge {
    public static final String SUCCESSOR_EDGE_TYPE = "Successor";
    public static final Comparator<InputEdge> OUTGOING_COMPARATOR = Comparator.comparingInt(InputEdge::getFromIndex).thenComparingInt(InputEdge::getTo);
    public static final Comparator<InputEdge> INGOING_COMPARATOR = Comparator.comparingInt(InputEdge::getToIndex).thenComparingInt(InputEdge::getFrom);
    private final char toIndex;
    private final char fromIndex;
    private final int from;
    private final int to;
    private final int listIndex;
    private final String label;
    private final String type;
    private State state;
    private int hashCode = -1;
    static WeakHashMap<InputEdge, WeakReference<InputEdge>> immutableCache = new WeakHashMap();

    public InputEdge(char toIndex, int from, int to) {
        this('\u0000', toIndex, from, to, null, null);
    }

    public InputEdge(char fromIndex, char toIndex, int from, int to) {
        this(fromIndex, toIndex, from, to, null, null);
    }

    public InputEdge(char fromIndex, char toIndex, int from, int to, String label, String type) {
        this(fromIndex, toIndex, from, to, -1, label, type, State.SAME);
    }

    public InputEdge(char fromIndex, char toIndex, int from, int to, int listIndex, String label, String type) {
        this(fromIndex, toIndex, from, to, listIndex, label, type, State.SAME);
    }

    public static synchronized InputEdge createImmutable(char fromIndex, char toIndex, int from, int to, int listIndex, String label, String type) {
        InputEdge edge2;
        InputEdge edge = new InputEdge(fromIndex, toIndex, from, to, listIndex, label, type, State.IMMUTABLE);
        WeakReference<InputEdge> result = immutableCache.get(edge);
        if (result != null && (edge2 = (InputEdge)result.get()) != null) {
            return edge2;
        }
        immutableCache.put(edge, new WeakReference<InputEdge>(edge));
        return edge;
    }

    public InputEdge(char fromIndex, char toIndex, int from, int to, int listIndex, String label, String type, State state) {
        this.toIndex = toIndex;
        this.fromIndex = fromIndex;
        this.from = from;
        this.to = to;
        this.listIndex = listIndex;
        this.state = state;
        this.label = label;
        this.type = type;
        int hash = Objects.hash(from, to, Character.valueOf(fromIndex), Character.valueOf(toIndex), listIndex);
        if (state == State.IMMUTABLE) {
            hash = Objects.hash(hash, label);
        }
        this.hashCode = hash;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State x) {
        if (x == this.state) {
            return;
        }
        if (this.state == State.IMMUTABLE) {
            throw new InternalError("Can't change immutable instances");
        }
        this.state = x;
        if (this.state == State.IMMUTABLE) {
            this.hashCode = Objects.hash(this.hashCode, this.label);
        }
    }

    public char getToIndex() {
        return this.toIndex;
    }

    public char getFromIndex() {
        return this.fromIndex;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getListIndex() {
        return this.listIndex;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDisplayLabel() {
        Object ret = this.getLabel();
        if (this.listIndex >= 0) {
            ret = (String)ret + "[" + this.listIndex + "]";
        }
        return ret;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        boolean result;
        if (!(o instanceof InputEdge)) {
            return false;
        }
        InputEdge conn2 = (InputEdge)o;
        boolean bl = result = conn2.fromIndex == this.fromIndex && conn2.toIndex == this.toIndex && conn2.from == this.from && conn2.to == this.to && conn2.listIndex == this.listIndex;
        if (result && (this.state == State.IMMUTABLE || conn2.state == State.IMMUTABLE)) {
            return conn2.state == this.state && conn2.label.equals(this.label);
        }
        return result;
    }

    public String toString() {
        return "Edge from " + this.from + " to " + this.to + "(" + this.fromIndex + ", " + this.toIndex + ") ";
    }

    public int hashCode() {
        assert (this.hashCode != -1);
        return this.hashCode;
    }

    public static enum State {
        IMMUTABLE,
        SAME,
        NEW,
        DELETED;

    }
}

