/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jdk.graal.compiler.graphio.parsing.NameTranslator;
import org.graalvm.visualizer.settings.graal.GraalSettings;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public final class BinaryMap
implements NameTranslator,
PreferenceChangeListener {
    private static final Logger LOG = Logger.getLogger(BinaryMap.class.getName());
    private static final BinaryMap INSTANCE = new BinaryMap();
    private volatile Map<String, String> map;
    private volatile Cache cache;
    private final Map<String, String> versions = Collections.synchronizedMap(new HashMap());

    public static BinaryMap versions() {
        return new BinaryMap(INSTANCE.cache());
    }

    private BinaryMap() {
        GraalSettings.obtain().addPreferenceChangeListener((PreferenceChangeListener)this);
        this.cache = null;
    }

    private BinaryMap(Cache cache) {
        this.cache = cache;
    }

    @Override
    public String translate(String fqn) {
        Map<String, String> m = this.map();
        return m.get(fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> map() {
        if (this.map == null) {
            HashMap<String, String> copy;
            Map<String, String> map = this.versions;
            synchronized (map) {
                copy = new HashMap<String, String>(this.versions);
            }
            Map<String, String> tmp = this.cache().prepareMap(copy);
            this.map = tmp;
            return this.map;
        }
        return this.map;
    }

    private Cache cache() {
        if (this.cache == null) {
            Cache newCache;
            ArrayList<URI> urls = new ArrayList<URI>();
            ArrayList<File> files = new ArrayList<File>();
            GraalSettings settings = GraalSettings.obtain();
            settings.getFileMap().stream().map(s -> new File((String)s)).filter(f -> f.exists()).forEach(files::add);
            try {
                String repo = (String)settings.get(String.class, "repository");
                urls.add(new URI(repo));
            }
            catch (URISyntaxException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            this.cache = newCache = new Cache(urls, files);
            return newCache;
        }
        return this.cache;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals("map")) {
            this.cache = null;
        }
    }

    public void request(String component, String version) {
        this.versions.put(component, version);
        this.map = null;
    }

    static final class Cache {
        private static final Map<String, String> NONE = new HashMap<String, String>();
        private final Map<URI, Map<String, String>> cache = new HashMap<URI, Map<String, String>>();
        private final List<URI> urls;
        private final Map<File, Map<String, String>> files;

        Cache(List<URI> urls, List<File> files) {
            this.urls = urls;
            this.files = new HashMap<File, Map<String, String>>();
            for (File f : files) {
                try (BufferedReader r = new BufferedReader(new FileReader(f));){
                    this.files.put(f, this.parseMappings(r));
                }
                catch (IOException ex) {
                    this.files.put(f, NONE);
                }
            }
        }

        private Map<String, String> parseMappings(BufferedReader r) throws IOException {
            String line;
            HashMap<String, String> fillIn = new HashMap<String, String>();
            while ((line = r.readLine()) != null) {
                int arrow;
                if (line.startsWith(" ")) continue;
                if (line.endsWith(":")) {
                    line = line.substring(0, line.length() - 1);
                }
                if ((arrow = line.indexOf("->")) == -1) continue;
                String before = line.substring(0, arrow).trim();
                String after = line.substring(arrow + 2).trim();
                fillIn.put(after, before);
            }
            return fillIn;
        }

        Map<String, String> prepareMap(Map<String, String> versions) {
            HashMap<String, String> fillIn = new HashMap<String, String>();
            for (URI uRI : this.urls) {
                if (!uRI.isAbsolute()) continue;
                for (Map.Entry<String, String> entry : versions.entrySet()) {
                    String version;
                    String component = entry.getKey();
                    URI uri = this.resolveURI(uRI, component, version = entry.getValue(), null);
                    Map<String, String> found = this.cache.get(uri);
                    if (found == null) {
                        found = this.readFromMaven(uri, uRI, component, version);
                        this.cache.put(uri, found);
                    }
                    fillIn.putAll(found);
                }
            }
            for (Map.Entry entry : this.files.entrySet()) {
                fillIn.putAll((Map)entry.getValue());
            }
            return fillIn;
        }

        private Map<String, String> readFromMaven(URI uri, URI root, String component, String version) {
            Map<String, String> map;
            String buildNumber;
            if (uri == null) {
                return NONE;
            }
            URI metaData = uri.resolve("maven-metadata.xml");
            try (InputStream is = metaData.toURL().openStream();){
                DefaultHandler2 parseNumber = new DefaultHandler2(){
                    private Object timestamp;
                    private Object buildNumber;

                    @Override
                    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                        try {
                            InputSource is = new InputSource(new URI(baseURI).resolve(systemId).toString());
                            is.setCharacterStream(new StringReader(""));
                            return is;
                        }
                        catch (URISyntaxException ex) {
                            throw new SAXException(ex);
                        }
                    }

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("timestamp".equals(qName)) {
                            this.timestamp = new StringBuilder();
                        }
                        if ("buildNumber".equals(qName)) {
                            this.buildNumber = new StringBuilder();
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.timestamp instanceof StringBuilder) {
                            this.append(this.timestamp, ch, start, length);
                        }
                        if (this.buildNumber instanceof StringBuilder) {
                            this.append(this.buildNumber, ch, start, length);
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (this.timestamp != null) {
                            this.timestamp = this.timestamp.toString();
                        }
                        if (this.buildNumber != null) {
                            this.buildNumber = this.buildNumber.toString();
                        }
                    }

                    private void append(Object obj, char[] ch, int start, int length) {
                        StringBuilder sb = (StringBuilder)obj;
                        sb.append(ch, start, length);
                    }

                    public String toString() {
                        return this.timestamp + "-" + this.buildNumber;
                    }
                };
                SAXParserFactory f = SAXParserFactory.newInstance();
                SAXParser p = f.newSAXParser();
                p.parse(is, (DefaultHandler)parseNumber);
                buildNumber = parseNumber.toString();
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                LOG.log(Level.INFO, "Problems loading " + metaData, ex);
                return NONE;
            }
            URI mapFile = this.resolveURI(root, component, version, buildNumber);
            BufferedReader r = new BufferedReader(new InputStreamReader(mapFile.toURL().openStream()));
            try {
                map = this.parseMappings(r);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Problems loading " + uri, ex);
                    return NONE;
                }
            }
            r.close();
            return map;
        }

        private URI resolveURI(URI root, String component, String version, String buildNumber) {
            try {
                String relative = NbBundle.getMessage(BinaryMap.class, (String)component, (Object)version, (Object)buildNumber);
                URI found = root.resolve(relative);
                return found;
            }
            catch (MissingResourceException ex) {
                LOG.log(Level.FINE, "No mapping for " + component + " component", ex);
                return null;
            }
        }
    }
}

