/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.ConstantPool;
import org.graalvm.visualizer.data.serialization.lazy.GraphMetadata;

class StreamEntry {
    static final int LARGE_ENTRY_THRESHOLD = Integer.getInteger("visualizer.data.serialization.largeEntryLimit", 0x200000);
    private final long start;
    private long end = -1L;
    private final ConstantPool initialPool;
    private ConstantPool skipPool;
    private GraphMetadata graphMeta;
    private final int majorVersion;
    private final int minorVersion;
    private final String contentId;

    public StreamEntry(String contentId, int majorVersion, int minorVersion, long start, ConstantPool initialPool) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.start = start;
        this.initialPool = initialPool;
        this.contentId = contentId;
    }

    String id() {
        return this.contentId;
    }

    synchronized StreamEntry end(long end, ConstantPool skipPool) {
        this.end = end;
        this.skipPool = skipPool;
        this.notifyAll();
        return this;
    }

    synchronized boolean isFinished() {
        return this.end != -1L;
    }

    void beforeWait() {
    }

    StreamEntry setMetadata(GraphMetadata meta) {
        this.graphMeta = meta;
        return this;
    }

    public long getStart() {
        return this.start;
    }

    public synchronized long getEnd() {
        return this.end;
    }

    public long unfinishedSize() {
        if (this.isFinished()) {
            return this.end - this.start;
        }
        return -1L;
    }

    public synchronized long size() {
        if (!this.isFinished()) {
            return Long.MAX_VALUE;
        }
        return this.end - this.start;
    }

    public ConstantPool getInitialPool() {
        return this.initialPool;
    }

    public synchronized ConstantPool getSkipPool() {
        return this.skipPool;
    }

    public GraphMetadata getGraphMeta() {
        return this.graphMeta;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        return "StreamEntry[" + this.contentId + ":" + this.getStart() + "(" + Integer.toHexString(System.identityHashCode(this.getInitialPool())) + ")-" + this.getEnd() + "(" + Integer.toHexString(System.identityHashCode(this.getInitialPool())) + ")]";
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamEntry other = (StreamEntry)obj;
        if (this.start != other.start) {
            return false;
        }
        return Objects.equals(this.contentId, other.contentId);
    }
}

