/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util;

import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import org.openide.util.Utilities;

public class ListenerSupport {
    private static final Logger LOG = Logger.getLogger(ListenerSupport.class.getName());

    public static <T, U extends T> ChangedListener<U> addWeakListener(ChangedListener<T> delegate, ChangedEvent<U> source) {
        CHLImpl<T, U> l = new CHLImpl<T, U>(delegate, source);
        source.addListener(l);
        return l;
    }

    private static class CHLImpl<T, U extends T>
    extends WeakReference<ChangedListener<T>>
    implements Runnable,
    ChangedListener<U> {
        private final ChangedEvent<U> source;
        private Object sourceData;

        public CHLImpl(ChangedListener<T> delegate, ChangedEvent<U> source) {
            super(delegate, Utilities.activeReferenceQueue());
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(U eventData) {
            ChangedListener l = (ChangedListener)this.get();
            if (l != null) {
                CHLImpl cHLImpl = this;
                synchronized (cHLImpl) {
                    if (this.sourceData == null) {
                        this.sourceData = eventData;
                    } else if (this.sourceData != eventData) {
                        LOG.log(Level.WARNING, "WeakListener for {0} registered to multiple sources; will not unregister from stale data: {1}", new Object[]{l, eventData});
                    }
                }
                l.changed(eventData);
            }
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.source.removeListener((Object)this);
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

