/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.settings.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.graalvm.visualizer.settings.Settings;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public abstract class SettingsPanel<P extends SettingsPanel<P, C>, C extends SettingsOptionsPanelController<P, C>>
extends JPanel {
    protected static final Connector<Boolean, AbstractButton> BOOL = new Connector<Boolean, AbstractButton>(Boolean.class, c -> c.isSelected(), (c, v) -> c.setSelected((boolean)v), (c, l) -> c.addActionListener((ActionListener)l));
    protected static final Connector<Boolean, AbstractButton> NOT = new Connector<Boolean, AbstractButton>(Boolean.class, c -> !c.isSelected(), (c, v) -> c.setSelected(v == false), (c, l) -> c.addActionListener((ActionListener)l));
    protected static final Connector<String, JTextField> STRING = new Connector<String, JTextField>(String.class, c -> c.getText(), (c, v) -> c.setText((String)v), (c, l) -> c.addActionListener((ActionListener)l));
    protected static final Connector<Float, JFormattedTextField> FLOAT = new Connector<Float, JFormattedTextField>(Float.class, c -> (Float)c.getValue(), (c, v) -> c.setValue(v), (c, l) -> c.addActionListener((ActionListener)l));
    protected static final Connector<Integer, JFormattedTextField> INT_FORM = new Connector<Integer, JFormattedTextField>(Integer.class, c -> (Integer)c.getValue(), (c, v) -> c.setValue(v), (c, l) -> c.addActionListener((ActionListener)l));
    protected static final Connector<Integer, JComboBox> INT_COMB = new Connector<Integer, JComboBox>(Integer.class, c -> Integer.parseInt(c.getSelectedItem().toString()), (c, v) -> c.setSelectedItem(v), (c, l) -> c.addActionListener((ActionListener)l));
    private final List<Runnable> loads = new ArrayList<Runnable>();
    private final Map<AbstractButton, Runnable> enables = new HashMap<AbstractButton, Runnable>();
    protected final C controller;
    private boolean reseting = false;

    protected SettingsPanel(C controller) {
        this.controller = (SettingsOptionsPanelController)((Object)Objects.requireNonNull(controller));
    }

    protected abstract Settings getSettings();

    protected void fireChanged() {
        this.getSettings().fireChanged();
    }

    protected boolean isFireChanged() {
        return true;
    }

    protected void settingsChanged() {
        ((SettingsOptionsPanelController)((Object)this.controller)).changed();
        if (!this.reseting && this.isFireChanged()) {
            this.fireChanged();
        }
    }

    protected <T, C extends JComponent> void tie(Connector<T, C> type, C comp, String name) {
        type.attach(comp, e -> {
            type.save(comp, this.getSettings(), name);
            this.settingsChanged();
        });
        this.addLoad(() -> type.load(comp, this.getSettings(), name));
    }

    protected void addLoad(Runnable run) {
        this.loads.add(run);
    }

    protected void load() {
        this.reseting = true;
        this.loads.forEach(action -> action.run());
        this.enables.values().forEach(action -> action.run());
        this.reseting = false;
    }

    protected boolean valid() {
        return true;
    }

    protected void store() {
        this.getSettings().store();
        if (((SettingsOptionsPanelController)((Object)this.controller)).isChanged()) {
            this.fireChanged();
        }
    }

    protected void enables(AbstractButton button, JComponent component) {
        button.addActionListener(e -> this.setEnabledRecursive(component, button.isSelected()));
        this.enables.put(button, () -> this.setEnabledRecursive(component, button.isSelected()));
    }

    protected void disables(AbstractButton button, JComponent component) {
        button.addActionListener(e -> this.setEnabledRecursive(component, !button.isSelected()));
        this.enables.put(button, () -> this.setEnabledRecursive(component, !button.isSelected()));
    }

    protected void setEnabledRecursive(Container container, boolean def) {
        ArrayList<Runnable> mistakes = new ArrayList<Runnable>();
        for (Component c : container.getComponents()) {
            if (c.isEnabled() != def) {
                if (c instanceof Container) {
                    this.setEnabledRecursive((Container)c, def);
                } else {
                    c.setEnabled(def);
                }
            }
            if (!def || !(c instanceof AbstractButton) || !this.enables.containsKey(c)) continue;
            mistakes.add(this.enables.get(c));
        }
        mistakes.forEach(action -> action.run());
        if (container.isEnabled() != def) {
            container.setEnabled(def);
        }
    }

    protected static void setPreferredSizeRecursive(Container container) {
        for (Component c : container.getComponents()) {
            if (!(c instanceof Container)) continue;
            SettingsPanel.setPreferredSizeRecursive((Container)c);
        }
        if (container instanceof JPanel || container instanceof JTabbedPane || container instanceof JScrollPane) {
            container.setPreferredSize(SettingsPanel.calcDims(container));
        }
    }

    private static Dimension calcDims(Container container) {
        Rectangle r = new Rectangle();
        for (Component c : container.getComponents()) {
            r.add(c.getBounds());
        }
        return r.getSize();
    }

    protected static void group(ButtonGroup group, AbstractButton ... buttons) {
        for (AbstractButton button : buttons) {
            group.add(button);
        }
    }

    protected static void setMin(JFormattedTextField ftf, Comparable<?> min) {
        JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
        if (formatter != null && formatter instanceof NumberFormatter) {
            ((NumberFormatter)formatter).setMinimum(min);
        }
    }

    protected static void setMax(JFormattedTextField ftf, Comparable<?> max) {
        JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
        if (formatter != null && formatter instanceof NumberFormatter) {
            ((NumberFormatter)formatter).setMaximum(max);
        }
    }

    public static abstract class SettingsOptionsPanelController<P extends SettingsPanel<P, C>, C extends SettingsOptionsPanelController<P, C>>
    extends OptionsPanelController {
        private P panel;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
        private boolean changed;

        public void update() {
            ((SettingsPanel)this.getPanel()).load();
            this.changed = false;
        }

        public void applyChanges() {
            SwingUtilities.invokeLater(() -> {
                ((SettingsPanel)this.getPanel()).store();
                this.changed = false;
            });
        }

        public void cancel() {
            if (this.isChanged()) {
                ((SettingsPanel)this.getPanel()).fireChanged();
            }
        }

        public boolean isValid() {
            return ((SettingsPanel)this.getPanel()).valid();
        }

        public boolean isChanged() {
            return this.changed;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public JComponent getComponent(Lookup masterLookup) {
            return this.getPanel();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        protected abstract P makePanel(C var1);

        private P getPanel() {
            if (this.panel == null) {
                this.panel = this.makePanel(this);
            }
            return this.panel;
        }

        void changed() {
            if (!this.changed) {
                this.changed = true;
                this.pcs.firePropertyChange("changed", false, true);
            }
            this.pcs.firePropertyChange("valid", null, null);
        }
    }

    protected static class Connector<T, C extends JComponent> {
        private final Class<T> type;
        private final Function<C, T> getter;
        private final BiConsumer<C, T> setter;
        private final BiConsumer<C, ActionListener> attacher;

        public Connector(Class<T> type, Function<C, T> getter, BiConsumer<C, T> setter, BiConsumer<C, ActionListener> attacher) {
            this.type = type;
            this.getter = getter;
            this.setter = setter;
            this.attacher = attacher;
        }

        public void load(C comp, Settings settings, String name) {
            this.setter.accept(comp, settings.get(this.type, name));
        }

        public void save(C comp, Settings settings, String name) {
            settings.set(name, this.getter.apply(comp));
        }

        public void attach(C comp, ActionListener a) {
            this.attacher.accept(comp, a);
        }
    }
}

