/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.script;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ScriptDefinition {
    private final List<String> paramNames = new ArrayList<String>();
    private PrintWriter output;
    private PrintWriter error;
    private String scriptFilename;
    private String code;
    private final Map<String, Object> globals = new LinkedHashMap<String, Object>();
    private final String mimeType;
    private String executeFunction;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public ScriptDefinition(String mimeType) {
        this.mimeType = mimeType;
    }

    public ScriptDefinition parameterNames(List<String> n) {
        this.paramNames.removeAll(n);
        this.paramNames.addAll(n);
        return this;
    }

    public ScriptDefinition code(String s) {
        this.code = s;
        return this;
    }

    public ScriptDefinition globals(Map<String, Object> globals) {
        this.globals.putAll(globals);
        return this;
    }

    public ScriptDefinition output(PrintWriter output) {
        this.output = output;
        return this;
    }

    public ScriptDefinition error(PrintWriter error) {
        this.error = error;
        return this;
    }

    public ScriptDefinition filename(String scriptFilename) {
        this.scriptFilename = scriptFilename;
        return this;
    }

    public ScriptDefinition setCode(String code) {
        this.code = code;
        return this;
    }

    public ScriptDefinition global(String name, Object value) {
        this.globals.put(name, value);
        return this;
    }

    public ScriptDefinition setParameter(String name, Object value) {
        if (!this.paramNames.contains(name)) {
            this.paramNames.add(name);
        }
        this.parameters.put(name, value);
        return this;
    }

    public List<String> getParamNames() {
        return Collections.unmodifiableList(this.paramNames);
    }

    public List<String> getGlobalNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.globals.keySet()));
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public PrintWriter getError() {
        return this.error;
    }

    public String getScriptFilename() {
        return this.scriptFilename;
    }

    public String getCode() {
        return this.code;
    }

    public Map<String, Object> getGlobals() {
        return Collections.unmodifiableMap(this.globals);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public ScriptDefinition executeFunction(String functionName) {
        this.executeFunction = functionName;
        return this;
    }

    public boolean isExecuteFunction() {
        return this.executeFunction != null;
    }

    public String getFunctionName() {
        return this.executeFunction;
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public ScriptDefinition copy() {
        ScriptDefinition res = new ScriptDefinition(this.mimeType).parameterNames(this.paramNames).code(this.code).globals(this.globals).output(this.output).error(this.error).filename(this.scriptFilename).executeFunction(this.executeFunction);
        for (String s : this.paramNames) {
            if (!this.parameters.containsKey(s)) continue;
            res.setParameter(s, this.parameters.get(s));
        }
        return res;
    }
}

