/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.problems;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptionsValidator;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferencesValidator;
import org.netbeans.modules.javascript.nodejs.problems.Bundle;
import org.netbeans.modules.javascript.nodejs.problems.CustomizerProblemResolver;
import org.netbeans.modules.javascript.nodejs.problems.NodeSourcesProblemResolver;
import org.netbeans.modules.javascript.nodejs.problems.OptionsProblemResolver;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.javascript.nodejs.util.ValidationUtils;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class NodeJsProblemsProvider
implements ProjectProblemsProvider {
    private static final RequestProcessor RP = new RequestProcessor(NodeJsProblemsProvider.class.getName(), 2);
    private final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    private final Project project;
    private final PreferenceChangeListener optionsListener = new OptionsListener();
    private final PreferenceChangeListener preferencesListener = new PreferencesListener();
    private final ChangeListener projectSourcesListener = new ProjectSourcesListener();
    private final FileChangeListener nodeSourcesListener = new NodeSourcesListener();
    private NodeJsSupport nodeJsSupport;

    public NodeJsProblemsProvider(Project project) {
        assert (project != null);
        this.project = project;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                if (!NodeJsProblemsProvider.this.getNodeJsSupport().getPreferences().isEnabled()) {
                    return Collections.emptyList();
                }
                ArrayList<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                NodeJsProblemsProvider.this.checkProjectSources(currentProblems);
                NodeJsProblemsProvider.this.checkOptions(currentProblems);
                NodeJsProblemsProvider.this.checkPreferences(currentProblems);
                NodeJsProblemsProvider.this.checkNodeSources(currentProblems);
                return currentProblems;
            }
        });
    }

    synchronized NodeJsSupport getNodeJsSupport() {
        if (this.nodeJsSupport == null) {
            this.nodeJsSupport = NodeJsSupport.forProject(this.project);
            this.addListeners();
        }
        return this.nodeJsSupport;
    }

    private void addListeners() {
        assert (this.nodeJsSupport != null);
        this.nodeJsSupport.getPreferences().addPreferenceChangeListener(this.preferencesListener);
        NodeJsOptions options = NodeJsOptions.getInstance();
        options.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.optionsListener, (Object)options));
        Sources sources = ProjectUtils.getSources((Project)this.project);
        sources.addChangeListener(WeakListeners.change((ChangeListener)this.projectSourcesListener, (Object)sources));
        FileUtil.addFileChangeListener((FileChangeListener)this.nodeSourcesListener, (File)NodeJsUtils.getNodeSources());
    }

    void checkProjectSources(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        if (NodeJsUtils.getSourceRoots(this.project).isEmpty()) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.NodeJsProblemProvider_sources_none_title(), (String)Bundle.NodeJsProblemProvider_sources_none_description(NodeJsUtils.getProjectDisplayName(this.project)), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "NO_SOURCES", "SOURCES"));
            currentProblems.add(problem);
        }
    }

    void checkOptions(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        NodeJsPreferences preferences = this.getNodeJsSupport().getPreferences();
        assert (preferences.isEnabled()) : this.project.getProjectDirectory().getNameExt();
        ValidationResult validationResult = new NodeJsOptionsValidator().validate(preferences.isDefaultNode(), false).getResult();
        if (validationResult.isFaultless()) {
            return;
        }
        String message = validationResult.getFirstErrorMessage();
        if (message == null) {
            message = validationResult.getFirstWarningMessage();
        }
        assert (message != null) : "Message should be found for invalid options";
        message = Bundle.NodeJsProblemProvider_error(message);
        ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)message, (String)message, (ProjectProblemResolver)new OptionsProblemResolver());
        currentProblems.add(problem);
    }

    void checkPreferences(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        ValidationResult validationResult = new NodeJsPreferencesValidator().validate(this.project, false).getResult();
        if (validationResult.isFaultless()) {
            return;
        }
        String message = validationResult.getFirstErrorMessage();
        if (message == null) {
            message = validationResult.getFirstWarningMessage();
        }
        assert (message != null) : "Message should be found for invalid preferences: " + this.project.getProjectDirectory().getNameExt();
        message = Bundle.NodeJsProblemProvider_error(message);
        ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)message, (String)message, (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "INVALID_PREFERENCES", validationResult));
        currentProblems.add(problem);
    }

    void checkNodeSources(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        final NodeExecutable node = NodeExecutable.forProject(this.project, false);
        if (node == null) {
            return;
        }
        if (EventQueue.isDispatchThread() && !node.versionDetected()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    node.getVersion();
                    NodeJsProblemsProvider.this.fireProblemsChanged();
                }
            });
            return;
        }
        File nodeSources = NodeJsUtils.getNodeSources(this.project);
        if (nodeSources == null || !nodeSources.isDirectory()) {
            String message = Bundle.NodeJsProblemProvider_error(Bundle.NodeJsProblemProvider_node_sources());
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)message, (String)message, (ProjectProblemResolver)new NodeSourcesProblemResolver(this.project));
            currentProblems.add(problem);
            return;
        }
        ValidationResult result = new ValidationResult();
        ValidationUtils.validateNodeSources(result, nodeSources.getAbsolutePath());
        if (!result.isFaultless()) {
            String message = result.getFirstErrorMessage();
            if (message == null) {
                message = result.getFirstWarningMessage();
            }
            assert (message != null) : result;
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createWarning((String)message, (String)message, (ProjectProblemResolver)new NodeSourcesProblemResolver(this.project));
            currentProblems.add(problem);
        }
    }

    void fireProblemsChanged() {
        this.problemsProviderSupport.fireProblemsChange();
    }

    private final class OptionsListener
    implements PreferenceChangeListener {
        private OptionsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            NodeJsProblemsProvider.this.fireProblemsChanged();
        }
    }

    private final class PreferencesListener
    implements PreferenceChangeListener {
        private PreferencesListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            NodeJsProblemsProvider.this.fireProblemsChanged();
        }
    }

    private final class ProjectSourcesListener
    implements ChangeListener {
        private ProjectSourcesListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NodeJsProblemsProvider.this.fireProblemsChanged();
        }
    }

    private final class NodeSourcesListener
    extends FileChangeAdapter {
        private NodeSourcesListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            NodeJsProblemsProvider.this.fireProblemsChanged();
        }
    }
}

