/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.base.LayerFactory;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbCollections;

public class ModuleLayeredFileSystem
extends MultiFileSystem
implements LookupListener {
    private static final long serialVersionUID = 782910986724201983L;
    static final Logger err = Logger.getLogger("org.netbeans.core.projects");
    private static Lookup.Result<FileSystem> fsResult = Lookup.getDefault().lookupResult(FileSystem.class);
    private static Lookup.Result<Repository.LayerProvider> layerResult = Lookup.getDefault().lookupResult(Repository.LayerProvider.class);
    private static Mutex mutex;
    private List<URL> urls;
    private List<URL> prevs;
    private LayerFactory manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;
    private final boolean addLookupBefore;
    private final boolean user;

    ModuleLayeredFileSystem(FileSystem writableLayer, boolean userDir, FileSystem[] extras, LayerFactory factory) throws IOException {
        this(writableLayer, userDir, extras, factory, factory.loadCache());
    }

    private ModuleLayeredFileSystem(FileSystem writableLayer, boolean addLookup, FileSystem[] otherLayers, LayerFactory mgr, FileSystem cacheLayer) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(writableLayer, addLookup, otherLayers, cacheLayer == null ? mgr.createEmptyFileSystem() : cacheLayer, addLookup));
        this.manager = mgr;
        this.writableLayer = writableLayer;
        this.otherLayers = otherLayers;
        this.cacheLayer = cacheLayer;
        this.addLookupBefore = addLookup;
        this.setPropagateMasks(true);
        this.urls = null;
        fsResult.addLookupListener((LookupListener)this);
        layerResult.addLookupListener((LookupListener)this);
        this.user = addLookup;
    }

    private static FileSystem[] appendLayers(FileSystem fs1, boolean addLookupBefore, FileSystem[] fs2s, FileSystem fs3, boolean addClasspathLayers) {
        ArrayList<Object> l = new ArrayList<Object>(fs2s.length + 2);
        l.add(fs1);
        if (addLookupBefore) {
            for (FileSystem f : fsResult.allInstances()) {
                if (Boolean.TRUE.equals(f.getRoot().getAttribute("fallback"))) continue;
                l.add(f);
            }
        }
        l.addAll(Arrays.asList(fs2s));
        l.add(fs3);
        if (addClasspathLayers) {
            List<URL> layerUrls = null;
            try {
                layerUrls = ModuleLayeredFileSystem.collectLayers(ModuleInfo.class.getClassLoader());
                if (!layerUrls.isEmpty()) {
                    XMLFileSystem xmlfs = new XMLFileSystem();
                    xmlfs.setXmlUrls(layerUrls.toArray(new URL[0]));
                    l.add(xmlfs);
                }
                err.log(Level.FINE, "Loading classpath layers: {0}", layerUrls);
            }
            catch (Exception x) {
                err.log(Level.WARNING, "Setting layer URLs: " + layerUrls, x);
            }
        }
        if (!addLookupBefore) {
            for (FileSystem f : fsResult.allInstances()) {
                if (!Boolean.TRUE.equals(f.getRoot().getAttribute("fallback"))) continue;
                l.add(f);
            }
        }
        return l.toArray(new FileSystem[0]);
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        SystemFileSystem sfs;
        try {
            sfs = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new AssertionError((Object)ex);
        }
        ModuleLayeredFileSystem home = sfs.getInstallationLayer();
        if (home != null) {
            return home;
        }
        return sfs.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem sfs;
        try {
            sfs = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new AssertionError((Object)ex);
        }
        return sfs.getUserLayer();
    }

    public void setURLs(List<URL> urls) throws Exception {
        assert (mutex == null || mutex.isWriteAccess());
        if (urls == null) {
            urls = this.prevs;
        }
        if (urls == null) {
            return;
        }
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        if (err.isLoggable(Level.FINE)) {
            err.log(Level.FINE, "setURLs: {0}", urls);
        }
        List<URL> orig = urls;
        if (this == ModuleLayeredFileSystem.getInstallationModuleLayer()) {
            urls = this.manager.additionalLayers(urls);
        }
        if (this.urls != null && urls.equals(this.urls)) {
            err.fine("no-op");
            return;
        }
        if (this.urls != null || this.cacheLayer == null) {
            if (this.cacheLayer == null) {
                this.cacheLayer = this.manager.createEmptyFileSystem();
            }
            this.cacheLayer = this.manager.store(this.cacheLayer, urls);
            err.log(Level.FINEST, "changing delegates");
            this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookupBefore, this.otherLayers, this.cacheLayer, this.addLookupBefore));
            err.log(Level.FINEST, "delegates changed");
        }
        this.urls = urls;
        this.prevs = orig;
        this.firePropertyChange("layers", null, null);
    }

    public void addURLs(Collection<URL> urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        ArrayList<URL> arr = new ArrayList<URL>(urls);
        if (this.prevs != null) {
            arr.addAll(this.prevs);
        }
        this.setURLs(arr);
    }

    public void removeURLs(Collection<URL> urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        ArrayList<URL> arr = new ArrayList<URL>();
        if (this.prevs != null) {
            arr.addAll(this.prevs);
        }
        arr.removeAll(urls);
        this.setURLs(arr);
    }

    public void resultChanged(final LookupEvent ev) {
        class ProcessEv
        implements Mutex.Action<Void> {
            ProcessEv() {
            }

            public Void run() {
                if (ev.getSource() == fsResult) {
                    ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.addLookupBefore, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer, ModuleLayeredFileSystem.this.addLookupBefore));
                    return null;
                }
                if (ev.getSource() == layerResult) {
                    if (ModuleLayeredFileSystem.this.prevs != null) {
                        try {
                            ModuleLayeredFileSystem.this.setURLs(ModuleLayeredFileSystem.this.prevs);
                        }
                        catch (Exception ex) {
                            err.log(Level.INFO, null, ex);
                        }
                    }
                    return null;
                }
                throw new IllegalStateException("Unknown source: " + ev.getSource());
            }
        }
        ProcessEv pev = new ProcessEv();
        if (mutex != null) {
            mutex.writeAccess((Mutex.Action)pev);
        } else {
            pev.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> collectLayers(ClassLoader loader) throws IOException {
        ArrayList<URL> layerUrls = new ArrayList<URL>();
        for (URL manifest : NbCollections.iterable(loader.getResources("META-INF/MANIFEST.MF"))) {
            try (InputStream is = manifest.openStream();){
                Manifest mani = new Manifest(is);
                String layerLoc = mani.getMainAttributes().getValue("OpenIDE-Module-Layer");
                if (layerLoc == null) continue;
                URL layer = loader.getResource(layerLoc);
                if (layer != null) {
                    layerUrls.add(layer);
                    continue;
                }
                err.log(Level.WARNING, "No such layer: {0}", layerLoc);
            }
        }
        for (URL generatedLayer : NbCollections.iterable(loader.getResources("META-INF/generated-layer.xml"))) {
            layerUrls.add(generatedLayer);
        }
        return layerUrls;
    }

    static void registerMutex(Mutex m) {
        mutex = m;
    }
}

