/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.impl.actions.Bundle;
import org.graalvm.visualizer.source.impl.actions.LocationAction;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class GoStackUpDownAction
extends LocationAction {
    public static final String ACTION_GO_DOWN = "org.graalvm.visualizer.source.impl.actions.GoStackDown";
    public static final String ACTION_GO_UP = "org.graalvm.visualizer.source.impl.actions.GoStackUp";
    public static final String CATEGORY = "CallStack";
    private final boolean goUp;
    private final NodeLocationContext context;

    private GoStackUpDownAction(boolean goUp) {
        this.goUp = goUp;
        this.context = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
    }

    private GoStackUpDownAction(boolean goUp, Lookup context) {
        super(context);
        this.goUp = goUp;
        this.context = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new GoStackUpDownAction(this.goUp, actionContext);
    }

    public static GoStackUpDownAction createUpAction() {
        return new GoStackUpDownAction(true);
    }

    public static GoStackUpDownAction createDownAction() {
        return new GoStackUpDownAction(false);
    }

    @Override
    protected void actionPerformed(ActionEvent e, InputGraph g, InputNode[] nodes) {
        NodeStack.Frame next;
        Node[] activatedNodes = this.activeNodes();
        NodeStack.Frame frame = (NodeStack.Frame)activatedNodes[0].getLookup().lookup(NodeStack.Frame.class);
        if (frame == null) {
            return;
        }
        NodeStack.Frame frame2 = next = this.goUp ? frame.getParent() : frame.getNested();
        if (next != null) {
            this.context.setSelectedLocation(next);
        }
    }

    @Override
    protected boolean computeEnabled(InputGraph graph, InputNode[] nodes) {
        Node[] activatedNodes = this.activeNodes();
        if (activatedNodes.length != 1) {
            return false;
        }
        NodeStack.Frame l = (NodeStack.Frame)activatedNodes[0].getLookup().lookup(NodeStack.Frame.class);
        if (l == null) {
            return false;
        }
        return this.goUp ? l.getParent() != null : l.getNested() != null;
    }

    @Override
    public String getName() {
        return this.goUp ? Bundle.ACTION_GotoStackUp() : Bundle.ACTION_GotoStackDown();
    }

    @Override
    protected String iconResource() {
        return this.goUp ? "org/graalvm/visualizer/source/resources/disassembler_step_out.gif" : "org/graalvm/visualizer/source/resources/disassembler_step_into.gif";
    }

    static class D
    extends GoStackUpDownAction {
        public D() {
            super(false);
        }
    }

    static class U
    extends GoStackUpDownAction {
        public U() {
            super(true);
        }
    }
}

